﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>用户</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><ul class="area-genre">
        <li id="regInfo">注册信息</li>
        <li id="loginLog" class="hover">登录日志</li>
      </ul>
      <i>我的信息</i></h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="15%">用户名</th>
          <th width="30%" class="border-left">登录IP - 地点</th>
          <th width="15%" class="border-left">登录时间</th>
          <th width="10%" class="border-left">状态</th>
          <th width="30%" class="border-left">备注</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top">
              <td align="center">${map.user.username}</td>
              <td class="border-left">&nbsp;${map.ip} - ${map.address}</td>
              <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
              <td align="center" class="border-left"><gen:if test='${map.status == 1}'><span class="green">成功</span><gen:else /><span class="red">失败</span></gen:if></td>
              <td class="border-left">&nbsp;${map.remark}</td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="5" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="5"><div class="th-left">&nbsp;</div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $regInfo = $('#regInfo');
	var $loginLog = $('#loginLog');
	
	// 注册信息
	$regInfo.bind('click', function () {
		location.href = 'i_user!view.gen';
	});
	// 登录日志
	$loginLog.bind('click', function () {
		location.href = 'i_user!list.gen';
	});
});
</script>
</body>
</html>
