﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>消息</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>${ums.fromName}</i></h2>
    <div class="area-content" style="padding:10px;"></div>
  </div>
  <gen:if test="${isReply}">
  <div class="area">
    <h2 id="reply"><i>消息回复</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="i_ums!reply.gen">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right"> 接收者：</td>
            <td>${ums.fromName}
            <input type="hidden" name="to" id="to" value="${ums.fromName}" />
            <input type="hidden" name="topId" id="topId" value="${ums.topId}" /></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top">回复内容：</td>
            <td><table border="0" cellspacing="0" cellpadding="0">
                <tr class="ignore">
                  <td><input type="hidden" name="subject" value="回复：${ums.subject}" /><textarea id="content" name="content" class="text small textarea general"></textarea></td>
                  <td valign="top"><label for="content" generated="true" class="tip normal" tip=""></label></td>
                </tr>
              </table></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
            	<input name="submit" class="button blue small" type="submit" value="确 定" />
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
  </gen:if>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){	
	// 变量
	var id = '${ums.topId}';
	var fromId = '${ums.fromId}';
	var isReply = ${isReply};
	var replyId = 0; 	// 最后回复消息id
	var time = 0; 		// 最后加载时间戳
	
	var $show = $('.area-content');
	
	// 加载
	var timer = 'listTimer'; // 定时器名称
	function loadView() {
		$.ajax({
			url: 'i_ums!viewJSON.gen'
			,data:{
				'id': id,
				'time': time
			}
			,beforeSend: function (xhr) {}
			,error: function (xhr, status, error) {$('body').stopTime(timer);}
			,success: function(result) {
				// {'status':false,'message':'message', 'store':[{'id':'id','fromId':'fromId','fromName':'fromName','toId':'toId','topId':'topId','toName':'toName','subject':'subject','content':'content','time':'time','date':'2013-12-20'}]}
				if (result) {
					if (result.status) {
						var store = result.store;
						if (store.length>0) {
							var html = '';
							for ( var i=0; i<store.length; i++) {
								if(store[i].id == replyId) break; // 刚回复的消息不显示
								if(fromId == store[i].fromId){
									html = '<div class="ums_box ums_arrow"><div class="bubble">'+grapes.nrbr(store[i].content)+'</div>'
										+ '		<div class="menu">';
									if(isReply){
										html += '		<a href="javascript:void(0);" class="reply" val="'+store[i].topId+'">回复</a>&nbsp;&nbsp;';
									}
									html += '			<a href="javascript:void(0);" class="delete" val="'+store[i].id+'">删除</a>发送时间：'+store[i].date
										 + '		</div>'
										 + '	</div>';
								}else{
									html = '<div class="ums_right ums_box ums_arrow"><div class="bubble">'+grapes.nrbr(store[i].content)+'</div>'
										+ '		<div class="menu">'
										+ '			<a href="javascript:void(0);" class="delete" val="'+store[i].id+'">删除</a>发送时间：'+store[i].date
										+ '		</div>'
										+ '	</div>';
								}
								$show.append(html);
								time = store[i].time;
							}
						}
					}else{
						alert(result.message);
					}
				}
			}
		});
	}
	
	// 回复
	$show.delegate('a.reply', 'click', function () {
		$('html, body').animate({scrollTop: $('#reply').offset().top}, 1000);
	});
	
	// 删除
	$show.delegate('a.delete', 'click', function () {
		var id = $(this).attr('val'); $temp = $(this).closest(".ums_box");
		$dialog.confirm('您确定要删除吗？', function() {
			$.ajax({
				url: 'i_ums!delete.gen',
				data: {ids: id},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
		return false;
	});
	
	
	var $form = $('#form');
	var $reset = $('input:reset');
	// 表单验证
	var validate = $form.validate({
		rules: {
			 content: {
				required: true
			}
		},
		messages: {
			content: {
				required: "内容不允许为空！"
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id','fromId':'fromId','fromName':'fromName','toId':'toId','topId':'topId','toName':'toName','subject':'subject','content':'content','time':'time','date':'2013-12-20'}}
					if (result) {
						if (result.status) {
							var store = result.store;
							var html = '<div class="ums_right ums_box ums_arrow"><div class="bubble">'+grapes.nrbr(store.content)+'</div>'
								+ '		<div class="menu">'
								+ '			<a href="javascript:void(0);" class="delete" val="'+store.id+'">删除</a>发送时间：'+store.date
								+ '		</div>'
								+ '	</div>';
							$show.append(html);
							replyId = store.id;
						}else{
							alert(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
	
	// --------------------------
	
	// 定时器
	loadView();
	$('body').stopTime(timer); $('body').everyTime('5s', timer, loadView, 0, true);
	$(window).bind('beforeunload', function(){
		$('body').stopTime(timer);
		return ;
	});
});
</script>
</body>
</html>
