﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>留言板</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>查看/回复留言</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="guestbook!update.gen">
        <table width="100%" align="center" class="table form-table">
          <tr>
            <td class="tdl">主题：</td>
            <td colspan="3">${map.subject}【${map.category}】</td>
          </tr>
          <tr>
            <td valign="top" class="tdl">内容：</td>
            <td colspan="3" valign="top" style="line-height:20px;">${gen:nrbr(map.content)}</td>
          </tr>
          <tr>
            <td class="tdl">联系人：</td>
            <td width="35%">${map.name}</td>
            <td class="tdl">电子邮箱：</td>
            <td>${map.email}</td>
          </tr>
          <tr>
            <td class="tdl">联系手机：</td>
            <td>${map.phone}</td>
            <td class="tdl">提交时间：</td>
            <td>${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          </tr>
          <tr>
            <td class="tdl">提交者：</td>
            <td>${empty map.user ? '网友':map.username}</td>
            <td class="tdl">提交IP：</td>
            <td>${map.ip}&nbsp;&nbsp;来自：${map.address}</td>
          </tr>
          <tr>
            <td class="tdl">所属状态：</td>
            <td><gen:if test="${map.status == 0}"><i class="red">待审核</i><gen:elseif test="${map.status == 1}" /><i class="orange">待回复</i><gen:else /><i class="green">已回复</i></gen:if></td>
            <td class="tdl">允许公开：</td>
            <td><label><input name="isPublic" type="radio" value="0" ${map.isPublic==0 ? 'checked':''}/>否</label>
            <label><input name="isPublic" type="radio" value="1" ${map.isPublic==1 ? 'checked':''}/>是</label></td>
          </tr>
          <tr>
            <td valign="top" class="tdl">留言回复：</td>
            <td colspan="3" valign="top"><table border="0" cellspacing="0" cellpadding="0">
                <tr class="ignore">
                  <td><textarea id="reply" name="reply" class="text small textarea general">${map.reply}</textarea></td>
                  <td valign="top"><label for="reply" generated="true" class="tip normal" tip=""></label></td>
                </tr>
              </table></td>
          </tr>
          <tr>
            <td class="tdl">回复时间：</td>
            <td colspan="3"><input name="replyTime" type="text" class="text small ignore" id="replyTime" value="${gen:dateTime(map.replyTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}" size="20" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss', maxDate:'2080-12-12 00:00:00'});" />
              <label for="replyTime" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr>
            <td colspan="4" align="center" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input type="hidden" name="id" value="${map.id}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){	
	// 表单验证
	var $form = $('#form'),$reset = $('input:reset');
	var validate = $form.validate({
		rules: {
			reply: {required: true}
		},
		messages: {
			reply: {required: "不允许为空"}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
});
</script>
</body>
</html>