﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>留言板</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a> 
        <a href="javascript:void(0);" class="button tiny category <gen:if test="${empty param.category || param.category==''}">blue<gen:else />gray blue-hover</gen:if>" val=""><i></i>全部</a>
        <c:forEach items="${categoryList}" var="category">
        <a href="javascript:void(0);" class="button tiny category <gen:if test='${category.name == param.category}'>blue <gen:else />gray blue-hover</gen:if>" val="${category.name}"><i></i>${category.name}</a>
        </c:forEach></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2> <i>留言板</i> </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="55%" class="border-left">主题</th>
          <th width="5%" class="border-left">公开</th>
          <th width="5%" class="border-left">状态</th>
          <th width="15%" class="border-left">时间</th>
          <th width="15%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top" id="${map.id}">
              <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
              <td class="border-left">[${map.category}]<a href="javascript:void(0);" class="view" title="查看/回复">&nbsp;${gen:substring(map.subject, 50, '…')}</a></td>
              <td align="center" class="border-left"><gen:if test="${map.isPublic == 0}"><i class="orange">否</i><gen:else /><i class="green">是</i></gen:if></td>
              <td align="center" class="border-left disable"><gen:if test="${map.status == 0}"><i class="red">待审核</i><gen:elseif test="${map.status == 1}" /><i class="orange">待回复</i><gen:else /><i class="green">已回复</i></gen:if></td>
              <td align="center" class="border-left" title="${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}">${gen:dateTime(map.time, 'yyyy-MM-dd', config.timezoneid)}</td>
              <td align="center" class="border-left"><a href="javascript:void(0);" class="view" title="查看/回复">查看/回复</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="delete">删除</a></td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="6" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="6"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover pass"><i></i>审核通过</a><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">条件： </td>
            <td><select name="find">
                <option value="subject" <gen:if test="${param.find=='subject'}">selected</gen:if>>主题</option>
                <option value="ip" <gen:if test="${param.find=='ip'}">selected</gen:if>>IP</option>
              </select>
            	&nbsp;&nbsp;状态：
              <select name="status">
                <option value="" <gen:if test="${empty param.status}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.status=='0'}">selected</gen:if>>待审核</option>
                <option value="1" <gen:if test="${param.status=='1'}">selected</gen:if>>待回复</option>
                <option value="2" <gen:if test="${param.status=='2'}">selected</gen:if>>已回复</option>
              </select>
              &nbsp;&nbsp;按
              <select name="orderBy">
                <option value="status" <gen:if test="${param.orderBy=='status'}">selected</gen:if>>状态</option>
                <option value="time" <gen:if test="${param.orderBy=='time'}">selected</gen:if>>时间</option>
              </select>
              <select name="order">
                <option value="asc" <gen:if test="${param.orderBy=='asc'}">selected</gen:if>>升序</option>
                <option value="desc" <gen:if test="${param.orderBy=='desc'}">selected</gen:if>>降序</option>
              </select>&nbsp;排序
              <input type="hidden" name="order" value="desc" /></td>
          </tr>
          <tr class="border-top">
            <td align="right">关键字： </td>
            <td><input type="text" name="keyword" class="text small" title="关键字" value="${gen:text(param.keyword,true,true)}" size="65"/></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="category" id="category" value="${param.category}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->
<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $add = $('.push a.add');
	var $view = $('.table a.view');
	var $pass = $('.table a.pass');
	var $delete = $('.table a.delete');
	var $pages = $('.table .pages');
	
	var $search = $('#search');
	var $category = $('#category');
	var $categoryA = $('.push a.category');
	$categoryA.bind('click', function () {
		var value = $(this).attr('val');
		$category.attr('value', value);
		$search.find(':submit').click(); // $search.submit();
	});
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 添加
	$add.bind('click', function () {
		return addTab('添加留言', 'guestbook!add.gen', 'guestbook_add');
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'guestbook!view.gen?id='+id, 'guestbook_view_'+id);
	});
	
	// 审核通过
	$pass.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定通过编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定通过选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'guestbook!pass.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								reflesh();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'guestbook!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
</script>
</body>
</html>
