﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>留言板</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>${empty param.id ? '添加':'编辑'}留言</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="${empty param.id ? 'guestbook!save.gen':'guestbook!update.gen'}">
        <table width="100%" align="center" class="table form-table">
          <tr>
            <td class="tdl">分类：</td>
            <td colspan="3"><span class="field"><c:forEach items="${categoryList}" var="cate">
              <label><input type="radio" name="category" value="${cate.name}" ${guestbook.category == cate.name? 'checked':''}/>${cate.name}</label>&nbsp;
              </c:forEach></span></td>
          </tr>
          <tr>
            <td class="tdl">主题：</td>
            <td colspan="3"><span class="field"><input name="subject" type="text" class="text small" size="60" value="${guestbook.subject}" />
            <label><input name="isPublic" type="checkbox" value="1" ${guestbook.isPublic==1 ? 'checked':''}/>允许公开</label></span></td>
          </tr>
          <tr>
            <td valign="top" class="tdl"><i>*</i>&nbsp;内容：</td>
            <td colspan="3"><table class="ignore">
                <tr class="ignore">
                  <td><textarea id="content" name="content" class="text small textarea general">${gen:brnr(guestbook.content)}</textarea></td>
                  <td valign="top"><label for="content" generated="true" class="tip normal" tip=""></label></td>
                </tr>
              </table></td>
          </tr>
          <tr>
            <td class="tdl">联系人：</td>
            <td><input name="name" type="text" class="text small" size="30" value="${guestbook.name}" /></td>
            <td class="tdl">电子邮箱：</td>
            <td><input name="email" type="text" class="text small" size="30" value="${guestbook.email}" /></td>
          </tr>
          <tr>
            <td class="tdl">联系手机：</td>
            <td><input name="phone" type="text" class="text small" size="30" value="${guestbook.phone}" /></td>
            <td class="tdl">提交时间：</td>
            <td><input id="time" name="time" type="text" class="text small ignore" value="${gen:dateTime(guestbook.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}" size="25" onfocus="WdatePicker({dateFmt:'yyyy-MM-dd HH:mm:ss'});" />
              <label for="time" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr>
            <td class="tdl">所属状态：</td>
            <td><span class="field">
              <label><input type="radio" name="status" value="0" ${(empty guestbook.status || guestbook.status==0)?'checked':''}/>待审核</label>&nbsp;
              <label><input type="radio" name="status" value="1" ${guestbook.status==1?'checked':''}/>待回复</label>&nbsp;
              <label><input type="radio" name="status" value="2" ${guestbook.status==2?'checked':''}/>已回复</label>
              </span></td>
            <td class="tdl">接收对象：</td>
            <td>&nbsp;<input type="hidden" name="adminId" value="${admin.id}" />
              <a href="javascript:void(0);" id="adminChoose">${empty admin ? '选择管理员':admin.name}</a>
              <gen:if test='${platAdmin}'>&nbsp;&nbsp;&nbsp;&nbsp;<input type="hidden" name="departmentId" value="${department.id}" />
              <a href="javascript:void(0);" id="departmentChoose">${empty department ? '选择部门':department.name}</a> </gen:if></td>
          </tr>
          <tr>
            <td colspan="4" align="center" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input type="hidden" name="id" value="${guestbook.id}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){	
	// 表单验证
	var $form = $('#form'),$reset = $('input:reset');
	var validate = $form.validate({
		rules: {
			content: {
				required: true
			}
		},
		messages: {
			content: {
				required: "内容不允许为空！"
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
	
	// 管理员选择
	var $adminChoose = $('#adminChoose'), $adminId = $('input[name="adminId"]');
	$adminChoose.bind('click',function(){
		var dialog = $dialog.iframe('admin!choose.gen', {title: '管理员', width:'650px', height:'300px', resize: false});
		dialog.callback = function(obj) {
			$adminId.prop('value', obj.id);
			$adminChoose.text(obj.name);
		}
	});
	// 部门选择
	var $departmentChoose = $('#departmentChoose'), $departmentId = $('input[name="departmentId"]');
	$departmentChoose.bind('click',function(){
		var dialog = $dialog.iframe('department!choose.gen?radio=true&pcheck=true&ids='+$departmentId.prop('value')+'&names='+$departmentChoose.text(),
			{title: '选择部门', width:'230px', height:'300px', resize: false});
		dialog.callback = function(obj) {
			if(grapes.isNotEmpty(obj.ids) && grapes.isNotEmpty(obj.names)){
				$departmentId.prop('value', obj.ids);
				$departmentChoose.text(obj.names);
			}
		}
	});
	
});
</script>
</body>
</html>