﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>管理员</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>添加管理员</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="admin!save.gen">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">用户名：</td>
            <td><input type="text" name="username" id="username" class="text small" />
            <label for="username" generated="true" class="tip normal" tip="以英文字母开头，可加数字或下划线！"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">登录密码：</td>
            <td><input name="password" type="password" id="password" class="text small" size="30" />
              <label for="password" generated="true" class="tip normal" tip="密码至少需要 6 个字符！"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">密码强度：</td>
            <td><div class="passwords"><span class="safe0">弱</span><span class="safe1">中</span><span class="safe2">强</span></div></td>
          </tr>
          <tr class="border-top">
            <td align="right">确认密码：</td>
            <td><input name="repassword" type="password" class="text small" id="repassword" size="30" />
              <label for="repassword" generated="true" class="tip normal" tip="与登录密码保持一致！"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">联系邮箱：</td>
            <td><input name="email" type="text" class="text small" id="email" size="35" />
            <label for="email" generated="true" class="tip normal" tip=""></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">联系手机：</td>
            <td><input name="mobile" type="text" class="text small" id="mobile" size="35" />
            <label for="mobile" generated="true" class="tip normal" tip=""></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">管理姓名：</td>
            <td><input type="text" name="name" class="text small" />
            <label for="name" generated="true" class="tip normal" tip="长度保持在50个字节之内[一个中文算两个字节]"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">管理角色：</td>
            <td>
              <select name="roleId">
                <c:forEach items="${adminRoleList}" var="adminRole">
                <option value="${adminRole.id}" <gen:if test="${adminRole.isDefault == 1}">selected="selected"</gen:if>>${adminRole.name}</option>
                </c:forEach>
              </select></td>
          </tr>
          <tr class="border-top">
            <td align="right">所属部门：</td>
            <td><input name="departmentId" type="hidden" value="" />
            <input name="departmentName" to="departmentId" type="text" class="text small" value="" size="20" readonly="readonly" />
            <label for="departmentName" generated="true" class="tip normal"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">管理属性：</td>
            <td><label><input name="isDisabled" type="checkbox" value="1" />
            	禁用</label>&nbsp;&nbsp;<label><input name="isRepeated" type="checkbox" value="1" <gen:if test='${user.isRepeated == 1}'>checked</gen:if> />
                允许多处登录</label></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top"> 备 注：</td>
            <td><textarea name="remark" class="text small textarea general"></textarea></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.passwords.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<script type="text/javascript" src="${config.statie}ui/admin/js/tree.js"></script>
<!-- 当前页面 -->
<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $form = $('#form');
	var $reset = $('input:reset');
	
	// 表单验证
	var validate = $form.validate({
		rules: {
			username: {
				required: true,
				rangelength: [3, 20],
				username: true,
				remote: jspgen.isRegexVerify(null, 'username', function(){return encodeURIComponent($('#username').val());}, true)
			}
			,password: {
				required: true,
				rangelength: [6, 20]
			}
			,repassword: {
				required: true,
				equalTo: "#password"
			}
			,email: {
				required: true,
				email: true,
				remote: jspgen.isRegexVerify(null, 'email', function(){return encodeURIComponent($('#email').val());}, true)
			}
			,mobile: {
				required: true,
				mobile: true,
				remote: jspgen.isRegexVerify(null, 'mobile', function(){return encodeURIComponent($('#mobile').val());}, true)
			}
			,name: {
				required: true,
				rangebyte: [4, 50]
			}
		},
		messages: {
			username: {
				required: '用户名不允许为空！',
				rangelength: $.format('用户名长度需要保持在{0}-{1}之间！')
			}
			,password: {
				required: '请输入密码！',
				rangelength: $.format('密码长度需要保持在{0}-{1}之间！')
			}
			,repassword: {
				required: '请输入确认密码！',
				equalTo: '两次密码输入不一致！'
			}
			,email: {
				required: '请输入邮箱地址！',
				remote: '邮箱地址错误！'
			}
			,mobile: {
				required: '请输入手机号码！'
			}
			,name: {
				required: '姓名不允许为空！'
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		$('.passwords').removeClass().addClass('passwords');
		validate.resetForm();
	});
});
</script>
</body>
</html>
