﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>管理员</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>编辑信息</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="admin!update.gen">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right"> 管理姓名：</td>
            <td><input type="text" name="name" class="text small" value="${admin.name}" />
            <label for="name" generated="true" class="tip normal" tip="长度保持在50个字节之内[一个中文算两个字节]"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">管理角色：</td>
            <td>
              <select name="roleId">
                <c:forEach items="${adminRoleList}" var="adminRole">
                <option value="${adminRole.id}" <gen:if test="${adminRole.id == admin.roleId}">selected="selected"</gen:if>>${adminRole.name}</option>
                </c:forEach>
              </select></td>
          </tr>
          <tr class="border-top">
            <td align="right">所属部门：</td>
            <td><input name="departmentId" type="hidden" value="${admin.departmentId}" />
            <input name="departmentName" to="departmentId" type="text" class="text small" value="${admin.department.name}" size="20" readonly="readonly" />
            <label for="departmentName" generated="true" class="tip normal"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right"> 管理属性：</td>
            <td><label><input name="isDisabled" type="checkbox" value="1" <gen:if test='${admin.isDisabled == 1}'>checked="checked"</gen:if>/>
            	禁用</label>&nbsp;&nbsp;
                <label><input name="isRepeated" type="checkbox" value="1" <gen:if test='${user.isRepeated == 1}'>checked</gen:if> />
                允许多处登录</label></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top">备 注：</td>
            <td><textarea name="remark" class="text small textarea general">${admin.remark}</textarea></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input type="hidden" name="id" value="${admin.id}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<script type="text/javascript" src="${config.statie}ui/admin/js/tree.js"></script>
<!-- 当前页面 -->
<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $form = $('#form');
	var $reset = $('input:reset');
	
	// 表单验证
	var validate = $form.validate({
		rules: {
			name: {
				required: true,
				rangebyte: [4, 50]
			}
		},
		messages: {
			name: {
				required: '姓名不允许为空！'
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
});
</script>
</body>
</html>
