﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>微信公众号</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2>
      <i>${wechat.name}-${wechatTemp.title}-群发日志</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="22%" class="border-left">Openid</th>
          <th width="15%" class="border-left">昵称</th>
          <th width="8%" class="border-left">发送状态</th>
          <th width="15%" class="border-left">发送时间</th>
          <th width="35%" class="border-left">接口响应</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}" appid="${map.appid}" tempid="${map.tempid}">
          <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
          <td align="center" class="border-left">${map.openid}</td>
          <td class="border-left">&nbsp;${map.nickname}</td>
          <td align="center" class="border-left">${map.status=='0'?'<span class="green">成功</span>':'<span class="red">失败</span>'}</td>
          <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="center" class="border-left">${map.resp}</td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="6" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top" appid="${param.appid}" tempid="${param.tempid}">
          <th colspan="6"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a><a href="javascript:void(0);" class="button gray tiny blue-hover clear"><i></i>全部清空</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
      	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">关键字：</td>
            <td><input type="hidden" name="find" value="nickname,openid" /><input type="text" name="keyword" class="text small" title="关键字" value="${param.keyword}" placeholder="请输入昵称或Openid" size="50"/>&nbsp;&nbsp;
            状态：<select name="status">
                <option value="" ${empty param.status?'selected':''}>不限</option>
                <option value="0" ${param.status=='0'?'selected':''}>成功</option>
                <option value="1" ${param.status=='1'?'selected':''}>失败</option>
            </select></td>
          </tr>
          <tr class="border-top">
            <td align="right">发送时间： </td>
            <td><input id="startTime" name="startTime" type="text" class="text small" size="15" onfocus="WdatePicker({maxDate:'#F{$dp.$D(\'endTime\')||\'%y-%M-%d\'}'});" value="${param.startTime}" />
              <label for="startTime" generated="true" class="ico-tips date-picker"></label>
              &nbsp;~&nbsp;
              <input id="endTime" name="endTime" type="text" class="text small" size="15" onfocus="WdatePicker({minDate:'#F{$dp.$D(\'startTime\')}',maxDate:'%y-%M-%d'});" value="${param.endTime}" />
              <label for="endTime" generated="true" class="ico-tips date-picker"></label>
              &nbsp;
            <input to="startTime,endTime" class="button green tiny resetDate" type="button" value="清空" /></td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c"><input type="hidden" name="appid" value="${param.appid}" />
            <input type="hidden" name="tempid" value="${param.tempid}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" />
              </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 全选/反选
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 变量
	var $delete = $('.table a.delete');
	var $clear = $('.table a.clear');
	var $clearTd = $('.table td:not(.ignore)');
	var $pages = $('.table .pages');
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'wechat_sendlog!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	// 全部清空
	$clear.bind('click', function () {
		var tempid = $(this).closest('tr').attr('tempid');
		if($clearTd.length <= 0) {
			$dialog.alert('暂无数据'); return false;
		}
		$temp = $clearTd.closest('tr');
		$dialog.confirm('确定清空数据吗？', function() {
			$.ajax({
				url: 'wechat_sendlog!clear.gen',
				data: {tempid: tempid},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove(); $pages.hide();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});	
});
</script>
</body>
</html>