﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>微信公众号</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr appid="${wechat.appid}">
        <td align="left"><a href="javascript:void(0);" class="button tiny blue blue-hover fanslist"><i></i>粉丝列表</a>
        <a href="javascript:void(0);" class="button tiny gray blue-hover templist"><i></i>模板列表</a>
        <a href="javascript:void(0);" class="button tiny gray blue-hover sendlist"><i></i>群发信息</a></td>
        <td align="right"><a href="javascript:void(0);" class="button tiny orange synch"><i></i>同步公众号粉丝</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2>
      <i>${wechat.name} 粉丝列表<a href="javascript:void(0);" style="color:#5F5F5F;cursor:default;">最后同步时间：${gen:dateTime(wechat.fanslast, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</a></i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="22%">Openid</th>
          <th width="5%" class="border-left">头像</th>
          <th width="20%" class="border-left">昵称</th>
          <th width="5%" class="border-left">性别</th>
          <th width="15%" class="border-left">所在城市</th>
          <th width="15%" class="border-left">关注时间</th>
          <th width="18%" class="border-left">备注</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}" appid="${map.appid}">
          <td align="center">${map.openid}</td>
          <td align="center" class="border-left"><gen:if test="${not empty map.headurl}"><img src="${map.headurl}" width="30" height="30" /></gen:if></td>
          <td class="border-left">&nbsp;${map.nickname}</td>
          <td align="center" class="border-left">${map.sex=='1' ? '男' : map.sex=='2' ? '女':'未知'}</td>
          <td align="center" class="border-left">${map.country}${map.province}${map.city}</td>
          <td align="center" class="border-left">${gen:dateTime(map.substime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="center" class="border-left">${map.remark}</td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="7" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="7"><div class="th-left"></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
      	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">关键字： </td>
            <td><input type="hidden" name="find" value="openid,nickname" /><input type="text" name="keyword" class="text small" title="关键字" value="${param.keyword}" placeholder="请输入昵称或Openid" size="50"/>&nbsp;&nbsp;
            性别：<select name="sex">
            	<option value="" <gen:if test="${empty param.sex || param.sex==''}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.sex=='0'}">selected</gen:if>>未知</option>
                <option value="1" <gen:if test="${param.sex=='1'}">selected</gen:if>>男</option>
                <option value="2" <gen:if test="${param.sex=='2'}">selected</gen:if>>女</option>
            </select></td>
          </tr>
          <tr class="border-top">
            <td align="right">关注时间： </td>
            <td><input id="startTime" name="startTime" type="text" class="text small" size="15" onfocus="WdatePicker({maxDate:'#F{$dp.$D(\'endTime\')||\'%y-%M-%d\'}'});" value="${param.startTime}" />
              <label for="startTime" generated="true" class="ico-tips date-picker"></label>
              &nbsp;~&nbsp;
              <input id="endTime" name="endTime" type="text" class="text small" size="15" onfocus="WdatePicker({minDate:'#F{$dp.$D(\'startTime\')}',maxDate:'%y-%M-%d'});" value="${param.endTime}" />
              <label for="endTime" generated="true" class="ico-tips date-picker"></label>
              &nbsp;
            <input to="startTime,endTime" class="button green tiny resetDate" type="button" value="清空" /></td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c"><input type="hidden" name="appid" value="${wechat.appid}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" />
              </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 日期清空
	var $resetDate = $('.resetDate');
	$resetDate.bind('click', function () {
		var $parent = $(this).parent();
		var toArr = ($(this).attr('to')).split(',');
		if(toArr!=null && toArr.length>0) {
			for(i in toArr) $parent.find('input[name="'+toArr[i]+'"]').prop('value', '');
		}
	});
	
	// 变量
	var $aclick = true; // 禁用点击事件标识，为同步数据服务
	var $fanslist = $('.push a.fanslist'), $templist = $('.push a.templist'), $sendlist = $('.push a.sendlist'), $synch = $('.push a.synch');
	// 粉丝列表
	$fanslist.bind('click', function () {
		if(!$aclick) return ;
		var $tr = $(this).closest('tr');
		var id = $tr.attr('id'), appid = $tr.attr('appid');
		window.location.href = 'wechat_fans!list.gen?appid='+appid;
	});
	// 模板列表
	$templist.bind('click', function () {
		if(!$aclick) return ;
		var $tr = $(this).closest('tr');
		var id = $tr.attr('id'), appid = $tr.attr('appid');
		window.location.href = 'wechat_temp!list.gen?appid='+appid;
	});
	// 群发情况
	$sendlist.bind('click', function () {
		if(!$aclick) return ;
		var $tr = $(this).closest('tr');
		var id = $tr.attr('id'), appid = $tr.attr('appid');
		window.location.href = 'wechat_send!list.gen?appid='+appid;
		
	});
	// 数据同步
	$synch.bind('click', function () {
		if(!$aclick) return ; $aclick = false;
		$synch.removeClass('orange').addClass('disabled');
		var appid = $(this).closest('tr').attr('appid');
		$.ajax({
			url: 'wechat_fans!synch.gen', data: {appid: appid},
			success: function(result) {
				// {'status':false, 'message':'message'}
				if (result) {
					// $aclick = true;
					if (result.status) {
						$dialog.success(result.message, function(){reflesh();});
					}else{
						$dialog.error(result.message);
					}
				}
			}
		});
	});
});
</script>
</body>
</html>