﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>搜索词</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a>
        <a href="javascript:void(0);" class="button tiny genre <gen:if test="${empty param.genre || param.genre==''}">blue<gen:else />gray blue-hover</gen:if>" val=""><i></i>全部</a>
        <c:forEach items="${genreList}" var="genre">
        <a href="javascript:void(0);" class="button tiny genre <gen:if test='${genre.name == param.genre}'>blue <gen:else />gray blue-hover</gen:if>" val="${genre.name}"><i></i>${genre.name}</a>
        </c:forEach></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2>
      <i>搜索词</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="25%" class="border-left">名称</th>
          <th width="15%" class="border-left">类型</th>
          <th width="15%" class="border-left">状态</th>
          <th width="15%" class="border-left">PV</th>
          <th width="15%" class="border-left">时间</th>
          <th width="10%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}">
          <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
          <td class="border-left">&nbsp;${map.name}</td>
          <td align="center" class="border-left">${map.genre}</td>
          <td align="center" class="border-left"><gen:if test="${map.status == 0}"><span class="green">显示</span><gen:else /><span class="red">隐藏</span></gen:if></td>
          <td align="center" class="border-left">${map.pv}</td>
          <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
          <td align="center" class="border-left"><a href="javascript:void(0);" class="edit" title="编辑">编辑</a></td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="7" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="7"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover status" status="0"><i></i>显示</a>
          <a href="javascript:void(0);" class="button gray tiny blue-hover status" status="1"><i></i>隐藏</a>
          <a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a>
          <a href="javascript:void(0);" class="button gray tiny blue-hover clear"><i></i>全部清空</a></div>
          <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right" class="ignore">名称： </td>
            <td class="ignore"><input type="hidden" name="find" value="name" />
            <input type="text" name="keyword" class="text small" title="关键字" value="${param.keyword}" size="30"/></td>
          </tr>
          <tr class="border-top">
            <td align="right" class="ignore">状态：</td>
            <td class="ignore"><label><input name="status" type="radio" value="" ${empty param.status ? 'checked' : ''}/> 不限</label>&nbsp;&nbsp;
            <label><input name="status" type="radio" value="0" ${param.status == '0' ? 'checked' : ''}/> 显示</label>&nbsp;&nbsp;
            <label><input name="status" type="radio" value="1" ${param.status == '1' ? 'checked' : ''}/> 隐藏</label></td>
          </tr>
          <tr class="border-top">
            <td align="right" class="ignore">时间段：</td>
            <td class="ignore"><input id="startDate" name="startDate" type="text" class="text small" value="${param.startDate}" size="10" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" /><label for="startDate" generated="true" class="ico-tips date-picker"></label>&nbsp;~&nbsp;
            <input id="endDate" name="endDate" type="text" class="text small" value="${param.endDate}" size="10" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" /><label for="endDate" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c"><input type="hidden" name="genre" id="genre" value="${param.genre}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" />
              </th>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $add = $('.push a.add');
	var $edit = $('.table a.edit');
	var $status = $('.table a.status');
	var $delete = $('.table a.delete');
	var $clear = $('.table a.clear');
	var $clearTd = $('.table td:not(.ignore)');
	var $pages = $('.table .pages');
	
	var $search = $('#search');
	var $genre = $('#genre');
	var $genreA = $('.push a.genre');
	$genreA.bind('click', function () {
		var value = $(this).attr('val');
		$genre.attr('value', value);
		$search.find(':submit').click(); // $search.submit();
	});
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 添加
	$add.bind('click', function () {
		return addTab('添加搜索词', 'searchword!add.gen', 'searchword_add');
	});
	
	// 编辑
	$edit.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'searchword!edit.gen?id='+id, 'searchword_edit_'+id);
	});
	
	// 显示隐藏
	$status.bind('click', function () {
		var status = $(this).attr('status'), statustxt = status==0 ? '显示':'隐藏';
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定'+statustxt+'编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定'+statustxt+'选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'searchword!status.gen',
				data: {ids: ids, status: status},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								reflesh();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'searchword!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 全部清空
	$clear.bind('click', function () {
		if($clearTd.length <= 0) {
			$dialog.alert('暂无数据'); return false;
		}
		$temp = $clearTd.closest('tr');
		$dialog.confirm('确定清空数据吗？', function() {
			$.ajax({
				url: 'searchword!clear.gen',
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove(); $pages.hide();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
</script>
</body>
</html>
