﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<form id="form" name="form" method="post" action="<gen:if test='${empty param.id}'>node!save.gen<gen:else />node!update.gen</gen:if>">
  <h2>
    <ul class="area-genre">
      <li class="hover">基本信息</li>
      <li>分配模型</li>
      <li>URL规则</li>
    </ul>
    <i><gen:if test='${empty param.id}'>添加<gen:else />编辑</gen:if>节点</i>
  </h2>
  <div class="area-content">
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
      <tr>
        <td width="25%" align="right"><span class="red">*</span>&nbsp;节点名称：</td>
        <td width="75%">
          <input name="name" type="text" class="text small" id="name" value="${node.name}" size="20" />
          <label for="name" generated="true" class="tip normal" tip="节点名称不能为空"></label></td>
      </tr>
      <tr class="border-top">
        <td align="right"><span class="red">*</span>&nbsp;节点别名：</td>
        <td><input name="alias" type="text" class="text small" id="alias" value="${node.alias}" size="20" />
          <label for="alias" generated="true" class="tip normal" tip="仅限英文字母+数字"></label></td>
      </tr>
      <tr class="border-top">
        <td align="right">关键词：</td>
        <td><label><input id="tags" name="tags" type="text" class="text small ignore" value="${node.tags}" size="50" maxlength="60" />
          多个用 , 半角逗号间隔，最多5个</label></td>
      </tr>
      <tr class="border-top">
        <td align="right" valign="top">描述：</td>
        <td><table border="0" cellspacing="0" cellpadding="0" class="ignore">
            <tr class="ignore">
              <td><textarea id="description" name="description" class="text small textarea general">${node.description}</textarea></td>
              <td valign="top"></td>
            </tr>
          </table></td>
      </tr>
      <tr class="border-top">
        <td align="right">转向地址：</td>
        <td><input name="url" type="text" class="text small" value="${node.url}" size="50" /></td>
      </tr>
      <!--<tr class="border-top">
            <td align="right">节点图片：</td>
            <td><span class="field">
              <input type="text" name="thumb" config="content" class="text small" value="${node.thumb}" size="50" />
              <input type="button" name="browse" to="thumb" class="button gray small blue-hover" value="浏览" />
              <input type="button" name="upload" to="thumb" class="button gray small blue-hover" value="上传" />
              </span></td>
      </tr>-->
      <tr class="border-top templateTr">
        <td width="25%" align="right">节点模板：</td>
        <td width="75%">
          <input id="template" name="template" type="text" class="text small" value="${node.template}" size="50" />
          &nbsp;<a href="javascript:void(0);" title="选择模板" genre="node" to="template" class="choose">选择</a>&nbsp;<a href="javascript:void(0);" title="编辑模板" to="template" class="edit">编辑</a>&nbsp;&nbsp;
          <label><input type="checkbox" name="inherit" value="template" />
          子节点继承</label></td>
      </tr>
      <tr class="border-top">
        <td align="right">节点状态：</td>
        <td><label><input name="isHide" type="radio" value="0" ${empty node.isHide || node.isHide=='0' ? 'checked="checked"' :''} /> 启用</label>&nbsp;&nbsp;
        <label><input name="isHide" type="radio" value="1" ${node.isHide=='1' ? 'checked="checked"' :''} /> 禁用</label></td>
      </tr>
      <tr class="border-top">
        <td align="right">排序：</td>
        <td><label><input name="sort" type="text" class="text small" value="${node.sort}" size="5" />
        数值越大越靠后</label></td>
      </tr>
    </table>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
      <tr>
        <td width="25%" align="right">分配&nbsp;&nbsp;</td>
        <td width="10%" align="left">&nbsp;&nbsp;模型</td>
        <td width="65%">内容页模板</td>
      </tr>
      <gen:if test="${not empty modelList}">
        <c:forEach items="${modelList}" var="model">
          <c:set var="mapKey" value="${model.id}"></c:set>
          <c:set var="mapValue" value="${node.modelMap[mapKey]}"></c:set>
          <c:if test="${empty mapValue}">
            <c:set var="mapValue" value="${model.template}"></c:set>
          </c:if>
          <tr class="border-top templateTr">
            <td align="right"><input id="label-${model.id}" name="models" type="checkbox" value="${model.id}" <c:if test="${node.modelMap[mapKey] != null}">checked</c:if>/>&nbsp;&nbsp;</td>
            <td align="left">&nbsp;&nbsp;<label for="label-${model.id}">${model.name}</label></td>
            <td><gen:if test="${model.isTemplate==0}">
                <input id="${mapKey}" name="${mapKey}" type="hidden" value="${mapValue}" />
                <gen:else />
                <input id="${mapKey}" name="${mapKey}" type="text" class="text small" value="${mapValue}" size="50" />
                &nbsp;<a href="javascript:void(0);" title="选择模板" genre="model/${model.id}" to="${mapKey}" class="choose">选择</a>&nbsp;<a href="javascript:void(0);" title="编辑模板" to="${mapKey}" class="edit">编辑</a>
             </gen:if></td>
          </tr>
        </c:forEach>
        <tr class="border-top">
         <td width="25%" align="right"><input id="inherit-model" type="checkbox" name="inherit" value="model" />&nbsp;&nbsp;</td>
         <td colspan="2" align="left">&nbsp;&nbsp;<label for="inherit-model">子节点继承</label></td>
        </tr>
        <gen:else />
        <tr class="border-top">
          <td colspan="3" align="left" class="ignore" style="padding-left:25%;">无可用模型</td>
        </tr>
      </gen:if>
    </table>
    <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
      <tr>
        <td width="25%" align="right" class="orange">友情提示：</td>
        <td width="75%">在静态化时才会启用页面URL规则</td>
      </tr>
      <tr class="border-top">
        <td align="right">节点页URL规则：</td>
        <td><input name="urlRule" type="text" class="text small" id="urlRule" value="${node.urlRule}" size="50" />&nbsp;&nbsp;
          <label><input type="checkbox" name="inherit" value="rule" />
          子节点继承</label></td>
      </tr>
      <tr class="border-top">
        <td align="right">内容页URL规则：</td>
        <td><input name="urlRuleShow" type="text" class="text small" id="urlRuleShow" value="${node.urlRuleShow}" size="50" />&nbsp;&nbsp;
          <label><input type="checkbox" name="inherit" value="ruleshow" />
          子节点继承</label></td>
      </tr>
      <tr class="border-top">
        <td align="right" valign="top" class="orange">规则标记说明：</td>
        <td valign="top">\${parents}：当前节点父级别名(路径)<br />\${alias}：当前节点别名<br />\${yyyy}：内容发布年份<br />\${MM}：内容发布月份<br />\${dd}：内容发布日期<br />\${time}：内容发布时间戳<br />\${id}：内容Id</td>
      </tr>
    </table>
  </div>
  <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
    <tr class="border-top">
      <td class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
        <input type="hidden" name="id" id="id" value="${node.id}" />
        <input type="hidden" name="parentId" id="parentId" value="${node.parentId}" />
        <input name="submit" class="button blue small" type="submit" value="确 定" />
        &nbsp;&nbsp;&nbsp;&nbsp;
        <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
    </tr>
  </table>
</form>