﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>内容日志</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2>
      <i>内容日志管理</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="40%" class="border-left">主题</th>
          <th width="30%" class="border-left">信息</th>
          <th width="10%" class="border-left">IP</th>
          <th width="15%" class="border-left">时间</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}" contentId="${map.content.id}" modelId="${map.content.modelId}">
          <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
          <td class="border-left"><a href="javascript:void(0);" class="view" title="${map.content.title}">${map.content.title}</a></td>
          <td align="center" class="border-left"><span class="${map.color}">${map.info}</span></td>
          <td align="center" class="border-left" title="${map.region}">${map.ip}</td>
          <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="5" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="5"><div class="th-left"><gen:if test='${platAdmin}'>
          <a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a><a href="javascript:void(0);" class="button gray tiny blue-hover clear"><i></i>全部清空</a>
          </gen:if></div>
          <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right" class="ignore">主题： </td>
            <td class="ignore"><input name="contentId" type="hidden" value="${param.contentId}" />
            <input name="contentTitle" type="text" class="text small" value="${param.contentTitle}" size="50"/></td>
          </tr>
          <tr class="border-top">
            <td align="right" class="ignore">时间段：</td>
            <td class="ignore"><input id="startDate" name="startDate" type="text" class="text small" value="${param.startDate}" size="10" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" /><label for="startDate" generated="true" class="ico-tips date-picker"></label>&nbsp;~&nbsp;
            <input id="endDate" name="endDate" type="text" class="text small" value="${param.endDate}" size="10" onfocus="WdatePicker({maxDate:'%y-%M-%d'});" /><label for="endDate" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c">
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" />
              </th>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->
<script type="text/javascript" src="${config.statie}ui/cms/js/jspgencms.js"></script>
<script type="text/javascript" src="${config.statie}ui/cms/admin/js/content.js"></script>
<script type="text/javascript">
// document.domain = "jspgen.com";

// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $view = $('.table a.view');
	var $delete = $('.table a.delete');
	var $clear = $('.table a.clear');
	var $clearTd = $('.table td:not(.ignore)');
	var $pages = $('.table .pages');
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('contentId'), modelId = $(this).closest('tr').attr('modelId');
		content.view(id, modelId, $(this).attr('title')); return true;
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'content_log!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 全部清空
	$clear.bind('click', function () {
		if($clearTd.length <= 0) {
			$dialog.alert('暂无数据'); return false;
		}
		$temp = $clearTd.closest('tr');
		$dialog.confirm('确定清空数据吗？', function() {
			$.ajax({
				url: 'content_log!clear.gen',
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove(); $pages.hide();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 主题
	var $contentId = $('input[name="contentId"]'), $contentTitle = $('input[name="contentTitle"]');
	$contentTitle.bind('click',function(){
		var dialog = $dialog.iframe('content!choose.gen?type=radio', {title: '内容', width:'530px', height:'300px', resize: false});
		dialog.callback = function(arr){
			$.each(arr, function(i, obj){
				$contentId.attr('value', obj.id);
				$contentTitle.attr('value', obj.title);
			});
		}
	});
});
</script>
</body>
</html>
