﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>欢迎页</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<style type="text/css">
.icon-info{color:#FFFFFF;font-size:14px;line-height:22px;margin:0 auto;}
.icon-info li{float:left;margin:10px 6px;padding:5px;width:23%;min-width:15%;text-align:left;border-radius:6px;-webkit-border-radius:6px;-moz-border-radius:6px;}
.icon-info img{margin:1.2em 0;width:50%;}
.icon-info .num{width:100%;display:inline-block;}
.icon-info .unit{font-weight:bold;font-size:26px;text-align:right;line-height:44px;display:block;}
.icon-info .desc{text-align:right;display:block;}
.icon-info .iblue1{background:#3866e1;}.icon-info .iblue2{background:#118ad8;}.icon-info .iblue3{background:#38adc2;}.icon-info .iblue4{background:#1bae9b;}
.icon-info .ired1{background:#fa6030;}.icon-info .ired2{background:#f94c4c;}.icon-info .ired3{background:#fb7b7b;}
.icon-info .ibrown{background:#9d632c;}.icon-info .igray{background:#97a09b;}.icon-info .iyellow{background:#f1ac00;}
.icon-info .igreen{background:#6db512;}.icon-info .iorange{background:#ff7d08;}

#wrapper{padding:10px;}
.list_txt{padding:5px 10px;}
.list_txt li{position:relative;padding-left:15px;font-size:14px;line-height:32px;height:32px;}
.list_txt i{position:absolute;top:14px;left:0;background:#ccc;width:4px;height:4px;border-radius:2px;-webkit-border-radius:2px;-moz-border-radius:2px;}
.list_txt span{position:absolute;top:0;right:5px;font-size:12px;color:#999;}
.list_txt li.split{margin:15px 0;border-bottom:#ccc 1px dashed;line-height:1px;height:1px;}
</style>
<div id="wrapper">
  <div class="area-content">
    <ul class="icon-info clearfix">
      <li class="iblue2"><span class="num">文章内容</span><span class="unit" title="今日/总数">${stat.article}/${stat.articleCount}</span></li>
      <li class="iblue3"><span class="num">转向链接</span><span class="unit" title="今日/总数">${stat.link}/${stat.linkCount}</span></li>
      <li class="ired2"><span class="num">调查问卷</span><span class="unit" title="今日/总数">${stat.survey}/${stat.surveyCount}</span></li>
      <li class="iorange"><span class="num">在线留言</span><span class="unit" title="今日/总数">${stat.book}/${stat.bookCount}</span></li>
    </ul>
  </div>
  <div class="area-content">
    <table width="100%" border="0" align="center" cellspacing="0" cellpadding="0" class="table">
      <tr class="ignore">
        <td height="350" align="center"><div id="line" style="margin:10px;width:98%;height:300px;display:inline-block;text-align:left;">&nbsp;</div></td>
      </tr>
    </table>
  </div>
  <div class="push clearfix">
    <div class="area" style="float:left;width:49%;">
      <h2><i>${isnews ? '最新':'待审'}内容</i></h2>
      <div class="area-content">
        <ul class="list_txt clearfix">
        	<gen:if test="${not empty reviewList}">
            <c:forEach items="${reviewList}" var="map" begin="0" end="10">
              <li id="${map.id}" modelId="${map.modelId}"><i></i><span>${gen:dateTime(map.time, 'yyyy-MM-dd', config.timezoneid)}</span><a href="javascript:void(0);" class="view" title="${map.title}">${gen:substring(map.title, 60, "…")}</a></li>
            </c:forEach>
            <gen:else />
            <li><i></i>暂无数据</li>
          </gen:if>
        </ul>
      </div>
    </div>
    <div class="area" style="float:right;width:49%;">
      <h2><ul class="area-genre">
        <li class="hover">今日</li>
        <li>昨日</li>
        <li>上周</li>
        <li>本月</li>
      </ul>
      <i>发布排行</i></h2>
      <div class="area-content">
        <ul class="list_txt clearfix">
        	<gen:if test="${not empty dayList}">
            <c:forEach items="${dayList}" var="map" begin="0" end="10">
              <li><i></i><span>${map.count}</span><a href="javascript:void(0);" title="${map.fullname}">${map.name}</a></li>
            </c:forEach>
            <gen:else />
            <li><i></i>暂无数据</li>
          </gen:if>
        </ul>
        <ul class="list_txt clearfix" style="display:none;">
        	<gen:if test="${not empty yesterdayList}">
            <c:forEach items="${yesterdayList}" var="map" begin="0" end="10">
              <li><i></i><span>${map.count}</span><a href="javascript:void(0);" title="${map.fullname}">${map.name}</a></li>
            </c:forEach>
            <gen:else />
            <li><i></i>暂无数据</li>
          </gen:if>
        </ul>
        <ul class="list_txt clearfix" style="display:none;">
        	<gen:if test="${not empty lastWeekList}">
            <c:forEach items="${lastWeekList}" var="map" begin="0" end="10">
              <li><i></i><span>${map.count}</span><a href="javascript:void(0);" title="${map.fullname}">${map.name}</a></li>
            </c:forEach>
            <gen:else />
            <li><i></i>暂无数据</li>
          </gen:if>
        </ul>
        <ul class="list_txt clearfix" style="display:none;">
        	<gen:if test="${not empty nowMonthList}">
            <c:forEach items="${nowMonthList}" var="map" begin="0" end="10">
              <li><i></i><span>${map.count}</span><a href="javascript:void(0);" title="${map.fullname}">${map.name}</a></li>
            </c:forEach>
            <gen:else />
            <li><i></i>暂无数据</li>
          </gen:if>
        </ul>
      </div>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tabs.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 图表插件 -->
<script type="text/javascript" src="${config.statie}js/echarts3/echarts.min.js"></script>
<script type="text/javascript" src="${config.statie}js/echarts3/theme/shine.min.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->
<script type="text/javascript" src="${config.statie}ui/cms/js/jspgencms.js"></script>
<script type="text/javascript" src="${config.statie}ui/cms/js/jspgencms.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/cms/admin/js/content.js"></script>
<script type="text/javascript">
// document.domain = "jspgen.com";

// 调用
$(document).ready(function(){
	var $view = $('.list_txt a.view');
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('li').attr('id'), modelId = $(this).closest('li').attr('modelId');
		content.view(id, modelId, $(this).attr('title')); return true;
	});
	$('.area').tabs({title:'.area-genre', titleTag:'li', content:'.area-content', contentTag:'ul', action:'hover'});
	
	var line = echarts.init(document.getElementById('line'));
    line.setOption({
    	title:{text:'内容分布情况',textStyle:{color:'#5F5F5F'}<c:if test='${not empty year}'>,subtext:'${year}年度'</c:if>},
		//tooltip:{trigger:'axis'},
		tooltip:{trigger:'axis', formatter: function(params) {
			var data, name;
			var stat = 0, serarr = new Array();
			for(var i=0; i<params.length; i++) {
				data = params[i]; name = data.name; stat += data.value;
				serarr.push(data.seriesName +' : '+data.value);
			}
			name += ' : ' + stat + '<br/>';
			return name + serarr.join('<br/>');
		}}, 
		legend:{data:[${lineData.legend}]},
		toolbox:{show:true,feature:{saveAsImage:{show:true}}},calculable:true,
		xAxis:[{
            type:'category',
            data:['1月', '2月', '3月', '4月', '5月', '6月', '7月', '8月', '9月', '10月', '11月', '12月']
        }],
		yAxis:[{
			type:'value',
            axisLabel:{formatter:'{value}条'}
		}],
		series:[
			<c:forEach items="${lineData.dictList}" var="dict">
			{name:'${dict}',type:'line',data:[${lineData.data[dict]}],itemStyle:{normal:{label:{show:true}}}},
			</c:forEach>
		]
	});
});
</script>
</body>
</html>
