﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>广告</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2>
      <i>
      <gen:if test="${not empty adarea}">${adarea.name}&nbsp;</gen:if>广告</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="50%" class="border-left">名称</th>
          <th width="15%" class="border-left">类型</th>
          <th width="15%" class="border-left">时限</th>
          <th width="15%" class="border-left">状态</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}">
          <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
          <td class="border-left">&nbsp;<a href="javascript:void(0);" class="edit" title="编辑">${map.name}</a></td>
          <td align="center" class="border-left"><gen:if test="${map.genre == 'file'}">文件<gen:else />代码</gen:if></td>
          <td align="center" class="border-left"><gen:if test="${map.limit == -1}"><span class="gray">未开始</span><gen:else /><gen:if test="${map.limit == 0}"><span class="green">展示期</span><gen:else />已结束</gen:if></gen:if></td>
          <td align="center" class="border-left"><gen:if test="${map.status == 0}"><span class="blue">正常</span><gen:else /><span class="red">关闭</span></gen:if></td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="5" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="5"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
      	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">名称： </td>
            <td><input type="hidden" name="find" value="name" />
            <input type="text" name="keyword" class="text small" title="关键字" value="${gen:text(param.keyword,true,true)}" size="30"/>
            &nbsp;&nbsp;状态：
            <select name="status">
              <option value="" <gen:if test="${empty param.status}">selected</gen:if>>不限</option>
              <option value="0" <gen:if test="${param.status=='0'}">selected</gen:if>>正常</option>
              <option value="1" <gen:if test="${param.status=='1'}">selected</gen:if>>关闭</option>
            </select>
            &nbsp;&nbsp;
            <input type="hidden" name="adareaId" id="adareaId" value="${param.adareaId}" />
            <input name="submit" class="button blue small" type="submit" value="确 定" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $add = $('.push a.add');
	var $edit = $('.table a.edit');
	var $delete = $('.table a.delete');
	var $clear = $('.table a.clear');
	var $clearTd = $('.table td:not(.ignore)');
	var $pages = $('.table .pages');
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 添加
	$add.bind('click', function () {
		var adareaId = $('input[name="adareaId"]').val();
		return addTab('添加广告', 'ad!add.gen?adareaId='+adareaId, 'ad_add');
	});
	
	// 编辑
	$edit.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'ad!edit.gen?id='+id, 'ad_edit_'+id);
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'ad!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
// 重写刷新方法
function reflesh() {
	$('input[name="submit"]').click();
}
</script>
</body>
</html>