﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>令牌</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <gen:if test='${!param.dialog}'><h2><i><gen:if test='${empty param.id}'>添加<gen:else />编辑</gen:if>用户令牌</i></h2></gen:if>
    <div class="area-content">
      <form id="form" name="form" method="post" action="<gen:if test='${empty param.id}'>user_token!save.gen<gen:else />user_token!update.gen</gen:if>">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right"><span class="red">*</span>&nbsp;昵称：</td>
            <td><a href="javascript:void(0);" id="choose"><gen:if test='${empty userToken.name}'>选择<gen:else />${userToken.name}</gen:if></a></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top"> 权限：</td>
            <td><textarea name="purview" class="text small textarea general">${userToken.purview}</textarea></td>
          </tr>
          <tr class="border-top">
            <td align="right">时限：</td>
            <td><input name="tokenExpiry" type="text" class="text small"value="${userToken.tokenExpiry}" size="5" /> 分钟（0为永久有效）</td>
          </tr>
          <tr class="border-top">
            <td align="right">状态：</td>
            <td><label><input name="status" type="radio" value="0" ${empty userToken.status || userToken.status=='0'?'checked':''}/> 正常</label>
            &nbsp;&nbsp;
            <label><input name="status" type="radio" value="1" ${userToken.status=='1'?'checked':''}/> 暂停</label></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top"> 备注：</td>
            <td><textarea name="remark" class="text small textarea general">${userToken.remark}</textarea></td>
          </tr>
          <gen:if test='${not empty param.id && not empty userToken.token}'>
          <tr class="border-top">
            <td align="right" valign="top">AccessToken：</td>
            <td><span class="field">${userToken.token}<br />
            获取时间：${gen:dateTime(userToken.tokenTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}（已调用：${userToken.count}次）</span><br />
            有效时限：<gen:if test='${userToken.tokenExpiry == 0}'>永久有效<gen:else />${gen:dateTime(userToken.tokenExpiryTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}（在${userToken.tokenExpiry}分钟之内有效）</gen:if></td>
          </tr>
          </gen:if>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
            	<input type="hidden" name="id" value="${userToken.id}" />
                <input type="hidden" name="name" value="${userToken.name}" />
                <input name="submit" class="button blue small" type="submit" value="确 定" />
                &nbsp;&nbsp;&nbsp;&nbsp;
                <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){	
	var $form = $('#form'), $reset = $('input:reset');
	
	// 表单验证
	var validate = $form.validate({
		submitHandler: function(form) {
			if(grapes.isEmpty($('input[name="name"]').prop('value'))){
				alert('昵称不能为空!');
				return false;
			}
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
	
	// 用户选择
	var $userChoose = $('#choose'), $userId = $('input[name="id"]'), $userName = $('input[name="name"]');
	$userChoose.bind('click',function(){
		var dialog = $dialog.iframe('user!choose.gen', {title: '用户', width:'650px', height:'300px', resize: false});
		dialog.callback = function(obj) {
			$userId.prop('value', obj.id);
			$userName.prop('value', obj.name);
			$userChoose.text(obj.name);
		}
	});
});
</script>
</body>
</html>