﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>用户</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left">
        <a href="javascript:void(0);" class="button tiny groups <gen:if test="${empty param.groupId || param.groupId==''}">blue<gen:else />gray blue-hover</gen:if>" val=""><i></i>全部</a>
        <c:forEach items="${userGroupList}" var="userGroup">
        <a href="javascript:void(0);" class="button tiny groups <gen:if test="${param.groupId==userGroup.id}">blue<gen:else />gray blue-hover</gen:if>" val="${userGroup.id}"><i></i>${userGroup.name}</a>
        </c:forEach></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2> <i>用户</i> </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="15%" class="border-left">用户名(昵称)</th>
          <th width="20%" class="border-left">邮箱</th>
          <th width="10%" class="border-left">手机</th>
          <th width="15%" class="border-left">用户组</th>
          <th width="5%" class="border-left">锁定</th>
          <th width="15%" class="border-left">注册时间</th>
          <th width="15%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top" id="${map.id}">
              <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
              <td class="border-left">&nbsp;<a href="javascript:void(0);" class="view" title="查看">${gen:substring(map.username, 20, '…')}&nbsp;(${map.userDetail.nickname})</a></td>
              <td align="center" class="border-left"><gen:if test='${map.emailVerify == 1}'><span class="green email">${map.email}</span><gen:else />${map.email}</gen:if></td>
              <td align="center" class="border-left"><gen:if test='${map.mobileVerify == 1}'><span class="green mobile">${map.mobile}</span><gen:else />${map.mobile}</gen:if></td>
              <td align="center" class="border-left">${map.userGroup.name}</td>
              <td align="center" class="border-left lock"><gen:if test='${map.isLock == 1}'><span class="red">是</span><gen:else />否</gen:if></td>
              <td align="center" class="border-left" title="${gen:dateTime(map.regTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}">${gen:dateTime(map.regTime, 'yyyy-MM-dd', config.timezoneid)}</td>
              <td align="center" class="border-left"><a href="javascript:void(0);" class="passwordu" title="改密">改密</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="edit" title="编辑">编辑</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="delete">删除</a></td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="8" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="8"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover lock"><i></i>批量锁定</a><a href="javascript:void(0);" class="button gray tiny blue-hover unlock"><i></i>批量解锁</a><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">条件：</td>
            <td><select name="find">
                <option value="username,email,mobile" <gen:if test="${empty param.find || param.find=='username,email,mobile'}">selected</gen:if>>不限</option>
                <option value="username" <gen:if test="${param.find=='username'}">selected</gen:if>>用户名</option>
                <option value="email" <gen:if test="${param.find=='email'}">selected</gen:if>>邮箱</option>
                <option value="mobile" <gen:if test="${param.find=='mobile'}">selected</gen:if>>手机</option>
              </select>
              &nbsp;&nbsp;锁定：
              <select name="isLock">
                <option value="" <gen:if test="${empty param.isLock}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.isLock=='0'}">selected</gen:if>>否</option>
                <option value="1" <gen:if test="${param.isLock=='1'}">selected</gen:if>>是</option>
              </select>
              &nbsp;&nbsp;按
              <select name="orderBy">
                <option value="regTime" <gen:if test="${param.orderBy=='regTime'}">selected</gen:if>>注册时间</option>
                <option value="loginTime" <gen:if test="${param.orderBy=='loginTime'}">selected</gen:if>>登录时间</option>
              </select>
              降序排序
              <input type="hidden" name="order" value="desc" /></td>
          </tr>
          <tr class="border-top">
            <td align="right">关键字： </td>
            <td><input type="text" name="keyword" class="text small" title="关键字" value="${gen:text(param.keyword,true,true)}" size="65"/></td>
          </tr>
          <tr class="border-top">
            <td align="right">注册时间： </td>
            <td><input id="startDateReg" name="startDateReg" type="text" class="text small" size="20" onfocus="WdatePicker({maxDate:'#F{$dp.$D(\'endDateReg\')||\'%y-%M-%d\'}'});" value="${param.startDateReg}" />
              <label for="startDateReg" generated="true" class="ico-tips date-picker"></label>
              &nbsp;~&nbsp;
              <input id="endDateReg" name="endDateReg" type="text" class="text small" size="20" onfocus="WdatePicker({minDate:'#F{$dp.$D(\'startDateReg\')}',maxDate:'%y-%M-%d'});" value="${param.endDateReg}" />
              <label for="endDateReg" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr class="border-top">
            <td align="right">登录时间： </td>
            <td><input id="startDateLogin" name="startDateLogin" type="text" class="text small" size="20" onfocus="WdatePicker({maxDate:'#F{$dp.$D(\'endDateLogin\')||\'%y-%M-%d\'}'});" value="${param.startDateLogin}" />
              <label for="startDateLogin" generated="true" class="ico-tips date-picker"></label>
              &nbsp;~&nbsp;
              <input id="endDateLogin" name="endDateLogin" type="text" class="text small" size="20" onfocus="WdatePicker({minDate:'#F{$dp.$D(\'startDateLogin\')}',maxDate:'%y-%M-%d'});" value="${param.endDateLogin}" />
              <label for="endDateLogin" generated="true" class="ico-tips date-picker"></label></td>
          </tr>
          <tr class="border-top">
            <th colspan="2" class="push txt-c"><input type="hidden" name="groupId" id="groupId" value="${param.groupId}" />
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" />
              </td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $view = $('.table a.view');
	var $edit = $('.table a.edit');	
	var $passwordu = $('.table a.passwordu');
	var $delete = $('.table a.delete');
	var $lock = $('.table a.lock');
	var $unlock = $('.table a.unlock');
	var $pages = $('.table .pages');
	
	var $search = $('#search');
	var $groupId = $('#groupId');
	var $groups = $('.push a.groups');
	$groups.bind('click', function () {
		var id = $(this).attr('val');
		$groupId.attr('value', id);
		$search.find(':submit').click(); // $search.submit();
	});
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'user!view.gen?id='+id, 'user_view_'+id);
	});
	// 编辑
	$edit.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'user!edit.gen?id='+id, 'user_edit_'+id);
	});
	// 改密
	$passwordu.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'user!password.gen?id='+id, 'user_password_'+id);
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'user!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 锁定
	$lock.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定锁定编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定锁定选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'user!lock.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.find("td.lock").html('<span class="red">是</span>');
							});
						}else{
							$dialog.error(result.message);
						}
					}
					$check.prop('checked', false);
					$checkItem.prop('checked', false);
				}
			});
		}, function() {});
	});
	
	// 解锁
	$unlock.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定解锁编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定解锁选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'user!unlock.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.find("td.lock").html('否');
							});
						}else{
							$dialog.error(result.message);
						}
					}
					$check.prop('checked', false);
					$checkItem.prop('checked', false);
				}
			});
		}, function() {});
	});	
});
</script>
</body>
</html>
