﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>用户</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left">
        <a href="javascript:void(0);" class="button tiny groups <gen:if test="${empty param.groupId || param.groupId==''}">blue<gen:else />gray blue-hover</gen:if>" val=""><i></i>全部</a>
        <c:forEach items="${userGroupList}" var="userGroup">
        <a href="javascript:void(0);" class="button tiny groups <gen:if test="${param.groupId==userGroup.id}">blue<gen:else />gray blue-hover</gen:if>" val="${userGroup.id}"><i></i>${userGroup.name}</a>
        </c:forEach></td>
        <td align="right">&nbsp;</td>
      </tr>
    </table>
  </div>
  <div class="area">
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="10%">Id</th>
          <th width="20%" class="border-left">用户名(昵称)</th>
          <th width="30%" class="border-left">用户组</th>
          <th width="10%" class="border-left">锁定</th>
          <th width="30%" class="border-left">备注</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}" name="${map.userDetail.nickname}">
          <td align="center">${map.id}</td>
          <td class="border-left">&nbsp;<a href="javascript:void(0);" class="choose" title="选择">${gen:substring(map.username, 20, '…')}&nbsp;(${map.userDetail.nickname})</a></td>
          <td align="center" class="border-left">${map.userGroup.name}</td>
          <td align="center" class="border-left disable"><gen:if test='${map.isLock == 1}'><span class="red">是</span><gen:else />否</gen:if></td>
          <td align="center" class="border-left" title="${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}">${map.remark}</td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="5" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="5"><div class="pages">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
  	<h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
      	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">用户名： </td>
            <td><input type="hidden" name="find" value="username,email,mobile" />
            <input type="text" name="keyword" class="text small" title="关键字" value="${param.keyword}" size="30"/>
            &nbsp;&nbsp;锁定：
            <select name="isLock">
                <option value="" <gen:if test="${empty param.isLock}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.isLock=='0'}">selected</gen:if>>否</option>
                <option value="1" <gen:if test="${param.isLock=='1'}">selected</gen:if>>是</option>
              </select>
            <input type="hidden" name="orderBy" value="login_time is null,login_time" />
            <input type="hidden" name="order" value="desc" />
            &nbsp;&nbsp;
            <input type="hidden" name="groupId" value="${param.groupId}" />
            <input name="submit" class="button blue small" type="submit" value="确 定" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $choose = $('.table a.choose');
	
	var $search = $('#search');
	var $groupId = $('input[name="groupId"]');
	var $groups = $('.push a.groups');
	$groups.bind('click', function () {
		var val = $(this).attr('val');
		$groupId.attr('value', val);
		$search.find(':submit').click(); // $search.submit();
	});
	
	// 选择
	$choose.bind('click', function () {
		var id = $(this).closest('tr').attr('id'), name = $(this).closest('tr').attr('name');
		$dialogApi.callback({id:id, name:name});
		$dialogApi.close();
	});
});
</script>
</body>
</html>
