﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>系统消息</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="area">
    <h2><i>发送系统消息</i></h2>
    <div class="area-content">
      <form id="form" name="form" method="post" action="sys_ums!save.gen">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right" valign="top">接收对象：</td>
            <td><table border="0" cellspacing="0" cellpadding="0">
                <tr class="ignore">
                  <td align="center" >
                    <select name="group" size="10" id="group" style="width:120px; height:100px; max-width:120px; max-height:100px;">
                      <option value="" selected="selected">所有用户组</option>
                      <c:forEach items="${userGroupList}" var="userGroup">
                        <option value="${userGroup.id}">${userGroup.name}</option>
                      </c:forEach>
                    </select></td>
                  <td align="center" valign="top" style="display:none;">
                    <select name="role" size="10" id="role" style="margin-left:5px; width:120px; height:100px; max-width:120px; max-height:100px;">
                      <option value="" selected="selected">所有角色</option>
                      <c:forEach items="${adminRoleList}" var="adminRole">
                        <option value="${adminRole.id}">${adminRole.name}</option>
                      </c:forEach>
                    </select></td>
                </tr>
              </table></td>
          </tr>
          <tr class="border-top">
            <td align="right">消息主题：</td>
            <td><input name="subject" type="text" class="text small ignore" size="55" /></td>
          </tr>
          <tr class="border-top">
            <td align="right" valign="top">消息内容：</td>
            <td><table border="0" cellspacing="0" cellpadding="0">
                <tr class="ignore">
                  <td><textarea id="content" name="content" class="text small textarea general"></textarea></td>
                  <td valign="top"><label for="content" generated="true" class="tip normal" tip=""></label></td>
                </tr>
              </table></td>
          </tr>
          <tr class="border-top">
            <td align="right">消息链接：</td>
            <td><input name="url" type="text" class="text small ignore" size="30" /></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input type="hidden" name="formHash" value="${formHash}"/>
              <input type="hidden" name="groupId" id="groupId" value=""/>
              <input type="hidden" name="groupName" id="groupName" value=""/>
              <input type="hidden" name="roleId" id="roleId" value=""/>
              <input type="hidden" name="roleName" id="roleName" value=""/>
              <input type="hidden" name="genreId" id="genreId" value=""/>
              <input type="hidden" name="genreName" id="genreName" value=""/>
              <input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 表单验证插件 -->
<script type="text/javascript" src="${config.statie}js/validate/jquery.validate.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/validate.expand.js"></script>
<script type="text/javascript" src="${config.statie}js/validate/messages_zh.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $group = $('#group');
	var $role = $('#role');
	var $groupId = $('#groupId');
	var $groupName = $('#groupName');
	var $roleId = $('#roleId');
	var $roleName = $('#roleName');
	
	var $form = $('#form');
	var $reset = $('input:reset');
	
	// 用户组
	$group.bind('change', function () {
		var $selected = $(this).children('option:selected');
		if($selected.val() == 1) {
			$role.get(0).options[0].selected = true;
			$role.closest("td").show();
		}else{
			$role.closest("td").hide();
			$roleId.prop('value', '');
			$roleName.prop('value', '');
		}
		$groupId.prop('value', $selected.val());
		$groupName.prop('value', $selected.text());
	});
	
	// 角色
	$role.bind('change', function () {
		var $selected = $(this).children('option:selected');
		if($selected.val() != ''){
			$roleId.prop('value', $selected.val());
			$roleName.prop('value', $selected.text());
		}else{
			$roleId.prop('value', '');
			$roleName.prop('value', '');
		}
	});
	
	// 表单验证
	var validate = $form.validate({
		rules: {
			content: {
				required: true
			}
		},
		messages: {
			content: {
				required: "内容不允许为空！"
			}
		},
		submitHandler: function(form) {
			$(form).ajaxSubmit($.extend({
				success: function(result) {
					// {'status':false,'message':'message', 'store':{'id':'id'}}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								refleshFromTab(); removeTab();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			}, formOptions));
			
			// 阻止表单默认提交
			return false;
		}
	});
	$reset.bind('click', function () {
		validate.resetForm();
	});
	
});
</script>
</body>
</html>
