﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>短信</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>发送</a></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2><i>系统短信</i></h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="10%" class="border-left">发送者</th>
          <th width="45%" class="border-left">主题</th>
          <th width="10%" class="border-left">状态</th>
          <th width="15%" class="border-left">时间</th>
          <th width="15%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top" id="${map.id}">
              <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
              <td align="center" class="border-left">${map.adminName}</td>
              <td class="border-left">&nbsp;<a href="javascript:void(0);" class="view" title="${map.subject}">${gen:substring(map.subject, 80, '…')}</a></td>
              <td align="center" class="border-left"><gen:if test='${map.status == 1}'><span class="green">成功</span><gen:else /><span class="red">失败</span></gen:if></td>
              <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
              <td align="center" class="border-left"><a href="javascript:void(0);" class="view" title="${map.subject}">查看</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="delete">删除</a></td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="6" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="6"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $add = $('.push a.add');
	var $view = $('.table a.view');
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	var $delete = $('.table a.delete');
	var $pages = $('.table .pages');
	
	// 添加
	$add.bind('click', function () {
		return addTab('发送短信', 'sys_sms!post.gen', 'add_sys_sms_post');
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'sys_sms!view.gen?id='+id, 'view_sys_sms_'+id);
	});
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'sys_sms!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
</script>
</body>
</html>
