﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>在线定位</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left">Session：${size}个&nbsp;&nbsp;最高记录：${onlineMax.count} - 发生于：${gen:dateTime(onlineMax.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)} - 幸运用户：<gen:if test="${not empty onlineMax.username}">${onlineMax.username}<gen:else />网友</gen:if> - 来自：${onlineMax.ip}</td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2> <i>在线定位</i> </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="10%" class="border-left">用户名</th>
          <th width="15%" class="border-left">浏览器</th>
          <th width="15%" class="border-left">当前位置</th>
          <th width="25%" class="border-left">IP-地址</th>
          <th width="15%" class="border-left">访问时间</th>
          <th width="15%" class="border-left">活动时间</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top" id="${map.id}">
              <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
              <td class="border-left">&nbsp;<gen:if test="${not empty map.username}">${map.username}<gen:else />网友</gen:if></td>
              <td class="border-left">&nbsp;${map.browser}</td>
              <td class="border-left">&nbsp;<a href="${map.url}" target="_blank">${map.place}</a></td>
              <td class="border-left">&nbsp;${map.ip}-${map.address}</td>
              <td align="center" class="border-left">${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
              <td align="center" class="border-left">${gen:dateTime(map.lastTime, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="7" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="7"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover kick"><i></i>批量注销</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- 日期插件 -->
<script type="text/javascript" src="${config.statie}js/datePicker/WdatePicker.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "jspgen.com";// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	var $kick = $('.table a.kick');
	var $pages = $('.table .pages');
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 删除
	$kick.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm('确定要注销吗？注销用户将自动退出登录!', function() {
			$.ajax({
				url: 'online!kick.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
</script>
</body>
</html>
