﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>定时</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left"><a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2> <i>任务</i> </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="20%" class="border-left">任务名称</th>
          <th width="10%" class="border-left">任务分组</th>
          <th width="10%" class="border-left">运行模式</th>
          <th width="15%" class="border-left">上次运行时间</th>
          <th width="15%" class="border-left">下次运行时间</th>
          <th width="10%" class="border-left">状态</th>
          <th width="15%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
          <c:forEach items="${pager.results}" var="map">
            <tr class="border-top" id="${map.id}">
              <td align="center"><gen:if test='${map.status == 3 || map.status == 0}'><input type="checkbox" name="ids" value="${map.id}"></gen:if></td>
              <td class="border-left">&nbsp;<a href="javascript:void(0);" class="view" title="${map.name}">${gen:substring(map.name, 20, '…')}</a></td>
              <td align="center" class="border-left"><gen:if test='${map.group == "system"}'>系统</gen:if><gen:if test='${map.group == "diy"}'>自定义</gen:if></td>
              <td align="center" class="border-left"><gen:if test='${map.mode == "time"}'>定时</gen:if><gen:if test='${map.mode == "loop"}'>循环</gen:if><gen:if test='${map.mode == "timeloop"}'>定时循环</gen:if></td>
              <td align="center" class="border-left">${gen:dateTime(map.lastRun, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
              <td align="center" class="border-left">${gen:dateTime(map.nextRun, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}</td>
              <td align="center" class="border-left data-status"><gen:if test='${map.status == 3}'><span class="orange">暂停</span></gen:if><gen:if test='${map.status == 2}'>结束</gen:if>
                <gen:if test='${map.status == 1}'><span class="green">运行中</span></gen:if><gen:if test='${map.status == 0}'><span class="blue">正常</span></gen:if></td>
              <td align="center" class="border-left"><a href="javascript:void(0);" class="cronLog" title="日志">日志</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="copy" title="复制">复制</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="delete">删除</a></td>
            </tr>
          </c:forEach>
          <gen:else />
          <tr class="border-top">
            <td colspan="8" align="center" class="ignore">暂无数据</td>
          </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="8"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover status" val="3"><i></i>批量暂停</a><a href="javascript:void(0);" class="button gray tiny blue-hover status" val="0"><i></i>恢复正常</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
        <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">关键字： </td>
            <td><input type="text" name="keyword" class="text small" id="keyword" title="关键字" value="${param.keyword}" size="50"/>
            <label for="keyword" generated="true" class="tip normal">支持任务名称、任务实现类路径查询</label><input type="hidden" name="find" value="name,impl" /></td>
          </tr>
          <tr class="border-top">
            <td align="right">属 性：</td>
            <td><select name="scanned">
                <option value="" <gen:if test="${empty param.scanned}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.scanned=='0'}">selected</gen:if>>未扫描</option>
                <option value="1" <gen:if test="${param.scanned=='1'}">selected</gen:if>>已扫描</option>
              </select>
              &nbsp;&nbsp;状态：
              <select name="status">
                <option value="" <gen:if test="${empty param.status}">selected</gen:if>>不限</option>
                <option value="0" <gen:if test="${param.status=='0'}">selected</gen:if>>正常</option>
                <option value="1" <gen:if test="${param.status=='1'}">selected</gen:if>>运行中</option>
                <option value="2" <gen:if test="${param.status=='2'}">selected</gen:if>>结束</option>
                <option value="3" <gen:if test="${param.status=='3'}">selected</gen:if>>暂停</option>
              </select>
              <input type="hidden" name="orderBy" value="id" />
              <input type="hidden" name="order" value="desc" /></td>
          </tr>
          <tr class="border-top">
            <td colspan="2" class="push txt-c"><input name="submit" class="button blue small" type="submit" value="确 定" />
              &nbsp;&nbsp;&nbsp;&nbsp;
              <input name="reset" class="button gray small" type="reset" value="取 消" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $view = $('.table a.view');
	var $add = $('.push a.add');
	var $cronLog = $('.table a.cronLog');
	var $copy = $('.table a.copy');
	var $delete = $('.table a.delete');
	var $status = $('.table a.status');
	var $pages = $('.table .pages');
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'cron!view.gen?id='+id, 'cron_view_'+id);
	});
	
	// 添加
	$add.bind('click', function () {
		return addTab('添加任务', 'cron!add.gen', 'cron_add');
	});
	
	// 日志
	$cronLog.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'cron_log!list.gen?findBy=cronId&keyword='+id, 'cron_view_cron_log_'+id);
	});
	
	// 复制
	$copy.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'cron!copy.gen?id='+id, 'cron_copy_'+id);
	});
	
	// 批量暂停/恢复
	$status.bind('click', function () {
		var status = $(this).attr('val');
		var status_mes = status == 0 ? '恢复' : '暂停';
		
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定'+status_mes+'编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定'+status_mes+'选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'cron!status.gen',
				data: {ids: ids, status: status},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								if(status == 3) {
									$temp.find(".data-status").html('<span class="orange">暂停</span>');
								} else {
									$temp.find(".data-status").html('<span class="blue">正常</span>');
								}
							});
						}else{
							$dialog.error(result.message);
						}
					}
					$check.prop('checked', false);
					$checkItem.prop('checked', false);
				}
			});
		}, function() {});
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'cron!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
});
</script>
</body>
</html>
