﻿<%@page trimDirectiveWhitespaces="true"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="gen" uri="http://help.jspgen.com/taglib/jstl"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<meta http-equiv="X-UA-Compatible" content="ie=edge,chrome=1" />
<title>管理员</title>
<!-- 当前页面 -->
<link type="text/css" href="${config.statie}ui/admin/images/admin.css" rel="stylesheet">
</head>
<body>
<div id="wrapper">
  <div class="push">
    <table width="100%" border="0" cellspacing="0" cellpadding="0">
      <tr>
        <td align="left">
        <a href="javascript:void(0);" class="button orange tiny add"><i></i>添加</a>
        <a href="javascript:void(0);" class="button tiny roles <gen:if test="${empty param.roleId || param.roleId==''}">blue<gen:else />gray blue-hover</gen:if>" id=""><i></i>全部</a>
        <c:forEach items="${adminRoleList}" var="adminRole">
        <a href="javascript:void(0);" class="button tiny roles <gen:if test="${param.roleId==adminRole.id}">blue<gen:else />gray blue-hover</gen:if>" id="${adminRole.id}"><i></i>${adminRole.name}</a>
        </c:forEach></td>
        <td align="right"><a href="javascript:void(0);" class="button green tiny" onclick="reflesh();"><i></i>刷新</a></td>
      </tr>
    </table>
  </div>
  <div class="area">
    <h2>
      <i>管理员</i>
    </h2>
    <div class="area-content">
      <table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
        <tr>
          <th width="5%" title="全选/取消"><input type="checkbox" name="check" for="ids" value="0"></th>
          <th width="15%" class="border-left">姓名(用户名)</th>
          <th width="15%" class="border-left">角色</th>
          <th width="5%" class="border-left">禁用</th>
          <th width="15%" class="border-left">加入时间</th>
          <th width="30%" class="border-left">备注</th>
          <th width="15%" class="border-left">操作</th>
        </tr>
        <gen:if test="${not empty pager.results}">
        <c:forEach items="${pager.results}" var="map">
        <tr class="border-top" id="${map.id}">
          <td align="center"><input type="checkbox" name="ids" value="${map.id}"></td>
          <td class="border-left">&nbsp;<a href="javascript:void(0);" class="view" title="${map.name}">${gen:substring(map.name, 20, '…')}&nbsp;(${map.user.username})</a></td>
          <td align="center" class="border-left">${map.adminRole.name}</td>
          <td align="center" class="border-left disable"><gen:if test='${map.isDisabled == 1}'><span class="red">是</span><gen:else />否</gen:if></td>
          <td align="center" class="border-left" title="${gen:dateTime(map.time, 'yyyy-MM-dd HH:mm:ss', config.timezoneid)}">${gen:dateTime(map.time, 'yyyy-MM-dd', config.timezoneid)}</td>
          <td align="center" class="border-left">${map.remark}</td>
          <td align="center" class="border-left"><a href="javascript:void(0);" class="passwordu" title="改密">改密</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="edit" title="编辑">编辑</a>&nbsp;|&nbsp;<a href="javascript:void(0);" class="delete">删除</a></td>
        </tr>
        </c:forEach>
        <gen:else />
        <tr class="border-top">
        	<td colspan="7" align="center" class="ignore">暂无数据</td>
        </tr>
        </gen:if>
        <tr class="border-top">
          <th colspan="7"><div class="th-left"><a href="javascript:void(0);" class="button gray tiny blue-hover disable"><i></i>批量禁用</a><a href="javascript:void(0);" class="button gray tiny blue-hover undisable"><i></i>批量启用</a><a href="javascript:void(0);" class="button gray tiny blue-hover delete"><i></i>批量删除</a></div>
            <div class="pages th-right">${pager.pageBar}</div></th>
        </tr>
      </table>
    </div>
  </div>
  <div class="area">
    <h2><i>查询</i></h2>
    <div class="area-content">
      <form name="search" id="search" method="POST" action="?">
      	<table width="100%" border="0" cellspacing="0" cellpadding="0" class="table">
          <tr>
            <td width="30%" align="right">管理姓名： </td>
            <td><input type="hidden" name="find" value="name" />
            <input type="text" name="keyword" class="text small" title="关键字" value="${param.keyword}" size="30"/>
            &nbsp;&nbsp;禁用：
            <select name="isDisabled">
              <option value="" <gen:if test="${empty param.isDisabled}">selected</gen:if>>不限</option>
              <option value="0" <gen:if test="${param.isDisabled=='0'}">selected</gen:if>>否</option>
              <option value="1" <gen:if test="${param.isDisabled=='1'}">selected</gen:if>>是</option>
            </select>
            <input type="hidden" name="orderBy" value="time is null,time" />
            <input type="hidden" name="order" value="desc" />
            &nbsp;&nbsp;
            <input type="hidden" name="roleId" id="roleId" value="${param.roleId}" />
            <input name="submit" class="button blue small" type="submit" value="确 定" /></td>
          </tr>
        </table>
      </form>
    </div>
  </div>
</div>
<!-- 必备插件 -->
<script type="text/javascript" src="${config.statie}js/jquery.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.form.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.grapes.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.timers.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.mousewheel.js"></script>
<script type="text/javascript" src="${config.statie}js/jquery.tablecolor.js"></script>
<!-- 弹窗插件 -->
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.js?self=true"></script>
<script type="text/javascript" src="${config.statie}js/dialog/jquery.dialog.plugins.js"></script>
<!-- UI界面必备 -->
<script type="text/javascript" src="${config.statie}ui/js/jspgen.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ajax.js"></script>
<script type="text/javascript" src="${config.statie}ui/js/jspgen.ready.js"></script>
<!-- 当前页面 -->

<script type="text/javascript">
// document.domain = "baidu.com";

// 调用
$(document).ready(function(){
	// 变量
	var $check = $('.table input[name="check"]');
	var $checkItem = $('.table input[name="'+$check.attr('for')+'"]');
	
	var $add = $('.push a.add');
	var $view = $('.table a.view');
	var $edit = $('.table a.edit');	
	var $passwordu = $('.table a.passwordu');
	var $delete = $('.table a.delete');
	var $disable = $('.table a.disable');
	var $undisable = $('.table a.undisable');
	var $pages = $('.table .pages');
	
	var $search = $('#search');
	var $roleId = $('#roleId');
	var $roles = $('.push a.roles');
	$roles.bind('click', function () {
		var id = $(this).attr('id');
		$roleId.attr('value', id);
		$search.find(':submit').click(); // $search.submit();
	});
	
	// 全选/反选
	$check.bind('click', function () {
		var $this = $(this);
		return grapes.check($this, $this.attr('for'));
	});
	// checkItem
	$checkItem.bind('click', function () {
		$check.prop('checked', $checkItem.length == $checkItem.filter(':checked').length);
	});
	
	// 添加
	$add.bind('click', function () {
		return addTab('添加管理员', 'admin!add.gen', 'admin_add');
	});
	// 编辑
	$edit.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'admin!edit.gen?id='+id, 'admin_edit_'+id);
	});
	
	// 查看
	$view.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'user!view.gen?id='+id, 'user_view_'+id);
	});
	// 修改密码
	$passwordu.bind('click', function () {
		var id = $(this).closest('tr').attr('id');
		return addTab($(this).attr('title'), 'user!password.gen?id='+id, 'user_password_'+id);
	});
	
	// 删除
	$delete.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定删除编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定删除选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'admin!delete.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.remove();
							});
						}else{
							$dialog.error(result.message);
						}
					}
				}
			});
		}, function() {});
	});
	
	// 禁用
	$disable.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定禁用编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定禁用选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'admin!disabled.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.find("td.disable").html('<span class="red">是</span>');
							});
						}else{
							$dialog.error(result.message);
						}
					}
					$check.prop('checked', false);
					$checkItem.prop('checked', false);
				}
			});
		}, function() {});
	});
	
	// 启用
	$undisable.bind('click', function () {
		var ids = $(this).closest('tr').attr('id');
		var mes = '确定启用编号为 <b class="red">'+ids+'</b> 的数据吗？';
		if(grapes.isNotEmpty(ids)){
			$temp = $(this).closest('tr');
		}else{
			$temp = $checkItem.filter(':checked').closest('tr');
			ids = grapes.values($check.attr('for'), ',');
			mes = '确定启用选中的 <b class="red">'+ids.split(',').length+'</b> 条数据吗？'
		}
		if(grapes.isEmpty(ids)){
			$dialog.alert('至少需要选择一条数据…'); return false;
		}
		$dialog.confirm(mes, function() {
			$.ajax({
				url: 'admin!undisabled.gen',
				data: {ids: ids},
				success: function(result) {
					// {'status':false, 'message':'message'}
					if (result) {
						if (result.status) {
							$dialog.success(result.message, function() {
								$temp.find("td.disable").html('否');
							});
						}else{
							$dialog.error(result.message);
						}
					}
					$check.prop('checked', false);
					$checkItem.prop('checked', false);
				}
			});
		}, function() {});
	});		
});
</script>
</body>
</html>
