/*
 * Decompiled with CFR 0.152.
 */
package wechat.util;

import grapes.Grapes;
import grapes.pack.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jackson.JsonNode;
import wechat.exception.WechatCode;
import wechat.exception.WechatException;

public class WechatUtil {
    public static void isSuccess(String string) throws WechatException {
        Integer n;
        if (Grapes.isEmpty((Object)string)) {
            return;
        }
        JsonNode jsonNode = JSON.toJson((String)string);
        if (Grapes.isNotEmpty((Object)jsonNode) && jsonNode.has("errcode") && (n = Integer.valueOf(jsonNode.get("errcode").getIntValue())) != 0) {
            String string2 = WechatCode.getMsg(n);
            if (string2 == null) {
                string2 = jsonNode.get("errmsg").getTextValue();
            }
            throw new WechatException("errcode:" + n + ",errmsg:" + string2);
        }
    }

    public static String stream2String(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = -1;
        try {
            while ((n = inputStream.read()) != -1) {
                byteArrayOutputStream.write(n);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public static InputStream string2Stream(String string) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public static String emoji(int n) {
        return String.valueOf(Character.toChars(n));
    }

    public static String emoji2Byte(String string) {
        if (Grapes.isEmpty((Object)string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("[^(\u2e80-\u9fff\\w\\s`~!@#\\$%\\^&\\*\\(\\)_+-\uff1f\uff08\uff09\u2014\u2014=\\[\\]{}\\|;\u3002\uff0c\u3001\u300a\u300b\u201d\uff1a\uff1b\u201c\uff01\u2026\u2026\u2019:'\"<,>\\.?/\\\\*)]");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, WechatUtil.\u00d200000(matcher.group(0)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public static String byte2Emoji(String string) {
        if (Grapes.isEmpty((Object)string)) {
            return "";
        }
        Pattern pattern = Pattern.compile("<:([[-]\\d*[,]]+):>");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, WechatUtil.o00000(matcher.group(0)));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    private static String \u00d200000(String string) {
        byte[] byArray = string.getBytes();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<:");
        int n = 0;
        while (n < byArray.length) {
            if (n < byArray.length - 1) {
                stringBuffer.append(String.valueOf(Byte.valueOf(byArray[n]).toString()) + ",");
            } else {
                stringBuffer.append(Byte.valueOf(byArray[n]).toString());
            }
            ++n;
        }
        stringBuffer.append(":>");
        return stringBuffer.toString();
    }

    private static String o00000(String string) {
        string = string.replaceAll("<:", "").replaceAll(":>", "");
        String[] stringArray = string.split(",");
        byte[] byArray = new byte[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            byArray[n] = Byte.valueOf(stringArray[n]);
            ++n;
        }
        return new String(byArray);
    }

    public static String filterEmoji(String string) {
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (WechatUtil.o00000(c)) {
                stringBuilder.append(c);
            }
            ++n2;
        }
        return stringBuilder.toString();
    }

    private static boolean o00000(char c) {
        return c == '\u0000' || c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd' || c >= '\u10000' && c <= '\u10ffff';
    }
}

