/*
 * Decompiled with CFR 0.152.
 */
package grapes.tools;

import grapes.Grapes;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;

public class Server {
    public static final String OS_ARCH = Server.getSystemProperty("os.arch");
    public static final String OS_NAME = Server.getSystemProperty("os.name");
    public static final String OS_VERSION = Server.getSystemProperty("os.version");
    public static final String PATH_SEPARATOR = Server.getSystemProperty("path.separator");
    public static final String USER_COUNTRY = Server.getSystemProperty("user.country") == null ? Server.getSystemProperty("user.region") : Server.getSystemProperty("user.country");
    public static final String USER_LANGUAGE = Server.getSystemProperty("user.language");
    public static final String USER_DIR = Server.getSystemProperty("user.dir");
    public static final String USER_HOME = Server.getSystemProperty("user.home");
    public static final String USER_NAME = Server.getSystemProperty("user.name");
    public static final String USER_TIMEZONE = Server.getSystemProperty("user.timezone");
    public static final String JAVA_HOME = Server.getSystemProperty("java.home");
    public static final String JAVA_IO_TMPDIR = Server.getSystemProperty("java.io.tmpdir");
    public static final String JAVA_LIBRARY_PATH = Server.getSystemProperty("java.library.path");
    public static final String JAVA_VERSION = Server.getSystemProperty("java.version");
    public static final String JAVA_VM_NAME = Server.getSystemProperty("java.vm.name");
    public static final String JAVA_VM_INFO = Server.getSystemProperty("java.vm.info");
    public static final String JAVA_VM_VENDOR = Server.getSystemProperty("java.vm.vendor");
    public static final String JAVA_VENDOR_URL = Server.getSystemProperty("java.vendor.url");
    public static final String JAVA_VM_VERSION = Server.getSystemProperty("java.vm.version");
    public static final String JAVA_CLASS_PATH = Server.getSystemProperty("java.class.path");
    public static final String JAVA_CLASS_VERSION = Server.getSystemProperty("java.class.version");

    public static String getSystemProperty(String string) {
        try {
            return System.getProperty(string);
        }
        catch (SecurityException securityException) {
            System.err.println("Security Exception\uff1athe system property '" + string + "'; the property value will default to null.");
            return null;
        }
    }

    public static List<String> getMacWindows() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "physical address";
        try {
            Process process = Runtime.getRuntime().exec("ipconfig /all");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string2 = "";
            int n = -1;
            while ((string2 = bufferedReader.readLine()) != null) {
                n = string2.toLowerCase().indexOf(string);
                if (n < 0 || (n = string2.indexOf(":")) < 0) continue;
                arrayList.add(string2.substring(n + 1).trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return arrayList;
    }

    public static List<String> getMacWindowsIP(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = "mac address";
        try {
            Process process = Runtime.getRuntime().exec("nbtstat -A " + string);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = "";
            int n = -1;
            while ((string3 = bufferedReader.readLine()) != null) {
                n = string3.toLowerCase().indexOf(string2);
                if (n < 0) continue;
                arrayList.add(string3.substring(n + 14, string3.length()).trim());
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return arrayList;
    }

    public static List<String> getMacLinux() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "HWaddr";
        String string2 = "\u786c\u4ef6\u5730\u5740";
        try {
            Process process = Runtime.getRuntime().exec("ifconfig");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String string3 = "";
            int n = -1;
            while ((string3 = bufferedReader.readLine()) != null) {
                n = string3.indexOf(string);
                if (n >= 0) {
                    arrayList.add(string3.substring(n + string.length() + 1).trim());
                    continue;
                }
                n = string3.indexOf(string2);
                if (n < 0) continue;
                arrayList.add(string3.substring(n + string2.length() + 1).trim());
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        return arrayList;
    }

    public static String getMac(boolean bl) {
        String string = "";
        List<String> list = null;
        list = OS_NAME.toLowerCase().startsWith("windows") ? Server.getMacWindows() : Server.getMacLinux();
        if (list.size() >= 0) {
            if (bl) {
                return list.toString();
            }
            return list.get(0);
        }
        return string;
    }

    public static String getMac() {
        return Server.getMac(false);
    }

    public static String getIP(String string) {
        String string2 = "";
        try {
            if (Grapes.isEmpty(string)) {
                string2 = OS_NAME.toLowerCase().startsWith("windows") ? InetAddress.getLocalHost().getHostAddress() : Server.getLinuxIP();
            } else {
                InetAddress inetAddress = null;
                if (string.startsWith("http://")) {
                    string = Grapes.substringCenter(string, "http://", null);
                }
                if (string.startsWith("https://")) {
                    string = Grapes.substringCenter(string, "https://", null);
                }
                if (Grapes.isNotEmpty(inetAddress = InetAddress.getByName(string))) {
                    String[] stringArray = Grapes.split(inetAddress.toString(), "/");
                    string2 = Grapes.isNotEmpty(stringArray) && stringArray.length >= 2 ? stringArray[1] : inetAddress.toString();
                }
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return string2;
    }

    public static String getServerIP() {
        return Server.getIP(null);
    }

    public static String getLinuxIP() {
        String string = "";
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                NetworkInterface networkInterface = enumeration.nextElement();
                String string2 = networkInterface.getName();
                if (string2.contains("docker") || string2.contains("lo")) continue;
                Enumeration<InetAddress> enumeration2 = networkInterface.getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    String string3;
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || (string3 = inetAddress.getHostAddress().toString()).contains("::") || string3.contains("0:0:") || string3.contains("fe80")) continue;
                    string = string3;
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return string;
    }
}

