/*
 * Decompiled with CFR 0.152.
 */
package grapes.pack.zxing;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.EncodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.HybridBinarizer;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import grapes.Files;
import grapes.Grapes;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.imageio.ImageIO;

public class QRCodes {
    private static ErrorCorrectionLevel o00000(String string) {
        if ("L".equalsIgnoreCase(string)) {
            return ErrorCorrectionLevel.L;
        }
        if ("Q".equalsIgnoreCase(string)) {
            return ErrorCorrectionLevel.Q;
        }
        if ("M".equalsIgnoreCase(string)) {
            return ErrorCorrectionLevel.M;
        }
        if ("H".equalsIgnoreCase(string)) {
            return ErrorCorrectionLevel.H;
        }
        throw new IllegalArgumentException("invalid error correct level:" + string);
    }

    public boolean encode(String string, String string2, String string3, int n, int n2) {
        string = Files.format(string);
        try {
            Hashtable<EncodeHintType, Object> hashtable = new Hashtable<EncodeHintType, Object>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, QRCodes.o00000(string3));
            hashtable.put(EncodeHintType.CHARACTER_SET, Grapes.CHARSET);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(string2, BarcodeFormat.QR_CODE, n, n2, hashtable);
            Files.isCreateFile(string);
            MatrixToImageWriter.writeToFile((BitMatrix)bitMatrix, (String)"png", (File)new File(string));
            return true;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public OutputStream encode(OutputStream outputStream, String string, String string2, int n, int n2) {
        try {
            Hashtable<EncodeHintType, Object> hashtable = new Hashtable<EncodeHintType, Object>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, QRCodes.o00000(string2));
            hashtable.put(EncodeHintType.CHARACTER_SET, Grapes.CHARSET);
            BitMatrix bitMatrix = new MultiFormatWriter().encode(string, BarcodeFormat.QR_CODE, n, n2, hashtable);
            MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)outputStream);
            return outputStream;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public BufferedImage encode(String string, String string2, int n, int n2) {
        try {
            Hashtable<EncodeHintType, Object> hashtable = new Hashtable<EncodeHintType, Object>();
            hashtable.put(EncodeHintType.ERROR_CORRECTION, QRCodes.o00000(string2));
            hashtable.put(EncodeHintType.CHARACTER_SET, Grapes.CHARSET);
            BitMatrix bitMatrix = new QRCodeWriter().encode(string, BarcodeFormat.QR_CODE, n, n2, hashtable);
            int[] nArray = new int[n * n2];
            int n3 = 0;
            while (n3 < n2) {
                int n4 = 0;
                while (n4 < n) {
                    nArray[n3 * n + n4] = bitMatrix.get(n4, n3) ? -16777216 : 0xFFFFFF;
                    ++n4;
                }
                ++n3;
            }
            BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
            bufferedImage.setRGB(0, 0, n, n2, nArray, 0, n);
            return bufferedImage;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String decode(String string) {
        try {
            BufferedImage bufferedImage = ImageIO.read(new File(string));
            if (bufferedImage == null) {
                System.out.println("the image not exit");
            }
            BufferedImageLuminanceSource bufferedImageLuminanceSource = new BufferedImageLuminanceSource(bufferedImage);
            BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)bufferedImageLuminanceSource));
            Result result = new MultiFormatReader().decode(binaryBitmap, null);
            String string2 = result.getText();
            return string2;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        catch (ReaderException readerException) {
            System.err.println((Object)readerException);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return null;
    }
}

