/*
 * Decompiled with CFR 0.152.
 */
package grapes.image;

import com.gif4j.GifDecoder;
import com.gif4j.GifEncoder;
import com.gif4j.GifImage;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGEncodeParam;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import com.sun.imageio.plugins.bmp.BMPImageReader;
import com.sun.imageio.plugins.gif.GIFImageReader;
import com.sun.imageio.plugins.jpeg.JPEGImageReader;
import com.sun.imageio.plugins.png.PNGImageReader;
import grapes.Dates;
import grapes.Files;
import grapes.Grapes;
import grapes.image.GIFImages;
import grapes.image.GMKImages;
import grapes.image.JPEGImages;
import grapes.image.WaterData;
import grapes.secret.MD5;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.commons.codec.binary.Base64;

public class Images {
    public static final String IMAGES = ".jpg.jpeg.gif.bmp.png";
    public static final Integer QUALITY = 85;
    private WaterData o00000 = new WaterData();

    public WaterData getWaterData() {
        return this.o00000;
    }

    public void setWaterData(WaterData waterData) {
        this.o00000 = waterData;
    }

    public static ImagesDatum getImagesDatum(String string) {
        if ("width".equalsIgnoreCase(string)) {
            return ImagesDatum.width;
        }
        if ("height".equalsIgnoreCase(string)) {
            return ImagesDatum.height;
        }
        return ImagesDatum.auto;
    }

    public static ImagesName getImagesName(String string) {
        if ("save".equalsIgnoreCase(string)) {
            return ImagesName.save;
        }
        if ("name".equalsIgnoreCase(string)) {
            return ImagesName.name;
        }
        return ImagesName.rename;
    }

    public static String getFormatName(Object object) {
        File file;
        String string;
        block21: {
            block19: {
                string = null;
                file = null;
                if (object instanceof String) {
                    file = Files.getFile((String)object);
                } else if (object instanceof File) {
                    file = (File)object;
                }
                if (file != null && file.exists()) break block19;
                return null;
            }
            try {
                ImageInputStream imageInputStream = null;
                try {
                    try {
                        imageInputStream = ImageIO.createImageInputStream(file);
                        Iterator<ImageReader> iterator = ImageIO.getImageReaders(imageInputStream);
                        if (iterator.hasNext()) {
                            ImageReader imageReader = iterator.next();
                            if (imageReader instanceof JPEGImageReader) {
                                string = "jpg";
                            } else if (imageReader instanceof GIFImageReader) {
                                string = "gif";
                            } else if (imageReader instanceof BMPImageReader) {
                                string = "bmp";
                            } else if (imageReader instanceof PNGImageReader) {
                                string = "png";
                            }
                        }
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                        imageInputStream.close();
                        break block21;
                    }
                }
                catch (Throwable throwable) {
                    imageInputStream.close();
                    throw throwable;
                }
                imageInputStream.close();
            }
            catch (Exception exception) {
                System.err.println(exception);
            }
        }
        if (Grapes.isEmpty(string) && file != null) {
            string = Files.getExte(file.getName());
        }
        return string;
    }

    public static boolean isImage(File file) {
        if (file == null || !file.exists()) {
            return false;
        }
        String string = Images.getFormatName(file);
        return Grapes.isNotEmpty(string) && IMAGES.indexOf("." + string) != -1;
    }

    public static boolean isSame(Object object, Object object2) {
        File file = null;
        File file2 = null;
        try {
            if (object instanceof String) {
                file = Files.getFile(Files.format((String)object));
            } else if (object instanceof File) {
                file = (File)object;
            }
            if (object2 instanceof String) {
                file2 = Files.getFile(Files.format((String)object2));
            } else if (object2 instanceof File) {
                file2 = (File)object2;
            }
            if (file != null && file.exists() && file2 != null && file2.exists()) {
                String string;
                String string2 = MD5.encrypt(file);
                return string2.equals(string = MD5.encrypt(file2));
            }
            return false;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean isShow(Object object) {
        String string;
        block4: {
            try {
                string = Images.getFormatName(object);
                if (!Grapes.isEmpty(string)) break block4;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        if (string.equalsIgnoreCase("gif")) {
            return Images.isShow(Images.readGIFImage(object));
        }
        return Images.isShow(Images.readJPEGImage(object));
    }

    public static boolean isShow(GifImage gifImage) {
        if (gifImage == null) {
            return false;
        }
        try {
            return Grapes.isInteger(gifImage.getNumberOfFrames());
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean isShow(BufferedImage bufferedImage) {
        if (bufferedImage == null) {
            return false;
        }
        try {
            return Grapes.isInteger(bufferedImage.getType());
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean writeImage(GifImage gifImage, Object object) {
        OutputStream outputStream;
        block11: {
            outputStream = null;
            try {
                if (object instanceof String) {
                    outputStream = new FileOutputStream(Files.format((String)object));
                } else if (object instanceof File) {
                    outputStream = new FileOutputStream((File)object);
                } else if (object instanceof OutputStream) {
                    outputStream = (OutputStream)object;
                }
                if (outputStream != null) break block11;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        try {
            GifEncoder.encode((GifImage)gifImage, (OutputStream)outputStream);
        }
        finally {
            gifImage = null;
            outputStream.flush();
            outputStream.close();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean writeImage(BufferedImage bufferedImage, Object object, Integer n) {
        OutputStream outputStream = null;
        if (Grapes.isEmpty(n)) {
            n = QUALITY;
        }
        try {
            if (object instanceof String) {
                outputStream = new FileOutputStream(Files.format((String)object));
            } else if (object instanceof File) {
                outputStream = new FileOutputStream((File)object);
            } else if (object instanceof OutputStream) {
                outputStream = (OutputStream)object;
            }
            if (outputStream == null) {
                return false;
            }
            try {
                int n2 = bufferedImage.getColorModel().getTransparency();
                if (n2 == 2 || n2 == 3 || n2 == 6 || n2 == 7) {
                    ImageIO.write((RenderedImage)bufferedImage, "png", outputStream);
                    return true;
                }
                JPEGImageEncoder jPEGImageEncoder = JPEGCodec.createJPEGEncoder((OutputStream)outputStream);
                JPEGEncodeParam jPEGEncodeParam = jPEGImageEncoder.getDefaultJPEGEncodeParam(bufferedImage);
                jPEGEncodeParam.setQuality((float)n.intValue() / 100.0f, true);
                jPEGImageEncoder.encode(bufferedImage, jPEGEncodeParam);
                return true;
            }
            finally {
                bufferedImage.flush();
                bufferedImage = null;
                outputStream.flush();
                outputStream.close();
                outputStream = null;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public static boolean writeImage(BufferedImage bufferedImage, Object object) {
        return Images.writeImage(bufferedImage, object, QUALITY);
    }

    public static GifImage readGIFImage(Object object) {
        try {
            if (object instanceof String) {
                return GifDecoder.decode((File)Files.getFile((String)object));
            }
            if (object instanceof File) {
                return GifDecoder.decode((File)((File)object));
            }
            if (object instanceof InputStream) {
                return GifDecoder.decode((InputStream)((InputStream)object));
            }
        }
        catch (IOException iOException) {
            System.err.println("Read error:" + iOException);
        }
        return null;
    }

    public static BufferedImage readJPEGImage(Object object) {
        try {
            if (object instanceof String) {
                return ImageIO.read(Files.getFile((String)object));
            }
            if (object instanceof File) {
                return ImageIO.read((File)object);
            }
            if (object instanceof InputStream) {
                return ImageIO.read((InputStream)object);
            }
        }
        catch (IOException iOException) {
            System.err.println("Read error:" + iOException);
        }
        return null;
    }

    public static GifImage readURLGIFImage(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                GifImage gifImage = Images.readGIFImage(dataInputStream);
                return gifImage;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("URL error:" + string + " " + runtimeException);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Unable to connect:" + string + " " + malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println("Read error:" + iOException);
        }
        finally {
            httpURLConnection.disconnect();
        }
        return null;
    }

    public static BufferedImage readURLJPEGImage(String string) {
        HttpURLConnection httpURLConnection = null;
        try {
            URL uRL = new URL(string);
            httpURLConnection = (HttpURLConnection)uRL.openConnection();
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                DataInputStream dataInputStream = new DataInputStream(httpURLConnection.getInputStream());
                BufferedImage bufferedImage = Images.readJPEGImage(dataInputStream);
                return bufferedImage;
            }
        }
        catch (RuntimeException runtimeException) {
            System.err.println("URL error:" + string + " " + runtimeException);
        }
        catch (MalformedURLException malformedURLException) {
            System.err.println("Unable to connect:" + string + " " + malformedURLException);
        }
        catch (IOException iOException) {
            System.err.println("Read error:" + iOException);
        }
        finally {
            httpURLConnection.disconnect();
        }
        return null;
    }

    public static boolean readURLGIFImage(Object object, Object object2, ImagesName imagesName) {
        GifImage gifImage;
        String string;
        String string2;
        block12: {
            string2 = "";
            string = "";
            gifImage = null;
            try {
                if (object instanceof String) {
                    gifImage = Images.readURLGIFImage((String)object);
                    string = Files.getExte((String)object);
                    if (Grapes.isEmpty(string)) {
                        string = "jpg";
                    }
                } else if (object instanceof GifImage) {
                    gifImage = (GifImage)object;
                    string = "gif";
                }
                if (Images.isShow(gifImage)) break block12;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof File) {
            string2 = ((File)object2).getParent();
        }
        if (Grapes.isNotEmpty(string2) && imagesName != ImagesName.save) {
            string2 = imagesName == ImagesName.name ? String.valueOf(string2) + "/" + Files.getFileName((String)object) : String.valueOf(string2) + "/" + Dates.getTimeMillis() + "." + string;
        }
        if (object2 instanceof String) {
            return Images.writeImage(gifImage, (Object)string2);
        }
        return Images.writeImage(gifImage, object2);
    }

    public static boolean readURLJPEGImage(Object object, Object object2, ImagesName imagesName) {
        BufferedImage bufferedImage;
        String string;
        String string2;
        block12: {
            string2 = "";
            string = "";
            bufferedImage = null;
            try {
                if (object instanceof String) {
                    bufferedImage = Images.readURLJPEGImage((String)object);
                    string = Files.getExte((String)object);
                    if (Grapes.isEmpty(string)) {
                        string = "jpg";
                    }
                } else if (object instanceof BufferedImage) {
                    bufferedImage = (BufferedImage)object;
                    string = "gif";
                }
                if (Images.isShow(bufferedImage)) break block12;
                return false;
            }
            catch (Exception exception) {
                System.err.println(exception);
                return false;
            }
        }
        if (object2 instanceof String) {
            string2 = (String)object2;
        } else if (object2 instanceof File) {
            string2 = ((File)object2).getParent();
        }
        if (Grapes.isNotEmpty(string2) && imagesName != ImagesName.save) {
            string2 = imagesName == ImagesName.name ? String.valueOf(string2) + "/" + Files.getFileName(Files.format((String)object)) : String.valueOf(string2) + "/" + Dates.getTimeMillis() + "." + string;
        }
        if (object2 instanceof String) {
            return Images.writeImage(bufferedImage, (Object)string2);
        }
        return Images.writeImage(bufferedImage, object2);
    }

    public static boolean readURLImage(String string, String string2, ImagesName imagesName) {
        String string3 = Files.getExte(string);
        if (string3.equalsIgnoreCase("gif")) {
            return Images.readURLGIFImage(string, string2, imagesName);
        }
        return Images.readURLJPEGImage(string, string2, imagesName);
    }

    public static String getImageBase64(String string) {
        byte[] byArray;
        block27: {
            InputStream inputStream = null;
            ByteArrayOutputStream byteArrayOutputStream = null;
            byArray = null;
            try {
                try {
                    if (string.startsWith("http://") || string.startsWith("https://")) {
                        URL uRL = new URL(string);
                        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                        httpURLConnection.setRequestMethod("GET");
                        httpURLConnection.setConnectTimeout(5000);
                        inputStream = httpURLConnection.getInputStream();
                        byteArrayOutputStream = new ByteArrayOutputStream();
                        byArray = new byte[1024];
                        int n = -1;
                        while ((n = inputStream.read(byArray)) != -1) {
                            byteArrayOutputStream.write(byArray, 0, n);
                        }
                        byArray = byteArrayOutputStream.toByteArray();
                    } else {
                        inputStream = new FileInputStream(string);
                        int n = 0;
                        while (n == 0) {
                            n = inputStream.available();
                        }
                        byArray = new byte[n];
                        inputStream.read(byArray);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                throw throwable;
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (byteArrayOutputStream != null) {
                try {
                    byteArrayOutputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return Base64.encodeBase64String((byte[])byArray);
    }

    public static boolean getBase64Image(String string, String string2) {
        boolean bl;
        block14: {
            bl = false;
            OutputStream outputStream = null;
            try {
                try {
                    byte[] byArray = Base64.decodeBase64((String)string);
                    int n = 0;
                    while (n < byArray.length) {
                        if (byArray[n] < 0) {
                            int n2 = n;
                            byArray[n2] = (byte)(byArray[n2] + 256);
                        }
                        ++n;
                    }
                    outputStream = new FileOutputStream(string2);
                    outputStream.write(byArray);
                    bl = true;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (outputStream == null) break block14;
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            finally {
                if (outputStream != null) {
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return bl;
    }

    public static String getBase64Pic(String string, String string2) {
        return "data:image/" + string2 + ";base64," + string;
    }

    public static String getPicBase64(String string, String string2) {
        return Grapes.removeStart(string, "data:image/" + string2 + ";base64,");
    }

    public boolean watermark(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        try {
            String string4 = Images.getFormatName(string);
            if (string4.equalsIgnoreCase("gif")) {
                GIFImages gIFImages = new GIFImages();
                gIFImages.setWaterData(this.o00000);
                return gIFImages.watermark(string, string2, n2, n3, n4, n6, bl);
            }
            if (bl2 && GMKImages.isGraphicsMagickEnable()) {
                GMKImages gMKImages = new GMKImages();
                gMKImages.setWaterData(this.o00000);
                return gMKImages.watermark(string, string2, n, n2, n5, n6, bl);
            }
            JPEGImages jPEGImages = new JPEGImages();
            jPEGImages.setWaterData(this.o00000);
            return jPEGImages.watermark(string, string2, string3, n, n2, n3, n4, n5, n6, bl);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public boolean watermark(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, boolean bl) {
        return this.watermark(string, string2, string3, n, n2, n3, n4, n5, n6, bl, true);
    }

    public boolean watermark(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl) {
        return this.watermark(string, string2, string3, QUALITY, n, n2, n3, 0, n4, bl);
    }

    public boolean watermark(String string, String string2, int n, int n2, int n3, int n4, boolean bl) {
        return this.watermark(string, string, string2, QUALITY, n, n2, n3, 0, n4, bl);
    }

    public boolean zoom(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, boolean bl2, ImagesDatum imagesDatum, boolean bl3) {
        try {
            if (bl3 && GMKImages.isGraphicsMagickEnable()) {
                GMKImages gMKImages = new GMKImages();
                return gMKImages.zoom(string, string2, n, n2, n3, n4, bl, bl2, imagesDatum);
            }
            String string4 = Images.getFormatName(string);
            if (string4.equalsIgnoreCase("gif")) {
                GIFImages gIFImages = new GIFImages();
                return gIFImages.zoom(string, string2, n2, n3, n4, bl, bl2, imagesDatum);
            }
            JPEGImages jPEGImages = new JPEGImages();
            return jPEGImages.zoom(string, string2, string3, n, n2, n3, n4, bl, bl2, imagesDatum);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public boolean zoom(String string, String string2, String string3, int n, int n2, int n3, int n4, boolean bl, boolean bl2, ImagesDatum imagesDatum) {
        return this.zoom(string, string2, string3, n, n2, n3, n4, bl, bl2, imagesDatum, true);
    }

    public boolean zoom(String string, String string2, String string3, int n, int n2, int n3, boolean bl, boolean bl2, ImagesDatum imagesDatum) {
        return this.zoom(string, string2, string3, QUALITY, n, n2, n3, bl, bl2, imagesDatum);
    }

    public boolean zoom(String string, String string2, int n, int n2, int n3, boolean bl, boolean bl2, ImagesDatum imagesDatum) {
        return this.zoom(string, string, string2, QUALITY, n, n2, n3, bl, bl2, imagesDatum);
    }

    public boolean crop(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, boolean bl) {
        try {
            if (bl && GMKImages.isGraphicsMagickEnable()) {
                GMKImages gMKImages = new GMKImages();
                return gMKImages.crop(string, string2, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            String string4 = Images.getFormatName(string);
            if (string4.equalsIgnoreCase("gif")) {
                GIFImages gIFImages = new GIFImages();
                return gIFImages.crop(string, string2, n2, n3, n4, n5, n6, n7, n8, n9, n10);
            }
            JPEGImages jPEGImages = new JPEGImages();
            return jPEGImages.crop(string, string2, string3, n, n2, n3, n4, n5, n6, n7, n8, n9, n10);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public boolean crop(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10) {
        return this.crop(string, string2, string3, n, n2, n3, n4, n5, n6, n7, n8, n9, n10, true);
    }

    public boolean crop(String string, String string2, String string3, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.crop(string, string2, string3, QUALITY, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public boolean crop(String string, String string2, String string3, int n, int n2, int n3, int n4) {
        return this.crop(string, string2, string3, QUALITY, 0, 0, 0, 0, 0, n, n2, n3, n4);
    }

    public boolean crop(String string, String string2, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        return this.crop(string, string, string2, QUALITY, n, n2, n3, n4, n5, n6, n7, n8, n9);
    }

    public boolean crop(String string, String string2, int n, int n2, int n3, int n4) {
        return this.crop(string, string, string2, QUALITY, 0, 0, 0, 0, 0, n, n2, n3, n4);
    }

    public boolean degree(String string, String string2, int n, int n2, boolean bl) {
        try {
            if (bl && GMKImages.isGraphicsMagickEnable()) {
                GMKImages gMKImages = new GMKImages();
                return gMKImages.degree(string, string2, n, n2);
            }
            String string3 = Images.getFormatName(string);
            if (string3.equalsIgnoreCase("gif")) {
                GIFImages gIFImages = new GIFImages();
                return gIFImages.degree(string, string2, n2);
            }
            JPEGImages jPEGImages = new JPEGImages();
            return jPEGImages.degree(string, string2, null, n, n2);
        }
        catch (Exception exception) {
            System.err.println(exception);
            return false;
        }
    }

    public boolean degree(String string, String string2, int n, int n2) {
        return this.degree(string, string2, n, n2, true);
    }

    public static enum ImagesDatum {
        auto,
        width,
        height;

    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static enum ImagesName {
        save,
        name,
        rename;

    }
}

