/*
 * Decompiled with CFR 0.152.
 */
package grapes.image;

import com.drew.imaging.ImageMetadataReader;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.Tag;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.ExifSubIFDDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import grapes.Dates;
import grapes.Files;
import grapes.Grapes;
import grapes.pack.JSON;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EXIFImages {
    public static List<Map<String, String>> getEXIF(Object object) {
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        HashMap<String, String> hashMap = null;
        File file = null;
        try {
            if (object instanceof String) {
                file = Files.getFile(Files.format((String)object));
            } else if (object instanceof File) {
                file = (File)object;
            }
            if (file.exists()) {
                Metadata metadata = ImageMetadataReader.readMetadata((File)file);
                for (Directory directory : metadata.getDirectories()) {
                    hashMap = new HashMap<String, String>();
                    hashMap.put(directory.getName(), directory.getDescription(0));
                    for (Tag tag : directory.getTags()) {
                        hashMap.put(tag.getTagName(), tag.getDescription());
                    }
                    arrayList.add(hashMap);
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return null;
        }
    }

    public static String getData(Object object, List<Map<String, String>> list, String string) {
        if (list == null) {
            list = EXIFImages.getEXIF(object);
        }
        for (Map<String, String> map : list) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                if (!string.equalsIgnoreCase(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getInfo(Object object) {
        block28: {
            File file = null;
            if (object instanceof String) {
                file = Files.getFile(Files.format((String)object));
            } else if (object instanceof File) {
                file = (File)object;
            }
            if (file == null || !file.exists()) break block28;
            try {
                Metadata metadata = ImageMetadataReader.readMetadata((File)file);
                if (Grapes.isEmpty(metadata)) {
                    return null;
                }
                Directory directory = metadata.getDirectory(JpegDirectory.class);
                Directory directory2 = metadata.getDirectory(ExifSubIFDDirectory.class);
                Directory directory3 = metadata.getDirectory(ExifIFD0Directory.class);
                HashMap<String, String> hashMap = new HashMap<String, String>();
                if (directory != null) {
                    if (directory.containsTag(3)) {
                        hashMap.put("width", directory.getDescription(3).replace(" pixels", ""));
                    }
                    if (directory.containsTag(1)) {
                        hashMap.put("height", directory.getDescription(1).replace(" pixels", ""));
                    }
                }
                if (directory3 != null) {
                    if (directory3.containsTag(271)) {
                        hashMap.put("make", directory3.getDescription(271));
                    }
                    if (directory3.containsTag(272)) {
                        hashMap.put("model", directory3.getDescription(272));
                    }
                    if (directory3.containsTag(282)) {
                        hashMap.put("xResolution", directory3.getDescription(282).replace(" dots per inch", ""));
                    }
                    if (directory3.containsTag(283)) {
                        hashMap.put("yResolution", directory3.getDescription(283).replace(" dots per inch", ""));
                    }
                    if (directory3.containsTag(40091)) {
                        hashMap.put("winTitle", directory3.getDescription(40091));
                    }
                    if (directory3.containsTag(40093)) {
                        hashMap.put("winAuthor", directory3.getDescription(40093));
                    }
                }
                if (directory2 != null) {
                    if (directory2.containsTag(37386)) {
                        hashMap.put("focalLength", directory2.getDescription(37386));
                    }
                    if (directory2.containsTag(33434)) {
                        hashMap.put("exposureTime", directory2.getDescription(33434));
                    }
                    if (directory2.containsTag(33437)) {
                        hashMap.put("fNumber", directory2.getDescription(33437));
                    }
                    if (directory2.containsTag(37385)) {
                        hashMap.put("flash", directory2.getDescription(37385));
                    }
                    if (directory2.containsTag(37380)) {
                        hashMap.put("exposurBias", directory2.getDescription(37380));
                    }
                    if (directory2.containsTag(41986)) {
                        hashMap.put("exposureMode", directory2.getDescription(41986));
                    }
                    if (directory2.containsTag(34855)) {
                        hashMap.put("isoEquivalent", directory2.getDescription(34855));
                    }
                    if (directory2.containsTag(36867)) {
                        Date date = directory2.getDate(36867);
                        hashMap.put("dateTimeOriginal", Dates.parseString(date));
                    }
                }
                return hashMap;
            }
            catch (Exception exception) {
                try {
                    exception.printStackTrace();
                    return null;
                }
                catch (Exception exception2) {
                    exception2.printStackTrace();
                    return null;
                }
            }
        }
        return null;
    }

    public static String getInfoJSON(Object object) {
        Map<String, String> map = EXIFImages.getInfo(object);
        if (Grapes.isNotEmpty(map)) {
            return JSON.toJson(map);
        }
        return null;
    }
}

