/*
 * Decompiled with CFR 0.152.
 */
package grapes.gzip;

import grapes.Grapes;
import grapes.gzip.GZIPResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GZIPFilter
implements Filter {
    private final int o00000 = 20;
    boolean isGZIPEnabled = false;

    public void init(FilterConfig filterConfig) throws ServletException {
        String string = filterConfig.getInitParameter("gzip");
        this.isGZIPEnabled = Grapes.isEmpty(string) ? this.isGZIPEnabled : Grapes.isBoolean(string, this.isGZIPEnabled);
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        if (this.isGZIPEnabled && this.super(httpServletRequest) && !httpServletResponse.isCommitted()) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            GZIPResponseWrapper gZIPResponseWrapper = new GZIPResponseWrapper(httpServletResponse, gZIPOutputStream);
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)gZIPResponseWrapper);
            gZIPResponseWrapper.flush();
            gZIPOutputStream.close();
            if (gZIPResponseWrapper.getStatus() != 200) {
                return;
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length == 20) {
                byArray = new byte[]{};
            }
            httpServletResponse.setHeader("Content-Encoding", "gzip");
            httpServletResponse.setContentLength(byArray.length);
            httpServletResponse.getOutputStream().write(byArray);
        } else {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    private boolean super(HttpServletRequest httpServletRequest) {
        Enumeration enumeration = httpServletRequest.getHeaders("Accept-Encoding");
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("gzip") == -1) continue;
            return true;
        }
        return false;
    }

    public void destroy() {
    }
}

