/*
 * Decompiled with CFR 0.152.
 */
package grapes.filter;

import grapes.Files;
import java.io.Serializable;
import java.util.BitSet;

public class BloomFilter
implements Serializable {
    private static final long \u00d500000 = 1L;
    private final int \u00d300000;
    private final int[] \u00d200000;
    private final BitSet String;
    private final HashFunction[] o00000;

    public BloomFilter(MisjudgmentRate misjudgmentRate, int n) {
        long l = misjudgmentRate.\u00d200000.length * n;
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new RuntimeException("Please reduce the error rate or reduce the data size.");
        }
        this.\u00d200000 = misjudgmentRate.\u00d200000;
        this.\u00d300000 = (int)l;
        this.String = new BitSet(this.\u00d300000);
        this.o00000 = new HashFunction[this.\u00d200000.length];
        int n2 = 0;
        while (n2 < this.\u00d200000.length) {
            this.o00000[n2] = new HashFunction(this.\u00d300000, this.\u00d200000[n2]);
            ++n2;
        }
    }

    public BloomFilter(int n) {
        this(MisjudgmentRate.MIDDLE, n);
    }

    public void add(String string) {
        if (string == null) {
            return;
        }
        HashFunction[] hashFunctionArray = this.o00000;
        int n = this.o00000.length;
        int n2 = 0;
        while (n2 < n) {
            HashFunction hashFunction = hashFunctionArray[n2];
            this.String.set(hashFunction.hash(string), true);
            ++n2;
        }
    }

    public boolean contains(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = true;
        HashFunction[] hashFunctionArray = this.o00000;
        int n = this.o00000.length;
        int n2 = 0;
        while (n2 < n) {
            HashFunction hashFunction = hashFunctionArray[n2];
            bl = this.String.get(hashFunction.hash(string));
            if (!bl) break;
            ++n2;
        }
        return bl;
    }

    public boolean containsAdd(String string) {
        if (!this.contains(string)) {
            this.add(string);
            return true;
        }
        return false;
    }

    public BitSet getBitset() {
        return this.String;
    }

    public boolean save(String string) {
        return Files.serialize(string, this);
    }

    public static BloomFilter read(String string) {
        return (BloomFilter)Files.unserialize(string);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class HashFunction
    implements Serializable {
        private static final long \u00d400000 = 1L;
        private int \u00d300000;
        private int \u00d200000;

        public HashFunction(int n, int n2) {
            this.\u00d300000 = n;
            this.\u00d200000 = n2;
        }

        public int hash(String string) {
            int n = 0;
            int n2 = string.length();
            if (n2 > 0) {
                int n3 = 0;
                while (n3 < n2) {
                    n = this.\u00d200000 * n + string.charAt(n3);
                    ++n3;
                }
            }
            n = this.\u00d300000 - 1 & n;
            return n;
        }
    }

    public static enum MisjudgmentRate {
        VERY_SMALL(new int[]{2, 3, 5, 7}),
        SMALL(new int[]{2, 3, 5, 7, 11, 13, 17, 19}),
        MIDDLE(new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53}),
        HIGH(new int[]{2, 3, 5, 7, 11, 13, 17, 19, 23, 29, 31, 37, 41, 43, 47, 53, 59, 61, 67, 71, 73, 79, 83, 89, 97, 101, 103, 107, 109, 113, 127, 131});

        private int[] \u00d200000;

        private MisjudgmentRate(int[] nArray) {
            this.\u00d200000 = nArray;
        }

        public int[] getSeeds() {
            return this.\u00d200000;
        }

        public void setSeeds(int[] nArray) {
            this.\u00d200000 = nArray;
        }
    }
}

