/*
 * Decompiled with CFR 0.152.
 */
package grapes.cache;

import grapes.Dates;
import grapes.Files;
import grapes.Grapes;
import grapes.cache.CacheData;
import grapes.cache.Config;
import grapes.secret.MD5;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Cache {
    private static Logger \u00f400000 = LoggerFactory.getLogger(Cache.class);
    private ConcurrentHashMap<String, CacheData> \u00d800000;
    private CacheGenre return = CacheGenre.M;
    private String \u00d300000 = Grapes.getResourcePath(this);
    private String \u00f500000 = ".cache";
    private String \u00d500000 = "10M";
    private long o00000 = 0L;
    private int new = 10;
    private static boolean \u00d400000 = false;

    public static Cache getInstance() {
        return CacheHolder.super;
    }

    private Cache() {
        this.\u00d800000 = new ConcurrentHashMap();
        Map<String, Object> map = Config.getInstance().getCacheMap();
        if (Grapes.isNotEmpty(map)) {
            if (Grapes.isNotEmpty(map.get("status"))) {
                \u00d400000 = Grapes.isBoolean((String)map.get("status"), \u00d400000);
            }
            if (Grapes.isNotEmpty(map.get("genre"))) {
                if (((String)map.get("genre")).equalsIgnoreCase("M")) {
                    this.return = CacheGenre.M;
                } else if (((String)map.get("genre")).equalsIgnoreCase("HD")) {
                    this.return = CacheGenre.HD;
                } else if (((String)map.get("genre")).equalsIgnoreCase("MHD")) {
                    this.return = CacheGenre.MHD;
                }
            }
            if (Grapes.isNotEmpty(map.get("free"))) {
                this.\u00d500000 = (String)map.get("free");
            }
            if (Grapes.isNotEmpty(map.get("path"))) {
                this.\u00d300000 = String.valueOf(this.\u00d300000) + (String)map.get("path");
            }
            if (Grapes.isNotEmpty(map.get("exte"))) {
                this.\u00f500000 = (String)map.get("exte");
            }
            if (Grapes.isNotEmpty(map.get("time"))) {
                this.o00000 = Long.parseLong((String)map.get("time"));
            }
            if (Grapes.isNotEmpty(map.get("count"))) {
                this.new = Integer.parseInt((String)map.get("count"));
            }
        }
    }

    public Cache(CacheGenre cacheGenre, String string, String string2, String string3) {
        this.\u00d800000 = new ConcurrentHashMap();
        if (Grapes.isNotEmpty((Object)cacheGenre)) {
            this.return = cacheGenre;
        }
        if (Grapes.isNotEmpty(string)) {
            this.\u00d500000 = string;
        }
        if (Grapes.isNotEmpty(string2)) {
            this.\u00d300000 = String.valueOf(this.\u00d300000) + string2;
        }
        if (Grapes.isNotEmpty(string3)) {
            this.\u00f500000 = string3;
        }
    }

    public Cache(CacheGenre cacheGenre, String string) {
        this.\u00d800000 = new ConcurrentHashMap();
        if (Grapes.isNotEmpty((Object)cacheGenre)) {
            this.return = cacheGenre;
        }
        if (Grapes.isNotEmpty(string)) {
            this.\u00d300000 = String.valueOf(this.\u00d300000) + string;
        }
    }

    public Cache(CacheGenre cacheGenre) {
        this.\u00d800000 = new ConcurrentHashMap();
        if (Grapes.isNotEmpty((Object)cacheGenre)) {
            this.return = cacheGenre;
        }
    }

    public Cache maxTime(long l) {
        if (l > 0L) {
            this.o00000 = l;
        }
        return this;
    }

    public Cache maxCount(int n) {
        if (n > 0) {
            this.new = n;
        }
        return this;
    }

    public boolean getStatus() {
        return \u00d400000;
    }

    public static String getKey(String string, String string2, Object[] objectArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (Grapes.isNotEmpty(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("cache");
        }
        if (Grapes.isNotEmpty(string2)) {
            stringBuffer.append("_").append(string2);
        }
        if (Grapes.isNotEmpty(objectArray)) {
            stringBuffer.append("_").append(MD5.encrypt(Grapes.unsplit(objectArray)).substring(8, 24));
        }
        return stringBuffer.toString();
    }

    public String getKeyFile(String string, String string2, Object[] objectArray) {
        return String.valueOf(this.\u00d300000) + Cache.getKey(string, string2, objectArray) + this.\u00f500000;
    }

    public String getKeyFile(String string) {
        return String.valueOf(this.\u00d300000) + string + this.\u00f500000;
    }

    public void remove(String string) {
        if (this.return == CacheGenre.M || this.return == CacheGenre.MHD) {
            this.\u00d800000.remove(string);
        }
        if (this.return == CacheGenre.HD || this.return == CacheGenre.MHD) {
            Files.delete(this.getKeyFile(string));
        }
    }

    public void removeAll() {
        if (this.return == CacheGenre.M || this.return == CacheGenre.MHD) {
            this.\u00d800000.clear();
        }
        if (this.return == CacheGenre.HD || this.return == CacheGenre.MHD) {
            Files.clear(this.\u00d300000);
        }
    }

    public void remove(String string, String string2) {
        String string3;
        StringBuffer stringBuffer = new StringBuffer();
        if (Grapes.isNotEmpty(string)) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append("cache");
        }
        if (Grapes.isNotEmpty(string2)) {
            stringBuffer.append("_").append(string2);
        }
        if (Grapes.isEmpty(string3 = stringBuffer.toString())) {
            return;
        }
        if (this.return == CacheGenre.M || this.return == CacheGenre.MHD) {
            for (Object object : this.\u00d800000.keySet()) {
                if (!((String)object).startsWith(string3)) continue;
                this.remove((String)object);
            }
        }
        if (this.return == CacheGenre.HD || this.return == CacheGenre.MHD) {
            Object object;
            object = Files.getList(this.\u00d300000);
            String[] stringArray = object;
            int n = ((String[])object).length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = stringArray[n2];
                if (((String)(object2 = ((String)object2).replaceAll(this.\u00f500000, ""))).startsWith(string3)) {
                    this.remove((String)object2);
                }
                ++n2;
            }
        }
    }

    public void addData(String string, Object object) {
        if (!\u00d400000) {
            return;
        }
        String string2 = this.getKeyFile(string);
        CacheData cacheData = new CacheData(object);
        if (this.return == CacheGenre.M || this.return == CacheGenre.MHD) {
            if (Runtime.getRuntime().freeMemory() < Files.getFileSizeByte(this.\u00d500000)) {
                if (this.return == CacheGenre.M) {
                    \u00f400000.warn("Memory\uff1a\u5185\u5b58\u4e0d\u8db3\uff0c\u5f00\u59cb\u6e05\u7a7a\u7f13\u5b58!");
                    this.removeAll();
                    this.\u00d800000.put(string, cacheData);
                    return;
                }
                Files.serialize(string2, cacheData);
                return;
            }
            this.\u00d800000.containsKey(string);
            this.\u00d800000.put(string, cacheData);
            return;
        }
        Files.serialize(string2, cacheData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object getData(String string, long l, int n) {
        if (!\u00d400000) {
            return null;
        }
        String string2 = this.getKeyFile(string);
        CacheData cacheData = new CacheData();
        if (this.return == CacheGenre.M || this.return == CacheGenre.MHD) {
            cacheData = this.\u00d800000.get(string);
            if (Grapes.isEmpty(cacheData)) {
                if (this.return != CacheGenre.MHD) return null;
                if (Grapes.isNotEmpty(Files.getFile(string2)) && Grapes.isEmpty(cacheData = (CacheData)Files.unserialize(string2))) {
                    return null;
                }
            }
        } else if (Grapes.isNotEmpty(Files.getFile(string2)) && Grapes.isEmpty(cacheData = (CacheData)Files.unserialize(string2))) {
            return null;
        }
        if (l > 0L && Dates.getIntervalKey(cacheData.getTime()) > l) {
            this.remove(string);
            return null;
        }
        if (n > 0 && n - cacheData.getCount() <= 0) {
            this.remove(string);
            return null;
        }
        cacheData.addCount();
        if (this.return != CacheGenre.HD && this.return != CacheGenre.MHD || !Grapes.isNotEmpty(Files.getFile(string2))) return cacheData.getData();
        Files.serialize(string2, cacheData);
        return cacheData.getData();
    }

    public Object getData(String string) {
        return this.getData(string, this.o00000, this.new);
    }

    public Object getData(String string, String string2, Object[] objectArray, long l, int n) {
        String string3 = Cache.getKey(string, string2, objectArray);
        return this.getData(string3, l, n);
    }

    public Object getData(String string, String string2, Object[] objectArray) {
        String string3 = Cache.getKey(string, string2, objectArray);
        return this.getData(string3, this.o00000, this.new);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Memory size\uff1a");
        stringBuffer.append(this.\u00d800000.size());
        return stringBuffer.toString();
    }

    /* synthetic */ Cache(Cache cache) {
        this();
    }

    public static enum CacheGenre {
        M,
        HD,
        MHD;

    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class CacheHolder {
        private static Cache super = new Cache(null);

        private CacheHolder() {
        }
    }
}

