/*
 * Decompiled with CFR 0.152.
 */
package grapes;

import grapes.tools.Mobile;
import grapes.tools.UTF8URL;
import grapes.tools.ua.Agent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.text.NumberFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Grapes {
    public static String CHARSET = "UTF-8";
    public static String SEPARATOR = System.getProperty("line.separator", "\\r?\\n");
    private static String super = " 0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ(.+/;=-\u00a9\u00ae\u2122)";
    private static String \u00d400000 = "JSPGen-Grapes";
    private static String \u00d300000 = "4.0";
    private static String \u00d200000 = "20201010";

    public static boolean isEmpty(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof String) {
            if (object.toString().equals("") || object.toString().length() == 0) {
                return true;
            }
            String string = object.toString();
            if ("null".equals(string)) {
                return true;
            }
            return Pattern.compile("^(\\s)*$").matcher(string).matches();
        }
        if (object instanceof Collection && ((Collection)object).isEmpty() && ((Collection)object).size() == 0) {
            return true;
        }
        if (object instanceof Map && ((Map)object).isEmpty() && ((Map)object).size() == 0) {
            return true;
        }
        return object instanceof Object[] && ((Object[])object).length == 0;
    }

    public static Object isEmpty(Object object, Object object2) {
        if (!Grapes.isEmpty(object)) {
            return object;
        }
        if (!Grapes.isEmpty(object2)) {
            return object2;
        }
        return null;
    }

    public static boolean isNotEmpty(Object object) {
        return !Grapes.isEmpty(object);
    }

    public static boolean isRegex(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return false;
        }
        return Pattern.matches(string2, string);
    }

    public static boolean isBoolean(Object object) {
        if (Grapes.isEmpty(object)) {
            return false;
        }
        if (object instanceof Boolean) {
            return true;
        }
        if (object instanceof String) {
            try {
                Boolean.valueOf(((String)object).trim());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static boolean isBoolean(String string, boolean bl) {
        if (Grapes.isBoolean(string)) {
            return Boolean.valueOf(string.trim());
        }
        return bl;
    }

    public static boolean isNumber(String string) {
        return Grapes.isRegex(string, "[0-9]*");
    }

    public static String isNumber(String string, String string2) {
        if (Grapes.isNumber(string)) {
            return string;
        }
        if (Grapes.isNumber(string2)) {
            return string2;
        }
        return null;
    }

    public static boolean isInteger(Object object) {
        if (Grapes.isEmpty(object)) {
            return false;
        }
        if (object instanceof Integer) {
            return true;
        }
        if (object instanceof String) {
            try {
                Integer.parseInt(((String)object).trim());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static Integer isInteger(String string, Integer n) {
        if (Grapes.isEmpty(string)) {
            return n;
        }
        if (Grapes.isInteger(string)) {
            return Integer.parseInt(string.trim());
        }
        return n;
    }

    public static boolean isLong(Object object) {
        if (Grapes.isEmpty(object)) {
            return false;
        }
        if (object instanceof Long) {
            return true;
        }
        if (object instanceof String) {
            try {
                Long.parseLong(((String)object).trim());
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
        return false;
    }

    public static Long isLong(String string, Long l) {
        if (Grapes.isEmpty(string)) {
            return l;
        }
        if (Grapes.isLong(string)) {
            return Long.parseLong(string.trim());
        }
        return l;
    }

    public static boolean isArray(Object object) {
        if (object instanceof Object[]) {
            return true;
        }
        if (object instanceof Collection) {
            return true;
        }
        return object instanceof Map;
    }

    public static boolean isEnglish(String string) {
        return Grapes.isRegex(string, "[a-zA-Z]");
    }

    public static boolean isChinese(String string) {
        return Grapes.isRegex(string, "[\\u4e00-\\u9fa5]");
    }

    public static boolean isDoubleByte(String string) {
        boolean bl = false;
        if (!Grapes.isEmpty(string)) {
            bl = Grapes.bytes(string, "GBK") != string.length();
        }
        return bl;
    }

    public static boolean isPing(String string, int n) {
        boolean bl = false;
        try {
            BufferedInputStream bufferedInputStream = null;
            HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
            httpURLConnection.setInstanceFollowRedirects(false);
            httpURLConnection.setConnectTimeout(n);
            httpURLConnection.setRequestProperty("User-Agent", Agent.AGENT);
            httpURLConnection.connect();
            int n2 = httpURLConnection.getResponseCode();
            if (n2 == 200 || n2 == 301 || n2 == 302 || n2 == 303 || n2 == 307) {
                bl = true;
            } else {
                System.out.println("status:" + n2 + "[" + string + "]");
            }
            bufferedInputStream = new BufferedInputStream(httpURLConnection.getInputStream());
            bufferedInputStream.close();
            httpURLConnection.disconnect();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static boolean isPing(String string) {
        return Grapes.isPing(string, 5000);
    }

    public static boolean isMobile(String string) {
        return Mobile.isMobile(string);
    }

    public static boolean checkVersion(String string, String string2, String string3) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string3)) {
            return false;
        }
        string2 = Grapes.isEmpty(string2) ? "VERSION" : string2;
        try {
            Class<?> clazz = Grapes.getClazz(string);
            String string4 = (String)clazz.getDeclaredField(string2).get(clazz);
            return Float.parseFloat(string3) > Float.parseFloat(string4);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static boolean checkVersion(String string, String string2) {
        return Grapes.checkVersion(string, null, string2);
    }

    public static String getResourcePath(Object object) {
        if (Grapes.isEmpty(object)) {
            return "";
        }
        return object.getClass().getResource("/").getPath();
    }

    public static File getResourceFile(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        String string2 = Thread.currentThread().getContextClassLoader().getResource(string).getPath();
        File file = null;
        try {
            file = new File(URLDecoder.decode(string2, "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        if (file == null || !file.exists()) {
            file = null;
            System.err.println("This file is not exist[" + string + "]");
        }
        return file;
    }

    public static InputStream getResourceStream(Object object, String string) {
        if (Grapes.isEmpty(object) || Grapes.isEmpty(string)) {
            return null;
        }
        InputStream inputStream = object.getClass().getResourceAsStream(Grapes.addStart(string, "/"));
        return inputStream;
    }

    public static Class<?> getClazz(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public static Object getBean(String string) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        return Grapes.getClazz(string).newInstance();
    }

    public static String uuid(boolean bl) {
        String string = UUID.randomUUID().toString();
        if (bl) {
            return string;
        }
        return String.valueOf(string.substring(0, 8)) + string.substring(9, 13) + string.substring(14, 18) + string.substring(19, 23) + string.substring(24);
    }

    public static String uuid() {
        return Grapes.uuid(false);
    }

    public static String regex(String string, Object object) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(object)) {
            return null;
        }
        if (object instanceof String) {
            if (Pattern.matches(object.toString(), string)) {
                return object.toString();
            }
        } else if (object instanceof Collection) {
            for (Object e : (Collection)object) {
                if (!Pattern.matches(e.toString(), string)) continue;
                return e.toString();
            }
        } else {
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray[n2];
                if (Pattern.matches(object2.toString(), string)) {
                    return object2.toString();
                }
                ++n2;
            }
        }
        return null;
    }

    public static List<String> regex(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return null;
        }
        Matcher matcher = Pattern.compile(string2).matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group());
        }
        return arrayList;
    }

    public static Map<String, Integer> regexId(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return null;
        }
        Matcher matcher = Pattern.compile(string2).matcher(string);
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        int n = 0;
        while (matcher.find()) {
            hashMap.put(matcher.group(), n);
            ++n;
        }
        return hashMap;
    }

    public static String random(String string, int n) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        int n2 = string.length();
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(string.charAt(random.nextInt(n2)));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String random(int n, boolean bl) {
        String string = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        int n2 = bl ? 36 : 10;
        Random random = new Random();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n) {
            stringBuffer.append(string.charAt(random.nextInt(n2)));
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String random(int n) {
        return Grapes.random(n, false);
    }

    public static int rand(int n, int n2) {
        Random random = new Random();
        if (n < n2) {
            return random.nextInt(n2 - n + 1) + n;
        }
        return n;
    }

    public static int rand(int n) {
        return Grapes.rand(0, n);
    }

    public static Object[] randArrayId(Object object, int n) {
        Set set;
        Object object2;
        if (Grapes.isEmpty(object)) {
            return new Object[0];
        }
        n = n <= 0 ? 1 : n;
        int n2 = 0;
        Object[] objectArray = null;
        if (object instanceof Object[]) {
            objectArray = (Object[])object;
            n2 = objectArray.length;
            if (n == 1) {
                return new Integer[]{Grapes.rand(0, n2 - 1)};
            }
            if (n2 <= n) {
                Object[] objectArray2 = new Integer[n2];
                int n3 = 0;
                while (n3 < n2) {
                    objectArray2[n3] = n3;
                    ++n3;
                }
                return objectArray2;
            }
        } else if (object instanceof Collection) {
            object2 = (Collection)object;
            n2 = object2.size();
            if (n == 1) {
                return new Integer[]{Grapes.rand(0, n2 - 1)};
            }
            if (n2 <= n) {
                Object[] objectArray3 = new Integer[n2];
                int n4 = 0;
                while (n4 < n2) {
                    objectArray3[n4] = n4;
                    ++n4;
                }
                return objectArray3;
            }
        } else if (object instanceof Map) {
            object2 = (Map)object;
            set = object2.keySet();
            n2 = set.size();
            objectArray = set.toArray();
            if (n == 1) {
                return new Object[]{objectArray[Grapes.rand(0, n2 - 1)]};
            }
            if (n2 <= n) {
                return objectArray;
            }
        } else {
            return new Object[0];
        }
        int n5 = 0;
        set = new HashSet();
        while (n5 < n) {
            set.add(Grapes.rand(0, n2 - 1));
            n5 = set.size();
        }
        if (object instanceof Object[] || object instanceof Collection) {
            return set.toArray(new Integer[n]);
        }
        Object[] objectArray4 = new Object[n];
        int n6 = 0;
        for (Integer n7 : set) {
            objectArray4[n6] = objectArray[n7];
            ++n6;
        }
        return objectArray4;
    }

    public static Object randArray(Object object, int n) {
        Map map;
        if (Grapes.isEmpty(object)) {
            return object;
        }
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            if (objectArray.length > n) {
                Object[] objectArray2 = new Object[n];
                if (n > 1) {
                    Integer[] integerArray = (Integer[])Grapes.randArrayId(objectArray, n);
                    int n2 = 0;
                    while (n2 < n) {
                        objectArray2[n2] = objectArray[integerArray[n2]];
                        ++n2;
                    }
                } else {
                    Integer[] integerArray = (Integer[])Grapes.randArrayId(objectArray, 1);
                    objectArray2[0] = objectArray[integerArray[0]];
                }
                return objectArray2;
            }
        } else if (object instanceof List) {
            List list = (List)object;
            if (list.size() > n) {
                try {
                    ArrayList arrayList = new ArrayList();
                    if (n > 1) {
                        Integer[] integerArray;
                        Integer[] integerArray2 = integerArray = (Integer[])Grapes.randArrayId(list, n);
                        int n3 = integerArray.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Integer n5 = integerArray2[n4];
                            arrayList.add(list.get(n5));
                            ++n4;
                        }
                    } else {
                        Integer[] integerArray = (Integer[])Grapes.randArrayId(list, 1);
                        arrayList.add(list.get(integerArray[0]));
                    }
                    return arrayList;
                }
                catch (Exception exception) {
                    System.err.println(exception);
                }
            }
        } else if (object instanceof Map && (map = (Map)object).size() > n) {
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            if (n > 1) {
                Object[] objectArray;
                Object[] objectArray3 = objectArray = Grapes.randArrayId(map, n);
                int n6 = objectArray.length;
                int n7 = 0;
                while (n7 < n6) {
                    Object object2 = objectArray3[n7];
                    linkedHashMap.put(object2, map.get(object2));
                    ++n7;
                }
            } else {
                Object[] objectArray = Grapes.randArrayId(map, 1);
                linkedHashMap.put(objectArray[0], map.get(objectArray[0]));
            }
            return linkedHashMap;
        }
        return object;
    }

    public static List<Object> randList(List<Object> list, int n) {
        int n2;
        int n3 = n2 = list == null ? 0 : list.size();
        if (n > 0 && n <= n2) {
            ArrayList<Object> arrayList = new ArrayList<Object>(n);
            int n4 = 0;
            while (n4 < n) {
                int n5 = Grapes.rand(n2 - 1);
                if (arrayList.indexOf(n5) == -1) {
                    arrayList.add(list.get(n5));
                } else {
                    --n4;
                }
                ++n4;
            }
            return arrayList;
        }
        return null;
    }

    public static int inArray(Object stringArray, String string, boolean bl) {
        block7: {
            int n;
            block6: {
                if (Grapes.isEmpty(stringArray) || Grapes.isEmpty(string)) {
                    return -1;
                }
                n = 0;
                if (stringArray instanceof String) {
                    stringArray = Grapes.split((String)stringArray);
                }
                if (!(stringArray instanceof String[])) break block6;
                String[] stringArray2 = stringArray;
                n = stringArray2.length;
                int n2 = 0;
                while (n2 < n) {
                    if (bl ? string.equals(stringArray2[n2]) : string.equalsIgnoreCase(stringArray2[n2])) {
                        return n2;
                    }
                    ++n2;
                }
                break block7;
            }
            if (!(stringArray instanceof List)) break block7;
            List list = (List)stringArray;
            n = list.size();
            int n3 = 0;
            while (n3 < n) {
                if (bl ? string.equals(list.get(n3)) : string.equalsIgnoreCase((String)list.get(n3))) {
                    return n3;
                }
                ++n3;
            }
        }
        return -1;
    }

    public static int inArray(Object object, String string) {
        return Grapes.inArray(object, string, true);
    }

    public static Map<String, Object> mapStart(Map<String, Object> map, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            if (map != null) {
                for (String string3 : map.keySet()) {
                    if (bl) {
                        if (!string3.startsWith(string)) continue;
                        if (string2 != null) {
                            hashMap.put(String.valueOf(string2) + Grapes.substringAfter(string3, string, false), map.get(string3));
                            continue;
                        }
                        hashMap.put(string3, map.get(string3));
                        continue;
                    }
                    if (!Grapes.startsWithIgnoreCase(string3, string)) continue;
                    if (string2 != null) {
                        hashMap.put(String.valueOf(string2) + Grapes.substringAfter(string3, string, false), map.get(string3));
                        continue;
                    }
                    hashMap.put(string3, map.get(string3));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return hashMap;
    }

    public static Map<String, Object> mapStart(Map<String, Object> map, String string, String string2) {
        return Grapes.mapStart(map, string, string2, false);
    }

    public static Map<String, Object> mapStart(Map<String, Object> map, String string) {
        return Grapes.mapStart(map, string, null, false);
    }

    public static Map<String, Object> mapEnd(Map<String, Object> map, String string, String string2, boolean bl) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            if (map != null) {
                for (String string3 : map.keySet()) {
                    if (bl) {
                        if (!string3.endsWith(string)) continue;
                        if (string2 != null) {
                            hashMap.put(String.valueOf(Grapes.substringBefore(string3, string, false)) + string2, map.get(string3));
                            continue;
                        }
                        hashMap.put(string3, map.get(string3));
                        continue;
                    }
                    if (!Grapes.endsWithIgnoreCase(string3, string)) continue;
                    if (string2 != null) {
                        hashMap.put(String.valueOf(Grapes.substringBefore(string3, string, false)) + string2, map.get(string3));
                        continue;
                    }
                    hashMap.put(string3, map.get(string3));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return hashMap;
    }

    public static Map<String, Object> mapEnd(Map<String, Object> map, String string, String string2) {
        return Grapes.mapEnd(map, string, string2, false);
    }

    public static Map<String, Object> mapEnd(Map<String, Object> map, String string) {
        return Grapes.mapEnd(map, string, null, false);
    }

    public static Properties properStart(Properties properties, String string, String string2, boolean bl) {
        Properties properties2 = new Properties();
        try {
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (bl) {
                        if (!string3.startsWith(string)) continue;
                        if (string2 != null) {
                            properties2.put(String.valueOf(string2) + Grapes.substringAfter(string3, string, false), properties.getProperty(string3));
                            continue;
                        }
                        properties2.put(string3, properties.getProperty(string3));
                        continue;
                    }
                    if (!Grapes.startsWithIgnoreCase(string3, string)) continue;
                    if (string2 != null) {
                        properties2.put(String.valueOf(string2) + Grapes.substringAfter(string3, string, false), properties.getProperty(string3));
                        continue;
                    }
                    properties2.put(string3, properties.getProperty(string3));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return properties2;
    }

    public static Properties properStart(Properties properties, String string, String string2) {
        return Grapes.properStart(properties, string, string2, false);
    }

    public static Properties properStart(Properties properties, String string) {
        return Grapes.properStart(properties, string, null, false);
    }

    public static Properties properEnd(Properties properties, String string, String string2, boolean bl) {
        Properties properties2 = new Properties();
        try {
            if (properties != null) {
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string3 = (String)enumeration.nextElement();
                    if (bl) {
                        if (!string3.endsWith(string)) continue;
                        if (string2 != null) {
                            properties2.put(String.valueOf(Grapes.substringBefore(string3, string, false)) + string2, properties.getProperty(string3));
                            continue;
                        }
                        properties2.put(string3, properties.getProperty(string3));
                        continue;
                    }
                    if (!Grapes.endsWithIgnoreCase(string3, string)) continue;
                    if (string2 != null) {
                        properties2.put(String.valueOf(Grapes.substringBefore(string3, string, false)) + string2, properties.getProperty(string3));
                        continue;
                    }
                    properties2.put(string3, properties.getProperty(string3));
                }
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return properties2;
    }

    public static Properties properEnd(Properties properties, String string, String string2) {
        return Grapes.properEnd(properties, string, string2, false);
    }

    public static Properties properEnd(Properties properties, String string) {
        return Grapes.properEnd(properties, string, null, false);
    }

    public static String chinese(String string, String string2) {
        String string3 = null;
        if (Grapes.isNotEmpty(string)) {
            Pattern pattern = Pattern.compile("[\\u4e00-\\u9fa5]");
            Matcher matcher = pattern.matcher(string);
            while (matcher.find()) {
                string3 = String.valueOf(string3) + (string3 == null ? matcher.group(0) : String.valueOf(string2) + matcher.group(0));
            }
        }
        return string3;
    }

    public static int bytes(String string, String string2) {
        if (Grapes.isEmpty(string)) {
            return 0;
        }
        if (Grapes.isEmpty(string2)) {
            string2 = CHARSET;
        }
        int n = 0;
        try {
            n = string.getBytes(string2).length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
        }
        return n;
    }

    public static int bytes(String string) {
        return Grapes.bytes(string, CHARSET);
    }

    public static int length(String string) {
        if (Grapes.isEmpty(string)) {
            return 0;
        }
        return Grapes.bytes(string, "GBK");
    }

    public static Map<String, Integer> getWordCount(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl = false;
        int n4 = 0;
        while (n4 < string.length()) {
            char c = string.charAt(n4);
            if (Character.isSpaceChar(c)) {
                if (bl) {
                    ++n2;
                    bl = false;
                }
            } else if (c >= '\u4e00' && c <= '\ufa29') {
                ++n;
            } else if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                bl = true;
            } else {
                ++n3;
            }
            ++n4;
        }
        if (bl) {
            ++n2;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("cn", n);
        hashMap.put("en", n2);
        hashMap.put("cha", n3);
        return hashMap;
    }

    public static boolean getBoolean(Object object) {
        if (Grapes.isEmpty(object)) {
            return false;
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Integer) {
            return (Integer)object > 0;
        }
        if (object instanceof String) {
            String string = (String)object;
            if (string.equalsIgnoreCase("1") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("on") || string.equalsIgnoreCase("yes")) {
                return true;
            }
            if (string.equalsIgnoreCase("0") || string.equalsIgnoreCase("false") || string.equalsIgnoreCase("off") || string.equalsIgnoreCase("no")) {
                return false;
            }
        }
        return false;
    }

    public static String getNumber(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        Pattern pattern = Pattern.compile("\\d+");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return matcher.group(0);
        }
        return null;
    }

    public static String getNumberLeft(String string) {
        Pattern pattern = Pattern.compile("[0-9]");
        Matcher matcher = pattern.matcher(string);
        if (matcher.find()) {
            return string.substring(0, string.indexOf(matcher.group()));
        }
        return string;
    }

    public static String getPercnet(Long l, Long l2, int n) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(n);
        float f = (float)l.longValue() / (float)l2.longValue();
        return numberFormat.format(f);
    }

    public static String getPercnet(Long l, Long l2) {
        return Grapes.getPercnet(l, l2, 0);
    }

    public static String trim(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        return string.trim();
    }

    public static String unZero(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
            return String.valueOf(n);
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String swapCase(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        char c = '\u0000';
        int n2 = 0;
        while (n2 < n) {
            c = string.charAt(n2);
            if (Character.isUpperCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isTitleCase(c)) {
                c = Character.toLowerCase(c);
            } else if (Character.isLowerCase(c)) {
                c = Character.toUpperCase(c);
            }
            stringBuffer.append(c);
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static String capitalize(String string) {
        int n = string.length();
        if (Grapes.isEmpty(string)) {
            return string;
        }
        return new StringBuffer(n).append(Character.toTitleCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String uncapitalize(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        int n = string.length();
        return new StringBuffer(n).append(Character.toLowerCase(string.charAt(0))).append(string.substring(1)).toString();
    }

    public static String separator(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = Grapes.splitCase(string, true);
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(Grapes.isEmpty(stringBuffer.toString()) ? Grapes.uncapitalize(stringArray[n]) : String.valueOf(string2) + Grapes.uncapitalize(stringArray[n]));
            ++n;
        }
        return stringBuffer.toString().toLowerCase();
    }

    public static String unseparator(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        String[] stringArray = Grapes.split(string.trim(), string2);
        StringBuffer stringBuffer = new StringBuffer(Grapes.uncapitalize(stringArray[0]));
        int n = 1;
        while (n < stringArray.length) {
            stringBuffer.append(Grapes.capitalize(stringArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String[] splitCase(String string, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        String[] stringArray = null;
        stringArray = bl ? Grapes.splitRegex(string, "(?<!^)(?=[A-Z])") : Grapes.splitRegex(string, "(?<!^)(?=[a-z])");
        return stringArray;
    }

    public static String[] splitRegex(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return null;
        }
        String[] stringArray = string.split(string2);
        return stringArray;
    }

    public static String[] split(String string, String string2, int n) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return null;
        }
        string = Grapes.substringCenter(string, string2);
        String[] stringArray = string.split(string2);
        if (n == 0 || n >= stringArray.length) {
            return stringArray;
        }
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string3 = stringArray2[n4];
            if (n2 > n) break;
            arrayList.add(string3.toString());
            ++n2;
            ++n4;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String[] split(String string, String string2) {
        return Grapes.split(string, string2, 0);
    }

    public static String[] split(String string, int n) {
        return Grapes.split(string, ",", n);
    }

    public static String[] split(String string) {
        return Grapes.split(string, ",", 0);
    }

    public static String unsplit(Object object, String string, int n) {
        if (Grapes.isEmpty(object)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Object[]) {
            boolean bl = false;
            Object[] objectArray = (Object[])object;
            int n2 = 0;
            int n3 = 0;
            if (n == 0) {
                n2 = objectArray.length;
            }
            if (n >= objectArray.length) {
                n2 = objectArray.length;
            }
            Object[] objectArray2 = objectArray;
            int n4 = objectArray.length;
            int n5 = 0;
            while (n5 < n4) {
                Object object2 = objectArray2[n5];
                if (n3 <= n2) {
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Grapes.unsplit(object2, string, n));
                    ++n3;
                    ++n5;
                    continue;
                }
                break;
            }
        } else if (object instanceof Map) {
            boolean bl = false;
            Map map = (Map)object;
            Set set = map.keySet();
            int n6 = 0;
            int n7 = 0;
            if (n == 0) {
                n6 = set.size();
            }
            if (n >= set.size()) {
                n6 = set.size();
            }
            for (Object k : set) {
                if (n7 <= n6) {
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Grapes.unsplit(map.get(k), string, n));
                    ++n7;
                    continue;
                }
                break;
            }
        } else if (object instanceof Collection) {
            boolean bl = false;
            Collection collection = (Collection)object;
            int n8 = 0;
            int n9 = 0;
            if (n == 0) {
                n8 = collection.size();
            }
            if (n >= collection.size()) {
                n8 = collection.size();
            }
            for (Object e : collection) {
                if (n9 <= n8) {
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(Grapes.unsplit(e, string, n));
                    ++n9;
                    continue;
                }
                break;
            }
        } else {
            return object.toString();
        }
        return stringBuffer.toString();
    }

    public static String unsplit(Object object, String string) {
        return Grapes.unsplit(object, string, 0);
    }

    public static String unsplit(Object object, int n) {
        return Grapes.unsplit(object, ",", n);
    }

    public static String unsplit(Object object) {
        return Grapes.unsplit(object, ",", 0);
    }

    public static String join(Object object, String string) {
        if (Grapes.isEmpty(object)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Object[]) {
            Object[] objectArray;
            boolean bl = false;
            Object[] objectArray2 = objectArray = (Object[])object;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object2 = objectArray2[n2];
                if (!Grapes.isEmpty(object2)) {
                    if (bl) {
                        stringBuffer.append(string);
                    } else {
                        bl = true;
                    }
                    stringBuffer.append(object2.toString());
                }
                ++n2;
            }
        } else if (object instanceof Map) {
            boolean bl = false;
            Map map = (Map)object;
            Set set = map.keySet();
            for (Object k : set) {
                if (Grapes.isEmpty(map.get(k))) continue;
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(String.valueOf(k.toString()) + "=" + map.get(k).toString());
            }
        } else if (object instanceof Collection) {
            boolean bl = false;
            Collection collection = (Collection)object;
            for (Object e : collection) {
                if (Grapes.isEmpty(e)) continue;
                if (bl) {
                    stringBuffer.append(string);
                } else {
                    bl = true;
                }
                stringBuffer.append(e.toString());
            }
        } else {
            return object.toString();
        }
        return stringBuffer.toString();
    }

    public static String join(Object object) {
        return Grapes.join(object, ",");
    }

    public static List<String> splitList(String string, String string2, int n) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return null;
        }
        string = Grapes.substringCenter(string.toString(), string2);
        String[] stringArray = string.split(string2);
        if (n == 0 || n >= stringArray.length) {
            n = stringArray.length;
        }
        int n2 = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        String[] stringArray2 = stringArray;
        int n3 = stringArray.length;
        int n4 = 0;
        while (n4 < n3) {
            String string3 = stringArray2[n4];
            if (n2 > n) break;
            arrayList.add(string3.toString());
            ++n2;
            ++n4;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static List<String> splitList(String string, String string2) {
        return Grapes.splitList(string, string2, 0);
    }

    public static List<String> splitList(String string, int n) {
        return Grapes.splitList(string, ",", n);
    }

    public static List<String> splitList(String string) {
        return Grapes.splitList(string, ",", 0);
    }

    public static List<String> splitLength(String string, int n) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = string.length();
        if (n2 <= n) {
            arrayList.add(string);
        } else {
            int n3 = n2 / n;
            int n4 = 0;
            while (n4 < n3) {
                arrayList.add(string.substring(n4 * n, (n4 + 1) * n));
                ++n4;
            }
            if (n3 * n < n2) {
                arrayList.add(string.substring(n3 * n));
            }
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList;
    }

    public static String repeat(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            stringBuffer.append(string);
            --n2;
        }
        return stringBuffer.toString();
    }

    public static String expand(String string, int n, String string2, boolean bl) {
        if ((n -= string.length()) > 0) {
            if (bl) {
                return string.concat(Grapes.repeat(string2, n));
            }
            return Grapes.repeat(string2, n).concat(string);
        }
        return string;
    }

    public static String expand(String string, int n, String string2) {
        return Grapes.expand(string, n, string2, true);
    }

    public static String reverse(String string) {
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = n - 1;
        while (n2 >= 0) {
            stringBuffer.append(string.charAt(n2));
            --n2;
        }
        return stringBuffer.toString();
    }

    public static Object[] reverse(Object[] objectArray) {
        int n = objectArray.length;
        Object object = null;
        int n2 = 0;
        while (n2 < n / 2) {
            object = objectArray[n2];
            objectArray[n2] = objectArray[n - 1 - n2];
            objectArray[n - 1 - n2] = object;
            ++n2;
        }
        return objectArray;
    }

    public static int indexOf(String string, char c) {
        if (Grapes.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c);
    }

    public static int indexOf(String string, char c, int n) {
        if (Grapes.isEmpty(string)) {
            return -1;
        }
        return string.indexOf(c, n);
    }

    public static int indexOf(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        return string.indexOf(string2);
    }

    public static int ordinalIndexOf(String string, String string2, int n) {
        return Grapes.ordinalIndexOf(string, string2, n, false);
    }

    public static int ordinalIndexOf(String string, String string2, int n, boolean bl) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2) || n <= 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return bl ? string.length() : 0;
        }
        int n2 = 0;
        int n3 = bl ? string.length() : -1;
        do {
            if ((n3 = bl ? string.lastIndexOf(string2, n3 - 1) : string.indexOf(string2, n3 + 1)) >= 0) continue;
            return n3;
        } while (++n2 < n);
        return n3;
    }

    public static int indexOf(String string, String string2, int n) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        if (string2.length() == 0 && n >= string.length()) {
            return string.length();
        }
        return string.indexOf(string2, n);
    }

    public static int indexOfIgnoreCase(String string, String string2) {
        return Grapes.indexOfIgnoreCase(string, string2, 0);
    }

    public static int indexOfIgnoreCase(String string, String string2, int n) {
        int n2;
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        if (n < 0) {
            n = 0;
        }
        if (n > (n2 = string.length() - string2.length() + 1)) {
            return -1;
        }
        if (string2.length() == 0) {
            return n;
        }
        int n3 = n;
        while (n3 < n2) {
            if (string.regionMatches(true, n3, string2, 0, string2.length())) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    public static int lastIndexOf(String string, char c) {
        if (Grapes.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c);
    }

    public static int lastIndexOf(String string, char c, int n) {
        if (Grapes.isEmpty(string)) {
            return -1;
        }
        return string.lastIndexOf(c, n);
    }

    public static int lastIndexOf(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        return string.lastIndexOf(string2);
    }

    public static int lastOrdinalIndexOf(String string, String string2, int n) {
        return Grapes.ordinalIndexOf(string, string2, n, true);
    }

    public static int lastIndexOf(String string, String string2, int n) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        return string.lastIndexOf(string2, n);
    }

    public static int lastIndexOfIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        return Grapes.lastIndexOfIgnoreCase(string, string2, string.length());
    }

    public static int lastIndexOfIgnoreCase(String string, String string2, int n) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return -1;
        }
        if (n > string.length() - string2.length()) {
            n = string.length() - string2.length();
        }
        if (n < 0) {
            return -1;
        }
        if (string2.length() == 0) {
            return n;
        }
        int n2 = n;
        while (n2 >= 0) {
            if (string.regionMatches(true, n2, string2, 0, string2.length())) {
                return n2;
            }
            --n2;
        }
        return -1;
    }

    public static boolean contains(String string, char c) {
        if (Grapes.isEmpty(string)) {
            return false;
        }
        return string.indexOf(c) >= 0;
    }

    public static boolean contains(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return false;
        }
        return string.indexOf(string2) >= 0;
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return false;
        }
        int n = string2.length();
        int n2 = string.length() - n;
        int n3 = 0;
        while (n3 <= n2) {
            if (string.regionMatches(true, n3, string2, 0, n)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean contains(String[] stringArray, String string) {
        if (Grapes.isEmpty(stringArray) || Grapes.isEmpty(string)) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equals(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String[] stringArray, String string) {
        if (Grapes.isEmpty(stringArray) || Grapes.isEmpty(string)) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (string.equalsIgnoreCase(stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean contains(String string, String[] stringArray) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(stringArray)) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (Grapes.contains(string, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static boolean containsIgnoreCase(String string, String[] stringArray) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(stringArray)) {
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (Grapes.containsIgnoreCase(string, stringArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public static String contains(String string, String[] stringArray, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(stringArray)) {
            return string2;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (Grapes.contains(string, stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return string2;
    }

    public static String containsIgnoreCase(String string, String[] stringArray, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(stringArray)) {
            return string2;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (Grapes.containsIgnoreCase(string, stringArray[n])) {
                return stringArray[n];
            }
            ++n;
        }
        return string2;
    }

    public static boolean startsWithIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return false;
        }
        if (string.startsWith(string2)) {
            return true;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        return string.substring(0, string2.length()).equalsIgnoreCase(string2);
    }

    public static boolean endsWithIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return false;
        }
        if (string.endsWith(string2)) {
            return true;
        }
        if (string.length() < string2.length()) {
            return false;
        }
        return string.substring(string.length() - string2.length()).equalsIgnoreCase(string2);
    }

    public static String addStart(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (!string.startsWith(string2)) {
            return String.valueOf(string2) + string;
        }
        return string;
    }

    public static String addStartIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (!Grapes.startsWithIgnoreCase(string, string2)) {
            return String.valueOf(string2) + string;
        }
        return string;
    }

    public static String addEnd(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (!string.endsWith(string2)) {
            return String.valueOf(string) + string2;
        }
        return string;
    }

    public static String addEndIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (!Grapes.endsWithIgnoreCase(string, string2)) {
            return String.valueOf(string) + string2;
        }
        return string;
    }

    public static String addParam(String string, String string2, String string3) {
        string = Grapes.containsIgnoreCase(string, string2) ? String.valueOf(string) + string3 : String.valueOf(string) + string2;
        return string;
    }

    public static String removeStart(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (string.startsWith(string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeStartIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (Grapes.startsWithIgnoreCase(string, string2)) {
            return string.substring(string2.length());
        }
        return string;
    }

    public static String removeEnd(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (string.endsWith(string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String removeEndIgnoreCase(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2)) {
            return string;
        }
        if (Grapes.endsWithIgnoreCase(string, string2)) {
            return string.substring(0, string.length() - string2.length());
        }
        return string;
    }

    public static String remove(String string, String string2) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2) || string.indexOf(string2) == -1) {
            return string;
        }
        return string.replaceAll(string2, "");
    }

    public static String remove(String string, char c) {
        if (Grapes.isEmpty(string) || string.indexOf(c) == -1) {
            return string;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        while (n2 < cArray.length) {
            if (cArray[n2] != c) {
                cArray[n++] = cArray[n2];
            }
            ++n2;
        }
        return new String(cArray, 0, n);
    }

    public static String substring(String string, int n, int n2, String string2, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 == null) {
            string2 = "";
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        int n3 = string.length();
        int n4 = string2.length();
        try {
            n3 = string.getBytes("GBK").length;
            n4 = string2.getBytes("GBK").length;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getMessage());
        }
        if (n2 >= n3 - n || n2 < 1) {
            return string;
        }
        if (n2 - n4 > 0) {
            n2 -= n4;
        }
        int n5 = n2;
        StringBuffer stringBuffer = new StringBuffer();
        int n6 = 0;
        while (n6 < n2 && n5 > 0) {
            n5 = Grapes.isDoubleByte("" + string.charAt(n + n6)) ? (bl ? (n5 -= 2) : --n5) : --n5;
            stringBuffer.append(string.charAt(n + n6));
            ++n6;
        }
        return String.valueOf(stringBuffer.toString()) + string2;
    }

    public static String substring(String string, int n, String string2, boolean bl) {
        return Grapes.substring(string, 0, n, string2, bl);
    }

    public static String substring(String string, int n, int n2, String string2) {
        return Grapes.substring(string, n, n2, string2, true);
    }

    public static String substring(String string, int n, String string2) {
        return Grapes.substring(string, 0, n, string2, true);
    }

    public static String substring(String string, int n, int n2) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n2 < 0 || n2 > string.length()) {
            n2 = string.length();
        }
        if (n > n2) {
            return null;
        }
        return string.substring(n, n2);
    }

    public static String substring(String string, int n) {
        return Grapes.substring(string, n, string.length());
    }

    public static String substringLeft(String string, int n) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (n < 0) {
            n = string.length();
        }
        if (n >= string.length()) {
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringRight(String string, int n) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (n < 0) {
            return null;
        }
        if (n >= string.length()) {
            return string;
        }
        return string.substring(string.length() - n);
    }

    public static String substringMid(String string, int n, int n2) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (n2 < 0 || n > string.length()) {
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        if (n + n2 >= string.length()) {
            return string.substring(n);
        }
        return string.substring(n, n + n2);
    }

    public static String substringCenter(String string, String string2, String string3) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 != null && string.startsWith(string2)) {
            string = Grapes.substring(string, string2.length());
        }
        if (string3 != null && string.endsWith(string3)) {
            string = Grapes.substring(string, 0, string.length() - string3.length());
        }
        return string;
    }

    public static String substringCenter(String string, String string2) {
        return Grapes.substringCenter(string, string2, string2);
    }

    public static String substringBefore(String string, String string2, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            if (bl) {
                return null;
            }
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringBefore(String string, String string2) {
        return Grapes.substringBefore(string, string2, true);
    }

    public static String substringAfter(String string, String string2, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf(string2);
        if (n == -1) {
            if (bl) {
                return null;
            }
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String substringAfter(String string, String string2) {
        return Grapes.substringAfter(string, string2, true);
    }

    public static String substringBeforeLast(String string, String string2, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1) {
            if (bl) {
                return null;
            }
            return string;
        }
        return string.substring(0, n);
    }

    public static String substringBeforeLast(String string, String string2) {
        return Grapes.substringBeforeLast(string, string2, true);
    }

    public static String substringAfterLast(String string, String string2, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (string2 == null) {
            return string;
        }
        int n = string.lastIndexOf(string2);
        if (n == -1 || n == string.length() - string2.length()) {
            if (bl) {
                return null;
            }
            return string;
        }
        return string.substring(n + string2.length());
    }

    public static String substringAfterLast(String string, String string2) {
        return Grapes.substringAfterLast(string, string2, true);
    }

    public static String substringBetween(String string, String string2) {
        return Grapes.substringBetween(string, string2, string2);
    }

    public static String substringBetween(String string, String string2, String string3) {
        int n;
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2) || Grapes.isEmpty(string3)) {
            return null;
        }
        int n2 = string.indexOf(string2);
        if (n2 != -1 && (n = string.indexOf(string3, n2 + string2.length())) != -1) {
            return string.substring(n2 + string2.length(), n);
        }
        return null;
    }

    public static String[] substringsBetween(String string, String string2, String string3) {
        if (Grapes.isEmpty(string) || Grapes.isEmpty(string2) || Grapes.isEmpty(string3)) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return null;
        }
        int n2 = string3.length();
        int n3 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n4 = 0;
        while (n4 < n - n2) {
            int n5;
            int n6 = string.indexOf(string2, n4);
            if (n6 < 0 || (n5 = string.indexOf(string3, n6 += n3)) < 0) break;
            arrayList.add(string.substring(n6, n5));
            n4 = n5 + n2;
        }
        if (arrayList.isEmpty()) {
            return null;
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static String replace(String string, String string2, String string3) {
        int n;
        if (Grapes.isEmpty(string)) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        int n3 = string2.length();
        int n4 = 0;
        while ((n = string.indexOf(string2, n4)) >= 0) {
            stringBuffer.append(string.substring(n4, n));
            stringBuffer.append(string3);
            n4 = n + n3;
        }
        if (n4 < n2) {
            stringBuffer.append(string.substring(n4));
        }
        return stringBuffer.toString();
    }

    public static String replaceRange(String string, String string2, String string3, int n, boolean bl) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        String[] stringArray = Grapes.split(string, string2);
        string = "";
        string2 = string2.replaceAll("\\\\", "");
        if (!bl) {
            n = stringArray.length - n;
        }
        if (n < 0) {
            n = 0;
        }
        int n2 = 0;
        while (n2 < stringArray.length) {
            string = !bl ? (n2 < n ? String.valueOf(string) + (string == "" ? stringArray[n2] : String.valueOf(string2) + stringArray[n2]) : String.valueOf(string) + (string == "" ? string3 : String.valueOf(string2) + string3)) : (n2 > n - 1 ? String.valueOf(string) + (string == "" ? stringArray[n2] : String.valueOf(string2) + stringArray[n2]) : String.valueOf(string) + (string == "" ? string3 : String.valueOf(string2) + string3));
            ++n2;
        }
        return string;
    }

    public static String replaceChar(String string, char c, int n, int n2) {
        if (Grapes.isEmpty(string) || string.length() < n || string.length() < n2) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        int n3 = n;
        while (n3 < string.length() - n2) {
            stringBuilder.setCharAt(n3, c);
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static String replaceCharLeft(String string, char c, int n) {
        return Grapes.replaceChar(string, c, n, 0);
    }

    public static String replaceCharRight(String string, char c, int n) {
        return Grapes.replaceChar(string, c, 0, n);
    }

    public static String replaceCharCenter(String string, char c, int n) {
        return Grapes.replaceChar(string, c, n, n);
    }

    public static String charset(String string, String string2, String string3) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        string2 = Grapes.isEmpty(string2) ? "ISO-8859-1" : string3;
        string3 = Grapes.isEmpty(string3) ? CHARSET : string3;
        try {
            string = new String(string.getBytes(string2), string3);
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
        return string;
    }

    public static String charset(String string, String string2) {
        return Grapes.charset(string, null, string2);
    }

    public static String charset(String string) {
        return Grapes.charset(string, null, null);
    }

    public static List<String> enumArray(Enumeration<?> enumeration) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Grapes.isNotEmpty(enumeration)) {
            while (enumeration.hasMoreElements()) {
                Object obj = enumeration.nextElement();
                arrayList.add((String)obj);
            }
        }
        return arrayList;
    }

    public static String telex(String string, String string2, String string3) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string3)) {
            string3 = ",";
        }
        char[] cArray = string.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < cArray.length) {
            stringBuffer.append(Grapes.isEmpty(stringBuffer.toString()) ? Integer.valueOf(string2.indexOf(cArray[n])) : String.valueOf(string3) + string2.indexOf(cArray[n]));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String telex(String string, String string2) {
        return Grapes.telex(string, string2, null);
    }

    public static String telex(String string) {
        return Grapes.telex(string, super);
    }

    public static String untelex(String string, String string2, String string3) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string3)) {
            string3 = ",";
        }
        String[] stringArray = Grapes.split(string, string3);
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < stringArray.length) {
            stringBuffer.append(string2.charAt(Integer.parseInt(stringArray[n])));
            ++n;
        }
        return stringBuffer.toString();
    }

    public static String untelex(String string, String string2) {
        return Grapes.untelex(string, string2, null);
    }

    public static String untelex(String string) {
        return Grapes.untelex(string, super);
    }

    public static String html(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        string = string.replaceAll("&lt;", "<");
        string = string.replaceAll("&gt;", ">");
        string = string.replaceAll("&ldquo;", "\u201c");
        string = string.replaceAll("&rdquo;", "\u201d");
        string = string.replaceAll("&quot;", "\"");
        string = string.replaceAll("&amp;", "&");
        return string;
    }

    public static String unhtml(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        string = string.replaceAll("&", "&amp;");
        string = string.replaceAll("\"", "&quot;");
        string = string.replaceAll("\u201d", "&rdquo;");
        string = string.replaceAll("\u201c", "&ldquo;");
        string = string.replaceAll(">", "&gt;");
        string = string.replaceAll("<", "&lt;");
        return string;
    }

    public static String ascii(String string, String string2) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string2)) {
            string2 = ";";
        }
        try {
            char[] cArray;
            StringBuffer stringBuffer = new StringBuffer();
            char[] cArray2 = cArray = string.toCharArray();
            int n = cArray.length;
            int n2 = 0;
            while (n2 < n) {
                char c = cArray2[n2];
                stringBuffer.append(Grapes.isEmpty(stringBuffer.toString()) ? Integer.valueOf(c) : String.valueOf(string2) + c);
                ++n2;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String ascii(String string) {
        return Grapes.ascii(string, null);
    }

    public static String unascii(String string, String string2) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string2)) {
            string2 = ";";
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = Grapes.split(string, string2);
            int n = 0;
            while (n < stringArray.length) {
                stringBuffer.append((char)Integer.parseInt(stringArray[n]));
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            return string;
        }
    }

    public static String unascii(String string) {
        return Grapes.unascii(string, null);
    }

    public static String byte2Hex(byte[] byArray, String string) {
        if (Grapes.isEmpty(byArray)) {
            return null;
        }
        if (Grapes.isEmpty(string)) {
            string = ":";
        }
        try {
            String string2 = "";
            String string3 = "";
            int n = 0;
            while (n < byArray.length) {
                string3 = Integer.toHexString(byArray[n] & 0xFF);
                string2 = string3.length() == 1 ? String.valueOf(string2) + "0" + string3 : String.valueOf(string2) + string3;
                if (n < byArray.length - 1) {
                    string2 = String.valueOf(string2) + string;
                }
                ++n;
            }
            return string2.toUpperCase();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String byte2Hex(byte[] byArray) {
        return Grapes.byte2Hex(byArray, null);
    }

    public static byte[] hex2Byte(String string, String string2) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string2)) {
            string2 = ":";
        }
        try {
            String[] stringArray = string.split(string2);
            byte[] byArray = new byte[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                byArray[n] = (byte)Integer.parseInt(stringArray[n].toLowerCase(), 16);
                ++n;
            }
            return byArray;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static byte[] hex2Byte(String string) {
        return Grapes.hex2Byte(string, null);
    }

    public static String urlEncode(String string, String string2) {
        return UTF8URL.encode(string, string2);
    }

    public static String urlEncode(String string) {
        return Grapes.urlEncode(string, null);
    }

    public static String urlDecode(String string, String string2) {
        return UTF8URL.decode(string, string2);
    }

    public static String urlDecode(String string) {
        return Grapes.urlDecode(string, null);
    }

    public static String sbc(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == ' ') {
                cArray[n] = 12288;
            } else if (cArray[n] < '\u007f') {
                cArray[n] = (char)(cArray[n] + 65248);
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String dbc(String string) {
        char[] cArray = string.toCharArray();
        int n = 0;
        while (n < cArray.length) {
            if (cArray[n] == '\u3000') {
                cArray[n] = 32;
            } else if (cArray[n] > '\uff00' && cArray[n] < '\uff5f') {
                cArray[n] = (char)(cArray[n] - 65248);
            }
            ++n;
        }
        return new String(cArray);
    }

    public static String filter(String string, String string2, String string3) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        if (Grapes.isEmpty(string2)) {
            return string;
        }
        string3 = Grapes.isEmpty(string3) ? "" : string3;
        try {
            Pattern pattern = Pattern.compile(string2, 2);
            Matcher matcher = pattern.matcher(string);
            string = matcher.replaceAll(string3);
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
        }
        return string;
    }

    public static String filter(String string, String string2) {
        return Grapes.filter(string, string2, null);
    }

    public static String nrbr(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        StringCharacterIterator stringCharacterIterator = new StringCharacterIterator(string);
        char c = stringCharacterIterator.current();
        block4: while (c != '\uffff') {
            switch (c) {
                case '\r': {
                    stringBuffer.append("<br/>");
                    stringBuffer.append(c);
                    c = stringCharacterIterator.next();
                    if (c != '\n') continue block4;
                    c = stringCharacterIterator.next();
                    break;
                }
                case '\n': {
                    stringBuffer.append("<br/>");
                    stringBuffer.append(c);
                    c = stringCharacterIterator.next();
                    if (c != '\r') continue block4;
                    stringBuffer.append(c);
                    c = stringCharacterIterator.next();
                    break;
                }
                default: {
                    stringBuffer.append(c);
                    c = stringCharacterIterator.next();
                }
            }
        }
        return stringBuffer.toString();
    }

    public static String brnr(String string) {
        if (Grapes.isEmpty(string)) {
            return string;
        }
        string = Grapes.filter(string, "<br>|<br >|<br/>|<br />", "\r\n");
        return string;
    }

    public static String text(String string, boolean bl, boolean bl2) {
        try {
            string = Grapes.filter(string, "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>");
            string = Grapes.filter(string, "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>");
            string = Grapes.filter(string, "<[^>]+>");
            if (bl) {
                string = Grapes.filter(string, "['|\"]");
            }
            string = Grapes.filter(string, "\\u3000| |null|\\&nbsp;");
            string = Grapes.filter(string, "\\s\\n");
            if (bl2) {
                string = Grapes.filter(string, "\\s*\\n");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return string;
    }

    public static String text(String string, boolean bl) {
        return Grapes.text(string, bl, false);
    }

    public static String text(String string) {
        return Grapes.text(string, false, false);
    }

    public static String javascript(String string) {
        if (Grapes.isEmpty(string)) {
            return null;
        }
        string = string.replaceAll(Pattern.quote("\\"), "\\\\\\\\").replaceAll("/", "\\\\/").replaceAll("'", "\\\\'").replaceAll("\"", "\\\\\"").replaceAll("\r", "");
        return "document.writeln(\"" + Grapes.unsplit((Object)Grapes.split(string, "\\\n"), "\");\ndocument.writeln(\"") + "\");";
    }

    public static String clearWord(String string, boolean bl) {
        try {
            string = Grapes.filter(string, "<[\\s]*?script[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?script[\\s]*?>");
            string = Grapes.filter(string, "<[\\s]*?style[^>]*?>[\\s\\S]*?<[\\s]*?\\/[\\s]*?style[\\s]*?>");
            string = Grapes.filter(string, "(<p)([^>]*)(>.*?)(<\\/p>)", "<p$3</p>");
            string = Grapes.filter(string, "<[/]?(font|span|xml|del|ins|meta|[ovwxp]:\\w+)[^>]*?>");
            string = Grapes.filter(string, "<([^>]*)(?:lang|class|style|size|face|[ovwxp]:\\w+)=(?:'[^']*'|\"\"[^\"\"]*\"\"|[^>]+)([^>]*)>", "<$1>");
            string = Grapes.filter(string, "\\s\\n");
            if (bl) {
                string = Grapes.filter(string, "\\s*\\n");
            }
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return string;
    }

    public static String clearWord(String string) {
        return Grapes.clearWord(string, false);
    }

    public static String gzip(String string) {
        ByteArrayOutputStream byteArrayOutputStream;
        block15: {
            if (Grapes.isEmpty(string)) {
                return string;
            }
            byteArrayOutputStream = new ByteArrayOutputStream();
            GZIPOutputStream gZIPOutputStream = null;
            try {
                try {
                    gZIPOutputStream = new GZIPOutputStream(byteArrayOutputStream);
                    gZIPOutputStream.write(string.getBytes());
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    if (gZIPOutputStream != null) {
                        try {
                            gZIPOutputStream.close();
                        }
                        catch (IOException iOException2) {
                            System.err.println(iOException2.getMessage());
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (gZIPOutputStream != null) {
                    try {
                        gZIPOutputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                }
                throw throwable;
            }
            if (gZIPOutputStream != null) {
                try {
                    gZIPOutputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                }
            }
        }
        return new BASE64Encoder().encode(byteArrayOutputStream.toByteArray());
    }

    public static String ungzip(String string) {
        String string2;
        block30: {
            if (Grapes.isEmpty(string)) {
                return null;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ByteArrayInputStream byteArrayInputStream = null;
            GZIPInputStream gZIPInputStream = null;
            string2 = null;
            try {
                try {
                    byte[] byArray = new BASE64Decoder().decodeBuffer(string);
                    byteArrayInputStream = new ByteArrayInputStream(byArray);
                    gZIPInputStream = new GZIPInputStream(byteArrayInputStream);
                    byte[] byArray2 = new byte[1024];
                    int n = -1;
                    while ((n = gZIPInputStream.read(byArray2)) != -1) {
                        byteArrayOutputStream.write(byArray2, 0, n);
                    }
                    string2 = byteArrayOutputStream.toString();
                }
                catch (IOException iOException) {
                    System.err.println(iOException.getMessage());
                    if (gZIPInputStream != null) {
                        try {
                            gZIPInputStream.close();
                        }
                        catch (IOException iOException2) {
                            System.err.println(iOException2.getMessage());
                        }
                    }
                    if (byteArrayInputStream != null) {
                        try {
                            byteArrayInputStream.close();
                        }
                        catch (IOException iOException3) {
                            System.err.println(iOException3.getMessage());
                        }
                    }
                    if (byteArrayOutputStream == null) break block30;
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException4) {
                        System.err.println(iOException4.getMessage());
                    }
                }
            }
            finally {
                if (gZIPInputStream != null) {
                    try {
                        gZIPInputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                }
                if (byteArrayInputStream != null) {
                    try {
                        byteArrayInputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                }
                if (byteArrayOutputStream != null) {
                    try {
                        byteArrayOutputStream.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException.getMessage());
                    }
                }
            }
        }
        return string2;
    }

    public static int[] arraySort(int[] nArray, String string) {
        if ("desc".equalsIgnoreCase(string)) {
            Grapes.new(nArray, 0, nArray.length - 1);
        } else {
            Grapes.o00000(nArray, 0, nArray.length - 1);
        }
        return nArray;
    }

    public static int[] arraySort(int[] nArray) {
        return Grapes.arraySort(nArray, "asc");
    }

    /*
     * Unable to fully structure code
     */
    private static void o00000(int[] var0, int var1_1, int var2_2) {
        block4: {
            if (var1_1 >= var2_2) break block4;
            var3_3 = var1_1;
            var4_4 = var2_2;
            var5_5 = var0[var3_3];
            ** GOTO lbl18
            {
                --var4_4;
                do {
                    if (var3_3 < var4_4 && var0[var4_4] > var5_5) continue block0;
                    if (var3_3 < var4_4) {
                        var0[var3_3] = var0[var4_4];
                        ++var3_3;
                    }
                    while (var3_3 < var4_4 && var0[var3_3] < var5_5) {
                        ++var3_3;
                    }
                    if (var3_3 >= var4_4) continue;
                    var0[var4_4] = var0[var3_3];
                    --var4_4;
lbl18:
                    // 3 sources

                } while (var3_3 < var4_4);
            }
            var0[var3_3] = var5_5;
            Grapes.o00000(var0, var1_1, var3_3 - 1);
            Grapes.o00000(var0, var3_3 + 1, var2_2);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void new(int[] var0, int var1_1, int var2_2) {
        block4: {
            if (var1_1 >= var2_2) break block4;
            var3_3 = var1_1;
            var4_4 = var2_2;
            var5_5 = var0[var3_3];
            ** GOTO lbl18
            {
                --var4_4;
                do {
                    if (var3_3 < var4_4 && var0[var4_4] < var5_5) continue block0;
                    if (var3_3 < var4_4) {
                        var0[var3_3] = var0[var4_4];
                        ++var3_3;
                    }
                    while (var3_3 < var4_4 && var0[var3_3] > var5_5) {
                        ++var3_3;
                    }
                    if (var3_3 >= var4_4) continue;
                    var0[var4_4] = var0[var3_3];
                    --var4_4;
lbl18:
                    // 3 sources

                } while (var3_3 < var4_4);
            }
            var0[var3_3] = var5_5;
            Grapes.new(var0, var1_1, var3_3 - 1);
            Grapes.new(var0, var3_3 + 1, var2_2);
        }
    }

    public static String getVersion() {
        return String.valueOf(\u00d400000) + " " + \u00d300000 + "(" + \u00d200000 + ")";
    }

    public static void main(String[] stringArray) {
        System.out.println(Grapes.getVersion());
    }
}

