/*
 * Decompiled with CFR 0.152.
 */
package fire.sql.structure;

import fire.sql.Structure;
import grapes.Grapes;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySQLStructure
implements Structure {
    private static Logger o00000 = LoggerFactory.getLogger(MySQLStructure.class);

    @Override
    public String getVersion(Connection connection) throws Exception {
        if (connection == null) {
            return null;
        }
        String string = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select version();");
            while (resultSet != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            o00000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return string;
    }

    @Override
    public List<Map<String, String>> getTables(Connection connection, String string) throws Exception {
        if (connection == null) {
            return null;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("show table status");
            if (resultSet != null) {
                int n = 0;
                while (resultSet.next()) {
                    if (!connection.getCatalog().equalsIgnoreCase(string)) continue;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("index", String.valueOf(n));
                    hashMap.put("count", String.valueOf(n + 1));
                    hashMap.put("dbcat", connection.getCatalog());
                    hashMap.put("name", resultSet.getString("Name"));
                    hashMap.put("type", resultSet.getString("Engine"));
                    hashMap.put("comment", resultSet.getString("Comment"));
                    hashMap.put("rows", resultSet.getString("Rows"));
                    arrayList.add(hashMap);
                    ++n;
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            o00000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }

    @Override
    public List<Map<String, String>> getColumns(Connection connection, String string, String string2) throws Exception {
        if (connection == null) {
            return null;
        }
        if (Grapes.isEmpty((Object)string)) {
            string = connection.getCatalog();
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        try {
            Statement statement;
            ResultSet resultSet;
            StringBuffer stringBuffer = new StringBuffer("select TABLE_SCHEMA,COLUMN_NAME,COLUMN_TYPE,IS_NULLABLE,DATA_TYPE,CHARACTER_OCTET_LENGTH,NUMERIC_PRECISION,COLUMN_KEY,COLUMN_DEFAULT,COLUMN_COMMENT from information_schema.`COLUMNS` where ");
            if (Grapes.isNotEmpty((Object)string)) {
                stringBuffer.append("TABLE_SCHEMA='" + string + "' and ");
            }
            if (Grapes.isNotEmpty((Object)string2)) {
                stringBuffer.append("TABLE_NAME='" + string2 + "'");
            }
            if ((resultSet = (statement = connection.createStatement()).executeQuery(stringBuffer.toString())) != null) {
                int n = 0;
                while (resultSet.next()) {
                    String string3 = "NO";
                    String string4 = null;
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("index", String.valueOf(n));
                    hashMap.put("count", String.valueOf(n + 1));
                    hashMap.put("dbcat", resultSet.getString("TABLE_SCHEMA"));
                    hashMap.put("name", resultSet.getString("COLUMN_NAME"));
                    hashMap.put("type", resultSet.getString("DATA_TYPE"));
                    hashMap.put("types", resultSet.getString("COLUMN_TYPE"));
                    hashMap.put("comment", resultSet.getString("COLUMN_COMMENT"));
                    hashMap.put("isnull", resultSet.getString("IS_NULLABLE"));
                    hashMap.put("default", resultSet.getString("COLUMN_DEFAULT"));
                    hashMap.put("key", resultSet.getString("COLUMN_KEY"));
                    if ("PRI".equalsIgnoreCase(resultSet.getString("COLUMN_KEY"))) {
                        string3 = "YES";
                    }
                    hashMap.put("iskey", string3);
                    string4 = ((String)hashMap.get("type")).toLowerCase().indexOf("int") != -1 ? String.valueOf(resultSet.getInt("NUMERIC_PRECISION") + 1) : (((String)hashMap.get("type")).toLowerCase().indexOf("text") != -1 ? "" : String.valueOf(resultSet.getInt("CHARACTER_OCTET_LENGTH")));
                    hashMap.put("size", string4);
                    arrayList.add(hashMap);
                    ++n;
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            o00000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }

    @Override
    public List<String> getData(Connection connection, String string) throws Exception {
        if (connection == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from " + string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSet != null) {
                while (resultSet.next()) {
                    StringBuffer stringBuffer = new StringBuffer("insert into `" + string + "` values (");
                    int n = 1;
                    while (n <= resultSetMetaData.getColumnCount()) {
                        if (n > 1) {
                            stringBuffer.append(",'" + resultSet.getString(n) + "'");
                        } else {
                            stringBuffer.append("'" + resultSet.getString(n) + "'");
                        }
                        ++n;
                    }
                    stringBuffer.append(");");
                    arrayList.add(stringBuffer.toString());
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            o00000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }
}

