/*
 * Decompiled with CFR 0.152.
 */
package fire.sql.structure;

import fire.sql.Structure;
import grapes.Grapes;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MSSQLStructure
implements Structure {
    private static Logger \u00d200000 = LoggerFactory.getLogger(MSSQLStructure.class);

    @Override
    public String getVersion(Connection connection) throws Exception {
        if (connection == null) {
            return null;
        }
        String string = null;
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select version();");
            while (resultSet != null && resultSet.next()) {
                string = resultSet.getString(1);
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            \u00d200000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return string;
    }

    @Override
    public List<Map<String, String>> getTables(Connection connection, String string) throws Exception {
        if (connection == null) {
            return null;
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        try {
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            String[] stringArray = new String[]{"table", "view"};
            resultSet = Grapes.isNotEmpty((Object)string) ? databaseMetaData.getTables(string, "%", "%", stringArray) : databaseMetaData.getTables(null, "%", "%", stringArray);
            if (resultSet != null) {
                int n = 0;
                while (resultSet.next()) {
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("index", String.valueOf(n));
                    hashMap.put("count", String.valueOf(n + 1));
                    hashMap.put("dbcat", resultSet.getString("TABLE_CAT"));
                    hashMap.put("name", resultSet.getString("TABLE_NAME"));
                    hashMap.put("type", resultSet.getString("TABLE_TYPE"));
                    hashMap.put("comment", resultSet.getString("REMARKS"));
                    arrayList.add(hashMap);
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            \u00d200000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }

    @Override
    public List<Map<String, String>> getColumns(Connection connection, String string, String string2) throws Exception {
        if (connection == null) {
            return null;
        }
        if (Grapes.isEmpty((Object)string)) {
            string = connection.getCatalog();
        }
        ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
        try {
            ResultSet resultSet = null;
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = Grapes.isNotEmpty((Object)string) ? databaseMetaData.getColumns(string, "%", string2, "%") : databaseMetaData.getColumns(null, "%", string2, "%");
            if (resultSet != null) {
                int n = 0;
                while (resultSet.next()) {
                    String string3 = "NO";
                    HashMap<String, String> hashMap = new HashMap<String, String>();
                    hashMap.put("index", String.valueOf(n));
                    hashMap.put("count", String.valueOf(n + 1));
                    hashMap.put("name", resultSet.getString("COLUMN_NAME"));
                    hashMap.put("type", resultSet.getString("TYPE_NAME"));
                    hashMap.put("size", resultSet.getString("COLUMN_SIZE"));
                    hashMap.put("digits", resultSet.getString("DECIMAL_DIGITS"));
                    hashMap.put("comment", resultSet.getString("REMARKS"));
                    hashMap.put("isnull", resultSet.getString("IS_NULLABLE"));
                    hashMap.put("default", resultSet.getString("COLUMN_DEF"));
                    if (((String)hashMap.get("comment")).equalsIgnoreCase("auto_increment")) {
                        string3 = "YES";
                    }
                    hashMap.put("iskey", string3);
                    arrayList.add(hashMap);
                    ++n;
                }
            }
            resultSet.close();
        }
        catch (SQLException sQLException) {
            \u00d200000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }

    @Override
    public List<String> getData(Connection connection, String string) throws Exception {
        if (connection == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("select * from " + string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            if (resultSet != null) {
                while (resultSet.next()) {
                    StringBuffer stringBuffer = new StringBuffer("insert into `" + string + "` values (");
                    int n = 1;
                    while (n <= resultSetMetaData.getColumnCount()) {
                        if (n > 1) {
                            stringBuffer.append(",'" + resultSet.getString(n) + "'");
                        } else {
                            stringBuffer.append("'" + resultSet.getString(n) + "'");
                        }
                        ++n;
                    }
                    stringBuffer.append(");");
                    arrayList.add(stringBuffer.toString());
                }
            }
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            \u00d200000.error(sQLException.getMessage(), (Throwable)sQLException);
        }
        return arrayList;
    }
}

