/*
 * Decompiled with CFR 0.152.
 */
package fire;

import fire.FireAccess;
import fire.connection.ConnectionProvider;
import fire.connection.FireConfig;
import grapes.Grapes;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FireBuild {
    private static Logger \u00d200000 = LoggerFactory.getLogger(FireBuild.class);
    private static FireConfig o00000 = FireConfig.getInstance();
    private static Map<String, ConnectionProvider> \u00d300000;

    public static FireBuild getInstance() {
        return FireBuildHolder.o00000;
    }

    private FireBuild() {
        \u00d200000.info(FireAccess.getVersion());
        try {
            if (\u00d300000 == null) {
                \u00d300000 = new ConcurrentHashMap<String, ConnectionProvider>();
            }
            List<String> list = o00000.getListName();
            for (String string : list) {
                ConnectionProvider connectionProvider = \u00d300000.get(string);
                if (connectionProvider != null) continue;
                connectionProvider = this.o00000(string);
                if (connectionProvider == null) {
                    \u00d200000.info("Unable to loading datasource: " + string);
                    continue;
                }
                \u00d300000.put(string, connectionProvider);
            }
        }
        catch (Exception exception) {
            \u00d200000.error(exception.getMessage(), (Throwable)exception);
        }
    }

    private ConnectionProvider o00000(String string) {
        Properties properties = o00000.getProperties(string);
        if (properties == null) {
            \u00d200000.error("Datasource config is null: " + string);
            return null;
        }
        \u00d200000.info("Loading datasource: " + string);
        String string2 = properties.getProperty("fire.connection.provider");
        if (string2 == null) {
            \u00d200000.error("Connection provider is null: fire.connection.provider");
            return null;
        }
        try {
            ConnectionProvider connectionProvider = (ConnectionProvider)Grapes.getBean((String)properties.getProperty("fire.connection.provider"));
            connectionProvider.configure(properties);
            return connectionProvider;
        }
        catch (Exception exception) {
            \u00d200000.error("Unable to loading connection provider: " + properties.getProperty("fire.connection.provider"), (Throwable)exception);
            return null;
        }
    }

    public Map<String, ConnectionProvider> getProviderMap() {
        return \u00d300000;
    }

    public FireAccess getAccess(String string) {
        ConnectionProvider connectionProvider = \u00d300000.get(string = Grapes.isEmpty((Object)string) ? "JSPGen" : string);
        if (connectionProvider == null) {
            connectionProvider = this.o00000(string);
            if (connectionProvider == null) {
                \u00d200000.info("Unable to loading datasource: " + string);
                return null;
            }
            \u00d300000.put(string, connectionProvider);
        }
        try {
            FireAccess fireAccess = new FireAccess(connectionProvider);
            return fireAccess;
        }
        catch (SQLException sQLException) {
            \u00d200000.error(sQLException.getMessage(), (Throwable)sQLException);
            return null;
        }
    }

    public FireAccess getAccess() {
        return this.getAccess(null);
    }

    public void shutdown() {
        try {
            if (\u00d300000 == null) {
                return;
            }
            for (String string : \u00d300000.keySet()) {
                ConnectionProvider connectionProvider = \u00d300000.get(string);
                if (connectionProvider == null) continue;
                connectionProvider.close();
                \u00d200000.info("Unloading datasource: " + connectionProvider.getName());
                connectionProvider = null;
            }
        }
        catch (Exception exception) {
            \u00d200000.error(exception.getMessage(), (Throwable)exception);
        }
    }

    /* synthetic */ FireBuild(FireBuild fireBuild) {
        this();
    }

    private static class FireBuildHolder {
        private static FireBuild o00000 = new FireBuild(null);

        private FireBuildHolder() {
        }
    }
}

