/*
 * Decompiled with CFR 0.152.
 */
package cms.util;

import cms.entity.Content;
import cms.entity.Node;
import grapes.Dates;
import grapes.Files;
import grapes.Grapes;
import grapes.bean.Beans;
import grapes.filter.FilenameFilter;
import java.io.File;
import java.io.FileFilter;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jspgen.action.ActionContext;
import jspgen.config.bean.Psn;
import jspgen.util.Common;

public class CMSCommon {
    public static final String DOMAIN_STATUS = "cms.domain@status";
    public static final String DOMAIN_PARENT = "cms.domain.parent";
    public static final String DOMAIN_REDIRECT = "cms.domain.redirect";
    private static String \u00d200000 = "index.jsp";
    private static String o00000 = "cms/view/";

    public static String getNodeParents(List<Node> list, boolean bl) {
        if (Grapes.isEmpty(list)) {
            return "";
        }
        String string = "";
        int n = list.size();
        if (!bl) {
            --n;
        }
        int n2 = 0;
        while (n2 < n) {
            if (n2 > 0) {
                string = String.valueOf(string) + "/";
            }
            string = String.valueOf(string) + list.get(n2).getAlias();
            ++n2;
        }
        return string;
    }

    public static String getContentPath(Content content) {
        if (Grapes.isEmpty((Object)((Object)content))) {
            return "";
        }
        if (Grapes.isEmpty((Object)content.getUrl())) {
            return "";
        }
        ActionContext actionContext = ActionContext.getContext();
        String string = content.getUrl();
        String string2 = actionContext.getRealPath();
        Psn psn = Common.getUrlPsn((String)string);
        if (Grapes.isNotEmpty((Object)psn)) {
            if (Grapes.isNotEmpty((Object)psn.getPath())) {
                string2 = psn.getPath();
            }
            if (Grapes.isNotEmpty((Object)psn.getUrl())) {
                string = Grapes.removeStartIgnoreCase((String)string, (String)psn.getUrl());
            }
        } else {
            string = Grapes.removeStartIgnoreCase((String)string, (String)actionContext.getContextPath());
        }
        string2 = String.valueOf(string2) + string;
        return string2;
    }

    public static String getFormatPath(String string, String string2, Map<String, Object> map, List<Node> list) {
        if (Grapes.isEmpty((Object)string2)) {
            return "";
        }
        map = CMSCommon.ruleRegister(map);
        if (Grapes.isNotEmpty(list)) {
            map.put("parents", CMSCommon.getNodeParents(list, false));
        }
        string2 = string2.trim();
        ActionContext actionContext = ActionContext.getContext();
        if (Grapes.isNotEmpty((Object)string)) {
            string2 = "${psn@" + string + "}" + string2;
            string2 = Common.formatPsn((String)string2, (String)"path", (String)actionContext.getPublishPath());
        } else {
            string2 = String.valueOf(actionContext.getPublishPath()) + string2;
        }
        string2 = Common.formatUrl((String)string2, map);
        return string2;
    }

    public static String getFormatPath(String string, String string2, Map<String, Object> map) {
        return CMSCommon.getFormatPath(string, string2, map, null);
    }

    public static String getFormatUrl(String string, String string2, Map<String, Object> map, List<Node> list) {
        if (Grapes.isEmpty((Object)string2)) {
            return "";
        }
        map = CMSCommon.ruleRegister(map);
        if (Grapes.isNotEmpty(list)) {
            map.put("parents", CMSCommon.getNodeParents(list, false));
        }
        string2 = string2.trim();
        ActionContext actionContext = ActionContext.getContext();
        if (Grapes.isNotEmpty((Object)string)) {
            string2 = "${psn@" + string + "}" + string2;
            string2 = Common.formatPsn((String)string2, (String)"url", (String)actionContext.getPublishUrl());
        } else {
            string2 = String.valueOf(actionContext.getPublishUrl()) + string2;
        }
        string2 = Common.formatUrl((String)string2, map);
        return string2;
    }

    public static String getFormatUrl(String string, String string2, Map<String, Object> map) {
        return CMSCommon.getFormatUrl(string, string2, map, null);
    }

    public static Map<String, Object> ruleRegister(Map<String, Object> map) {
        if (Grapes.isEmpty(map)) {
            map = new HashMap<String, Object>();
        }
        return map;
    }

    public static Map<String, Object> ruleRegister(Node node) {
        Map map = Beans.beanMap((Object)((Object)node));
        Grapes.isNotEmpty((Object)((Object)node));
        return map;
    }

    public static Map<String, Object> ruleRegister(Node node, Content content) {
        Map map = Beans.beanMap((Object)((Object)content));
        if (Grapes.isNotEmpty((Object)((Object)node))) {
            map.put("alias", node.getAlias());
        }
        Grapes.isNotEmpty((Object)((Object)content));
        return map;
    }

    public static String getParentPath(String string) {
        if (Grapes.isEmpty((Object)string)) {
            return "";
        }
        return new File(string).getParent();
    }

    public static void deletes(String string) {
        File[] fileArray;
        if (Grapes.isEmpty((Object)string)) {
            return;
        }
        File file = Files.getFile((String)string);
        if (file != null && (fileArray = (file = file.getParentFile()).listFiles((FileFilter)new FilenameFilter(Files.getExte((String)string), Files.getName((String)string)))) != null) {
            int n = 0;
            while (n < fileArray.length) {
                if (fileArray[n].isFile()) {
                    fileArray[n].delete();
                }
                ++n;
            }
        }
    }

    public static String getTemplatePrefix(boolean bl) {
        String string = o00000;
        if (bl) {
            string = "/ui/" + string;
        }
        return string;
    }

    public static String getTemplatePrefix() {
        return CMSCommon.getTemplatePrefix(false);
    }

    public static String getIndexTemplate(boolean bl) {
        if (!bl) {
            return \u00d200000;
        }
        return String.valueOf(CMSCommon.getTemplatePrefix(bl)) + \u00d200000;
    }

    public static String getIndexTemplate() {
        return CMSCommon.getIndexTemplate(false);
    }

    public static String getMoreUrlRule(String string) {
        String string2 = "." + Files.getExte((String)string);
        String string3 = Grapes.removeEndIgnoreCase((String)string, (String)string2);
        return String.valueOf(string3) + "_more" + string2;
    }

    public static String keywordMap(String string, List<Map<String, Object>> list) {
        if (Grapes.isEmpty((Object)string)) {
            return string;
        }
        try {
            String string2 = "";
            String string3 = "\u30101234Keyword4321\u3011";
            String string4 = "(<a (.*?)>(.*?)</a>)|(<img (.*?)>)";
            Pattern pattern = Pattern.compile(string4, 2);
            Matcher matcher = pattern.matcher(string);
            StringBuffer stringBuffer = new StringBuffer();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (matcher.find()) {
                arrayList.add(matcher.group(0));
                matcher.appendReplacement(stringBuffer, "");
                stringBuffer.append(string3);
            }
            matcher.appendTail(stringBuffer);
            string2 = stringBuffer.toString();
            for (Map<String, Object> map : list) {
                string2 = string2.replaceAll((String)map.get("name"), "<a href=\"" + (String)map.get("url") + "\" target=\"_blank\">" + (String)map.get("name") + "</a>");
            }
            string4 = string3;
            pattern = Pattern.compile(string4, 2);
            matcher = pattern.matcher(string2);
            stringBuffer = new StringBuffer();
            int n = 0;
            while (matcher.find()) {
                matcher.appendReplacement(stringBuffer, "");
                stringBuffer.append((String)arrayList.get(n));
                ++n;
            }
            matcher.appendTail(stringBuffer);
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
        return string;
    }

    public static String[] getMonthStartEnd(String string, int n) {
        String string2 = "";
        String string3 = "";
        if (n == 1) {
            string2 = String.valueOf(string) + "-01-" + "01";
            string3 = String.valueOf(string) + "-01-" + "31";
        }
        if (n == 3) {
            string2 = String.valueOf(string) + "-03-" + "01";
            string3 = String.valueOf(string) + "-03-" + "31";
        }
        if (n == 5) {
            string2 = String.valueOf(string) + "-05-" + "01";
            string3 = String.valueOf(string) + "-05-" + "31";
        }
        if (n == 7) {
            string2 = String.valueOf(string) + "-07-" + "01";
            string3 = String.valueOf(string) + "-07-" + "31";
        }
        if (n == 8) {
            string2 = String.valueOf(string) + "-08-" + "01";
            string3 = String.valueOf(string) + "-08-" + "31";
        }
        if (n == 10) {
            string2 = String.valueOf(string) + "-10-" + "01";
            string3 = String.valueOf(string) + "-10-" + "31";
        }
        if (n == 12) {
            string2 = String.valueOf(string) + "-12-" + "01";
            string3 = String.valueOf(string) + "-12-" + "31";
        }
        if (n == 2) {
            string2 = String.valueOf(string) + "-01-" + "01";
            string3 = String.valueOf(string) + "-01-" + "30";
        }
        if (n == 4) {
            string2 = String.valueOf(string) + "-04-" + "01";
            string3 = String.valueOf(string) + "-04-" + "30";
        }
        if (n == 6) {
            string2 = String.valueOf(string) + "-06-" + "01";
            string3 = String.valueOf(string) + "-06-" + "30";
        }
        if (n == 9) {
            string2 = String.valueOf(string) + "-09-" + "01";
            string3 = String.valueOf(string) + "-09-" + "30";
        }
        if (n == 11) {
            string2 = String.valueOf(string) + "-11-" + "01";
            string3 = String.valueOf(string) + "-11-" + "30";
        }
        return new String[]{string2, string3};
    }

    public static String[] getYesterday() {
        String string = "";
        String string2 = "";
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        ((Calendar)gregorianCalendar).add(5, -1);
        string = string2 = Dates.parseString((Date)gregorianCalendar.getTime(), (String)"yyyy-MM-dd");
        return new String[]{string, string2};
    }

    public static String[] getLastWeek() {
        String string = "";
        String string2 = "";
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        int n = calendar.get(7);
        if (n == 1) {
            n += 7;
        }
        calendar.add(5, 2 - n - 7);
        string = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        calendar.add(7, 6);
        string2 = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        return new String[]{string, string2};
    }

    public static String[] getNowMonth() {
        String string = "";
        String string2 = "";
        Calendar calendar = Calendar.getInstance();
        calendar.set(CMSCommon.getYear(), CMSCommon.getMonth() - 1, 1);
        string = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        int n = calendar.getActualMaximum(5);
        calendar.set(CMSCommon.getYear(), CMSCommon.getMonth() - 1, n);
        string2 = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        return new String[]{string, string2};
    }

    public static String[] getLastMonth() {
        String string = "";
        String string2 = "";
        Calendar calendar = Calendar.getInstance();
        calendar.set(CMSCommon.getYear(), CMSCommon.getMonth() - 2, 1);
        string = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        int n = calendar.getActualMaximum(5);
        calendar.set(CMSCommon.getYear(), CMSCommon.getMonth() - 2, n);
        string2 = Dates.parseString((Date)calendar.getTime(), (String)"yyyy-MM-dd");
        return new String[]{string, string2};
    }

    public static Integer getYear() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)Calendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(1);
    }

    public static Integer getMonth() {
        Date date = new Date();
        GregorianCalendar gregorianCalendar = (GregorianCalendar)Calendar.getInstance();
        gregorianCalendar.setTime(date);
        return gregorianCalendar.get(2) + 1;
    }

    public static String getPercnet(Long l, Long l2, int n) {
        NumberFormat numberFormat = NumberFormat.getPercentInstance();
        numberFormat.setMinimumFractionDigits(n);
        float f = (float)l.longValue() / (float)l2.longValue();
        return numberFormat.format(f);
    }

    public static String getPercnet(Long l, Long l2) {
        return CMSCommon.getPercnet(l, l2, 0);
    }

    public static String getMonthFirstDay() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.add(2, 0);
        calendar.set(5, 1);
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }

    public static String getMonthLastDay() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = Calendar.getInstance();
        calendar.set(5, calendar.getActualMaximum(5));
        String string = simpleDateFormat.format(calendar.getTime());
        return string;
    }
}

