/*
 * Decompiled with CFR 0.152.
 */
package jspgen.filter;

import grapes.Captcha;
import grapes.Grapes;
import grapes.image.Images;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import jspgen.config.CaptchaConfig;
import jspgen.config.JSPGenConfig;

public class CaptchaFilter
implements Filter {
    private String o00000 = "english";

    public void init(FilterConfig filterConfig) throws ServletException {
        if (Grapes.isNotEmpty((Object)filterConfig.getInitParameter("type"))) {
            this.o00000 = filterConfig.getInitParameter("type");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)servletRequest;
        HttpServletResponse httpServletResponse = (HttpServletResponse)servletResponse;
        httpServletResponse.addHeader(JSPGenConfig.POWERED_BY, JSPGenConfig.URL);
        httpServletResponse.setHeader("Pragma", "no-cache");
        httpServletResponse.setHeader("Cache-Control", "no-cache");
        httpServletResponse.setDateHeader("Expires", 0L);
        httpServletResponse.setContentType("image/jpeg");
        if (Grapes.isNotEmpty((Object)httpServletRequest.getParameter("type"))) {
            this.o00000 = httpServletRequest.getParameter("type");
        }
        HttpSession httpSession = httpServletRequest.getSession(true);
        ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
        BufferedImage bufferedImage = null;
        try {
            try {
                String string = "";
                Captcha captcha = new Captcha();
                if ("english".equals(this.o00000)) {
                    bufferedImage = captcha.getBufferedImage(Captcha.CaptchaType.english);
                    string = captcha.getCaptcha();
                } else if ("chinese".equals(this.o00000)) {
                    bufferedImage = captcha.getBufferedImage(Captcha.CaptchaType.chinese);
                    string = captcha.getCaptcha();
                } else {
                    CaptchaConfig captchaConfig = CaptchaConfig.getInstance();
                    Map<String, Object> map = captchaConfig.getRand(this.o00000);
                    if (map != null) {
                        bufferedImage = captcha.getBufferedImage((InputStream)map.get("name"), Captcha.CaptchaType.file);
                        string = map.get("answer").toString();
                    } else {
                        bufferedImage = captcha.getBufferedImage(Captcha.CaptchaType.english);
                        string = captcha.getCaptcha();
                    }
                }
                httpSession.removeAttribute(CaptchaConfig.SESSION_CAPTCHA_KEY);
                httpSession.setAttribute(CaptchaConfig.SESSION_CAPTCHA_KEY, (Object)string);
                httpSession.removeAttribute(CaptchaConfig.SESSION_CAPTCHA_STAT);
                httpSession.setAttribute(CaptchaConfig.SESSION_CAPTCHA_STAT, (Object)0);
                Images.writeImage((BufferedImage)bufferedImage, (Object)servletOutputStream);
                bufferedImage = null;
                servletOutputStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                servletOutputStream.close();
            }
        }
        finally {
            servletOutputStream.close();
        }
    }

    public void destroy() {
    }
}

