package com.android.musicman;

import java.util.List;
import android.app.Activity;
import android.content.Intent;

import com.android.musicman.MainActivity;
import com.android.musicman.MusicInfo;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.ListView;
import android.widget.Toast;
import android.view.Window;

public class MusicListActivity extends Activity{
    private ListView listView = null;
    private Button buttonBack = null;
    private ListAdapter adapter = null;
    private static List<MusicInfo> musicList = null;
    
    
    public void onCreate(Bundle savedInstanceState){
    	super.onCreate(savedInstanceState);
    	requestWindowFeature(Window.FEATURE_NO_TITLE);
    	setContentView(R.layout.music_list_main);
    	initListView();
    	initBackToMain();
    }
    
    
    public void initListView(){
    	listView = (ListBounceView)findViewById(R.id.MusicListView);
    	
    	musicList = MainActivity.getMusicInfoList();
    	adapter = new ListAdapter(this, musicList);
    	listView.setAdapter(adapter);
    	
    	listView.setItemsCanFocus(false);
    	listView.setOnItemClickListener(new AdapterView.OnItemClickListener() {
    		public void onItemClick(AdapterView<?> parent, View view,
    				int position, long id) {
    		    // TODO Auto-generated method stub
    			Toast.makeText(MusicListActivity.this, "ʼ" + musicList.get(position).getMusicTitle(), Toast.LENGTH_SHORT).show();
    			MainActivity.playMusic(musicList.get(position).getMusicPath());
    			}
		});
    }
    
    
    public void initBackToMain(){
    	buttonBack = (Button)findViewById(R.id.btn_back);
    	buttonBack.setOnClickListener(new View.OnClickListener() {
    		@Override
    		public void onClick(View v) {
    			// TODO Auto-generated method stub		
//		    	Intent intent = new Intent(MusicListActivity.this, MainActivity.class);
//		    	startActivityForResult(intent, 11);
		    	MusicListActivity.this.finish();
		    	overridePendingTransition(R.layout.zoomin, R.layout.zoomout);
    		}
    	});
    }
    
    
	public void btnmainright(View v) {  
		Intent intent = new Intent (MusicListActivity.this,RightTopDialog.class);			
		startActivity(intent);	
      }  	
}



