package com.android.musicman;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

import com.android.musicman.MenuAdapter;
import com.android.musicman.MenuUtils;

import android.widget.Toast;
import android.media.MediaPlayer;
import android.os.Bundle;
import android.os.Handler;
import android.provider.MediaStore;
import android.app.Activity;
import android.view.Menu;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.view.Gravity;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.GridView;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.PopupWindow;
import android.widget.SeekBar;
import android.widget.SeekBar.OnSeekBarChangeListener;
import android.widget.TextView;
import android.widget.AdapterView.OnItemClickListener;
import android.widget.LinearLayout.LayoutParams;

public class MainActivity extends Activity{
	//SDϢ
	private static List<MusicInfo> musicList = null;
	//ǰλ
	public static int curPosition = 0;
	//ֻ֤һsd
	private static int loadFlag = 1;
	//Menu
	private PopupWindow pw = null;
	private MenuAdapter menuAdapter = null;
	private GridView menuGridView = null;
	//һ   һť
	private ImageButton imgPlayButton = null;
	private ImageButton imgNextButton = null;
	private ImageButton imgPreButton = null;
	//
	private static SeekBar mSeekBar = null;
	//ʵʱʱʱ
	private static TextView nowTimeText = null;
	private static TextView totalTimeText = null;
	//͸
    private static TextView musicTitle = null;
    private static TextView musicSinger = null;
    public static MediaPlayer mediaPlayer = null;
    //ͼƬ
    private static ImageView faceView = null;
    private static Random random = null;
    private static SimpleDateFormat nowTimeFormat = null;
    //ʵʱhandle
    private static Handler mScheduleHandler = new Handler();
    //ר
    private static int[] face = new int[]{
    	R.drawable.face1, R.drawable.face2, R.drawable.face3,
    	R.drawable.face4, R.drawable.face5, R.drawable.face6,
    	R.drawable.face7
    };
    
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        requestWindowFeature(Window.FEATURE_NO_TITLE);
        setContentView(R.layout.activity_main);
        
        random = new Random();
        mediaPlayer = new MediaPlayer();
        nowTimeFormat = new SimpleDateFormat("mm:ss");
        
        initPopuWindows();
        getMusicListFromSD();
        initPlayMusic();
        initNextMusic();
        initPreMusic();
        initSeekBar();
    }
	
    
	//PopupWindows
    private void initPopuWindows() {
    	LayoutInflater inflater = (LayoutInflater)this.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
		View view = inflater.inflate(R.layout.menu, null);
		pw = new PopupWindow(view,LayoutParams.WRAP_CONTENT, LayoutParams.WRAP_CONTENT);
		//menu˵
		pw.setBackgroundDrawable(getResources().getDrawable(R.drawable.menu_bg_frame));
		//menu˵ý ûлýmenu˵еĿؼ¼޷Ӧ
		pw.setFocusable(true);
		pw.update();
		
		menuGridView = (GridView)view.findViewById(R.id.menuGridChange);
		//ôȡ
		menuGridView.setFocusableInTouchMode(true);
		//˵isShowingʱ,²˵ز˵
		menuGridView.setOnKeyListener(new android.view.View.OnKeyListener() {
			public boolean onKey(View v, int keyCode, KeyEvent event) {
				// TODO Auto-generated method stub
				if ((keyCode == KeyEvent.KEYCODE_MENU) && (pw.isShowing())) {
					pw.dismiss();  
					return true;
				}
				return false;
			}
		});
		
		//Ӳ˵ť¼
		menuGridView.setOnItemClickListener(new OnItemClickListener() {
			public void onItemClick(AdapterView<?> arg0, View arg1, int arg2, long arg3) {
				// TODO Auto-generated method stub
				pw.dismiss();
				
				switch (arg2) {
			    	case MenuUtils.MENU_OPEN_LIST:
				    	Toast.makeText(MainActivity.this, "бѡ", Toast.LENGTH_SHORT).show();
				    	
				    	Intent intent = new Intent(MainActivity.this, MusicListActivity.class);
				    	startActivityForResult(intent, 11);
				    	overridePendingTransition(R.layout.zoomin, R.layout.zoomout);
				    	break;
			    	case MenuUtils.MENU_REPEAT_LIST:
			    		Toast.makeText(MainActivity.this, "ѭ", Toast.LENGTH_SHORT).show();
			    		break;
			    	case MenuUtils.MENU_INFO:
			    		Toast.makeText(MainActivity.this, "ǰ汾Ϊ°汾", Toast.LENGTH_SHORT).show();
			    		break;
			    	case MenuUtils.MENU_CLOSE:
//			    		Toast.makeText(MainActivity.this, "˳Ӧ", Toast.LENGTH_SHORT).show();
			    		Intent startMain = new Intent(Intent.ACTION_MAIN);
                        startMain.addCategory(Intent.CATEGORY_HOME);
                        startMain.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
                        startActivity(startMain);
                        System.exit(0);//˳
				}
			}
		});
	}
    
    
    @Override
	public boolean onMenuOpened(int featureId, Menu menu) {
		// TODO Auto-generated method stub
		if (pw != null) {
			menuAdapter = new MenuAdapter(this);
			menuGridView.setAdapter(menuAdapter);
			pw.showAtLocation(this.findViewById(R.id.all_time), Gravity.BOTTOM, 0, 0);
		}
		// Ϊtrue ʾϵͳmenu
		return false;
	}

    
    public void initPlayMusic(){
//    	nowTimeText.setText("00:00");
    	faceView = (ImageView)findViewById(R.id.Face);
    	musicTitle = (TextView)findViewById(R.id.musicName);
    	musicSinger = (TextView)findViewById(R.id.singer);
    	imgPlayButton = (ImageButton)findViewById(R.id.play);
    	imgPlayButton.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View arg0) {
				// TODO Auto-generated method stub
				
				if (mediaPlayer.isPlaying()) {
					mediaPlayer.pause();
					imgPlayButton.setImageDrawable(getResources().getDrawable(R.drawable.stop));
				}
				else {
					imgPlayButton.setImageDrawable(getResources().getDrawable(R.drawable.play));
					if (curPosition == 0) {
						playMusic(musicList.get(curPosition++).getMusicPath());
					}else {
						mediaPlayer.start();
					}
				}
			}
		});
    }
    
    
    public void initNextMusic(){
    	imgNextButton = (ImageButton)findViewById(R.id.right_song);
    	imgNextButton.setOnClickListener(new View.OnClickListener() {
			
			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				++curPosition;
				
			    if(curPosition == musicList.size())
			    	curPosition = 0;
			    
				playMusic(musicList.get(curPosition).getMusicPath());
			}
		});
    }
    
    
    public void initPreMusic(){
    	imgPreButton = (ImageButton)findViewById(R.id.left_song);
    	imgPreButton.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				// TODO Auto-generated method stub
				--curPosition;
				
				if (curPosition == -1) 
					curPosition = musicList.size() - 1;
				
				playMusic(musicList.get(curPosition).getMusicPath());
			}
		});
    }
    
    
    public static void playMusic(String path){
		int i = (int)random.nextInt(7);
		int r = i % 8;
		faceView.setImageResource(face[r]);
		
		//ʼʱ
		nowTimeText.setText("00:00");
		
    	try {
    		mediaPlayer.reset();
    		mediaPlayer.setDataSource(path);
    		mediaPlayer.prepare();
    		mediaPlayer.start();
    		
    		//½
    		doSeekBarUpdate();
    		
            //²ʱ
            int musicDurationTime = mediaPlayer.getDuration();
			SimpleDateFormat totalTimeFormat = new SimpleDateFormat("mm:ss");
			String ms2 = totalTimeFormat.format(musicDurationTime); 
			totalTimeText.setText(ms2);
			
			//¸͸
		    musicTitle.setText(musicList.get(curPosition).getMusicTitle());
//		    musicTitle.setSingleLine(true);
//		    musicTitle.setFocusable(true);
//		    musicTitle.setEllipsize(TruncateAt.MARQUEE);
//		    musicTitle.setMarqueeRepeatLimit(-1);
		    musicSinger.setText(musicList.get(curPosition).getMusicSinger());
		    
    		mediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener() {
				@Override
				public void onCompletion(MediaPlayer mp) {
					// TODO Auto-generated method stub
				    if(++curPosition >= musicList.size())
				    	curPosition = 0;
				    
				    playMusic(musicList.get(curPosition).getMusicPath());
					
				    //¸͸
				    musicTitle.setText(musicList.get(curPosition).getMusicTitle());
				    musicSinger.setTag(musicList.get(curPosition).getMusicSinger());
				    
		            //²ʱ
		            int musicDurationTime = mediaPlayer.getDuration();
					SimpleDateFormat totalTimeFormat = new SimpleDateFormat("mm:ss");
					String ms2 = totalTimeFormat.format(musicDurationTime); 
					totalTimeText.setText(ms2);
				}
			});
		} catch (Exception e) {
			// TODO: handle exception
			e.printStackTrace();
		}
    }
    
    
    public void initSeekBar(){
    	mSeekBar = (SeekBar)findViewById(R.id.playback_seeker);
    	nowTimeText = (TextView)findViewById(R.id.now_time);
    	totalTimeText = (TextView)findViewById(R.id.all_time);
    	mSeekBar.setProgress(0);
    	
    	mSeekBar.setOnSeekBarChangeListener(new OnSeekBarChangeListener() {
			
			@Override
			public void onStopTrackingTouch(SeekBar arg0) {
				// TODO Auto-generated method stub
			    mediaPlayer.start();
			}
			
			@Override
			public void onStartTrackingTouch(SeekBar arg0) {
				// TODO Auto-generated method stub
				mediaPlayer.pause();
			}
			
			@Override
			public void onProgressChanged(SeekBar arg0, int arg1, boolean arg2) {
				// TODO Auto-generated method stub
				//ûֶ϶²Ž
				if(arg2)
					mediaPlayer.seekTo(mSeekBar.getProgress());
			}
		});
    }
    
    
    private static void doSeekBarUpdate(){
    	//ýֵΪʱ
		mSeekBar.setMax(mediaPlayer.getDuration());
		
		//¿һ߳̽UI
    	mScheduleHandler.post(new Runnable() {
			@Override
			public void run() {
				// TODO Auto-generated method stub
				
				if (mediaPlayer.isPlaying() && !mSeekBar.isPressed()) {
					//²Ž
					int nowTime = mediaPlayer.getCurrentPosition();
					mSeekBar.setProgress(nowTime);
					
					//²ʱ
					String nowTime_s = nowTimeFormat.format(nowTime); 
					nowTimeText.setText(nowTime_s);
					
					try {
						mScheduleHandler.postDelayed(this, 1000);
					} catch (Exception e) {
						// TODO: handle exception
						e.printStackTrace();
					}
				}
			}
		});
    }
    
    
    public void getMusicListFromSD(){
    	//ֻ֤һ
    	if (loadFlag != 1)
    		return;
    	
    	Cursor mAudioCursor = this.getContentResolver().query(
    			              MediaStore.Audio.Media.EXTERNAL_CONTENT_URI, 
    			              null,
    			              null,
    			              null,
    			              MediaStore.Audio.AudioColumns.TITLE);
    	
    	musicList = new ArrayList<MusicInfo>();
    	
    	int musicCount = 0;

    	for (int i = 0; i < mAudioCursor.getCount(); i++) {
			mAudioCursor.moveToNext();	
			
			int duration = mAudioCursor.getInt(mAudioCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DURATION));
			//ɸѡʱ2ӵĸ
			if(duration > 180*1000){
				musicCount++;
				//ID
				int musicId = mAudioCursor.getInt(mAudioCursor.getColumnIndexOrThrow(MediaStore.Audio.Media._ID));
			    //·(URI)
				String musicPath = mAudioCursor.getString(mAudioCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.DATA));
				//
				String musicTitle = mAudioCursor.getString(mAudioCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.TITLE));
				//
				String musicSinger = mAudioCursor.getString(mAudioCursor.getColumnIndexOrThrow(MediaStore.Audio.Media.ARTIST));
				//ԹListViewʹ
				musicList.add(new MusicInfo(musicId, musicPath, musicTitle, musicSinger, duration));
				
//				System.out.println(musicPath);
//				System.out.println(musicTitle);
//				System.out.println(musicSinger);
//				System.out.println(musicId);
			}
		}
    	Toast.makeText(MainActivity.this, "SD" + musicCount + "׸", Toast.LENGTH_LONG).show();
    	loadFlag++;
    }
    
    
    public static List<MusicInfo> getMusicInfoList(){
    	return musicList;
    }
    
    
	public boolean onCreateOptionsMenu(Menu menu) {
		// TODO Auto-generated method stub
		return true;
	}
	
	
	@Override
	public boolean onPrepareOptionsMenu(Menu menu) {
		// TODO Auto-generated method stub
		menu.add("menu");
		return super.onPrepareOptionsMenu(menu);
	}
	
	
    public boolean onOptionsItemSelected(MenuItem item) {
    	return super.onOptionsItemSelected(item);
    }
}