package com.zhong.adapter;

import java.util.List;

import android.content.Context;
import android.graphics.Color;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.style.ForegroundColorSpan;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;

import com.zhong.activity.R;

public class UserSearchAdapter extends BaseAdapter {
	private final String TAG = "UserSearchAdapter";
	/** 所有的Item */
	private List<String> itemList = null;
	/** 上下文内容 */
	private Context context = null;
	/** 输入框中输入的内容 */
	private String text = null;

	// /** 最多显示多少个选项,负数表示全部 */
	// private int maxMatch = 10;

	public UserSearchAdapter(List<String> itemList, Context context, String text) {
		super();
		this.itemList = itemList;
		this.context = context;
		this.text = text;
	}

	@Override
	public int getCount() {
		// TODO Auto-generated method stub
		return itemList.size();
	}

	@Override
	public Object getItem(int position) {
		// TODO Auto-generated method stub
		return itemList.get(position);
	}

	@Override
	public long getItemId(int position) {
		// TODO Auto-generated method stub
		return position;
	}

	@Override
	public View getView(int position, View convertView, ViewGroup parent) {
		Log.i(TAG, "==getView()");
		ViewHolder holder = null;
		if (convertView == null) {
			holder = new ViewHolder();
			LayoutInflater inflater = (LayoutInflater) context
					.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
			convertView = inflater.inflate(R.layout.item_user_search, null);
			holder.textView_item_user_cityName = (TextView) convertView
					.findViewById(R.id.textView_item_user_cityName);
			convertView.setTag(holder);
		} else {
			holder = (ViewHolder) convertView.getTag();
		}
		String str = itemList.get(position);
		int start = str.indexOf(text);
		int end = start + text.length();
		SpannableStringBuilder style = new SpannableStringBuilder(str);
		/*
		 * style.setSpan(new BackgroundColorSpan(Color.GREEN), start, end,
		 * Spannable.SPAN_EXCLUSIVE_INCLUSIVE); // 设置指定位置textview的背景颜色
		 */
		style.setSpan(new ForegroundColorSpan(Color.RED), start, end,
				Spannable.SPAN_EXCLUSIVE_INCLUSIVE); // 设置指定位置文字的颜色
		holder.textView_item_user_cityName.setText(style);
		return convertView;
	}

	/**
	 * 自定义的listview中的每一个item项控件
	 * 
	 * @author 仲丛旭
	 * 
	 */
	class ViewHolder {
		TextView textView_item_user_cityName;// 城市名
	}

	// public ArrayList<String> getAllItems(){
	// return ;
	// }
}
