/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.app;

import android.app.Activity;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Bundle;
import android.support.v4.app.ActionBarDrawerToggle;
import android.support.v4.app.NavUtils;
import android.support.v7.app.ActionBar;
import android.support.v7.app.ActionBarActivity;
import android.support.v7.app.ActionBarActivityDelegateBase;
import android.support.v7.app.ActionBarActivityDelegateHC;
import android.support.v7.app.ActionBarActivityDelegateICS;
import android.support.v7.app.ActionBarActivityDelegateJB;
import android.support.v7.appcompat.R;
import android.support.v7.internal.view.SupportMenuInflater;
import android.support.v7.view.ActionMode;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

abstract class ActionBarActivityDelegate {
    static final String METADATA_UI_OPTIONS = "android.support.UI_OPTIONS";
    static final String UIOPTION_SPLIT_ACTION_BAR_WHEN_NARROW = "splitActionBarWhenNarrow";
    private static final String TAG = "ActionBarActivityDelegate";
    final ActionBarActivity mActivity;
    private ActionBar mActionBar;
    private MenuInflater mMenuInflater;
    boolean mHasActionBar;
    boolean mOverlayActionBar;
    private boolean mEnableDefaultActionBarUp;

    static ActionBarActivityDelegate createDelegate(ActionBarActivity activity) {
        int version = Build.VERSION.SDK_INT;
        if (version >= 16) {
            return new ActionBarActivityDelegateJB(activity);
        }
        if (version >= 14) {
            return new ActionBarActivityDelegateICS(activity);
        }
        if (version >= 11) {
            return new ActionBarActivityDelegateHC(activity);
        }
        return new ActionBarActivityDelegateBase(activity);
    }

    ActionBarActivityDelegate(ActionBarActivity activity) {
        this.mActivity = activity;
    }

    abstract ActionBar createSupportActionBar();

    final ActionBar getSupportActionBar() {
        if (this.mHasActionBar || this.mOverlayActionBar) {
            if (this.mActionBar == null) {
                this.mActionBar = this.createSupportActionBar();
                if (this.mEnableDefaultActionBarUp) {
                    this.mActionBar.setDisplayHomeAsUpEnabled(true);
                }
            }
        } else {
            this.mActionBar = null;
        }
        return this.mActionBar;
    }

    MenuInflater getMenuInflater() {
        if (this.mMenuInflater == null) {
            ActionBar ab = this.getSupportActionBar();
            this.mMenuInflater = ab != null ? new SupportMenuInflater(ab.getThemedContext()) : new SupportMenuInflater((Context)this.mActivity);
        }
        return this.mMenuInflater;
    }

    void onCreate(Bundle savedInstanceState) {
        TypedArray a = this.mActivity.obtainStyledAttributes(R.styleable.ActionBarWindow);
        if (!a.hasValue(0)) {
            a.recycle();
            throw new IllegalStateException("You need to use a Theme.AppCompat theme (or descendant) with this activity.");
        }
        this.mHasActionBar = a.getBoolean(0, false);
        this.mOverlayActionBar = a.getBoolean(1, false);
        a.recycle();
        if (NavUtils.getParentActivityName((Activity)this.mActivity) != null) {
            if (this.mActionBar == null) {
                this.mEnableDefaultActionBarUp = true;
            } else {
                this.mActionBar.setDisplayHomeAsUpEnabled(true);
            }
        }
    }

    abstract void onConfigurationChanged(Configuration var1);

    abstract void onStop();

    abstract void onPostResume();

    abstract void setContentView(View var1);

    abstract void setContentView(int var1);

    abstract void setContentView(View var1, ViewGroup.LayoutParams var2);

    abstract void addContentView(View var1, ViewGroup.LayoutParams var2);

    abstract void onTitleChanged(CharSequence var1);

    abstract void supportInvalidateOptionsMenu();

    abstract boolean supportRequestWindowFeature(int var1);

    abstract View onCreatePanelView(int var1);

    abstract boolean onPreparePanel(int var1, View var2, Menu var3);

    boolean onPrepareOptionsPanel(View view, Menu menu) {
        if (Build.VERSION.SDK_INT < 16) {
            return this.mActivity.onPrepareOptionsMenu(menu);
        }
        return this.mActivity.superOnPrepareOptionsPanel(view, menu);
    }

    abstract boolean onCreatePanelMenu(int var1, Menu var2);

    abstract boolean onMenuItemSelected(int var1, MenuItem var2);

    abstract boolean onBackPressed();

    abstract ActionMode startSupportActionMode(ActionMode.Callback var1);

    abstract void setSupportProgressBarVisibility(boolean var1);

    abstract void setSupportProgressBarIndeterminateVisibility(boolean var1);

    abstract void setSupportProgressBarIndeterminate(boolean var1);

    abstract void setSupportProgress(int var1);

    abstract ActionBarDrawerToggle.Delegate getDrawerToggleDelegate();

    abstract void onContentChanged();

    protected final String getUiOptionsFromMetadata() {
        try {
            PackageManager pm = this.mActivity.getPackageManager();
            ActivityInfo info = pm.getActivityInfo(this.mActivity.getComponentName(), 128);
            String uiOptions = null;
            if (info.metaData != null) {
                uiOptions = info.metaData.getString(METADATA_UI_OPTIONS);
            }
            return uiOptions;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e((String)TAG, (String)("getUiOptionsFromMetadata: Activity '" + this.mActivity.getClass().getSimpleName() + "' not in manifest"));
            return null;
        }
    }

    protected final Context getActionBarThemedContext() {
        ActionBarActivity context = this.mActivity;
        ActionBar ab = this.getSupportActionBar();
        if (ab != null) {
            context = ab.getThemedContext();
        }
        return context;
    }
}

