package com.homer.mobilelocationtxt;


import android.content.ContentValues;
import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;

public class DBHelper extends SQLiteOpenHelper {

	public static final String DB_NAME = "mobilelocation.db";
	private static final int DB_VERSION = 1;
	public final static String TABLE_NAME = "location_date";
	public final static String TABLE_NAME_1 = "location_date_1";
	public final static String TABLE_NAME_2 = "location_date_2";
	public final static String ID = "_id";
	public final static String NUMBER = "number";
	public final static String LOCATION = "location";
	public final static String CITY = "city";

	public final static int ID_INDEX = 0;
	public final static int NUMBER_INDEX = 1;
	public final static int LOCATION_INDEX = 2;
	public final static int CITY_INDEX = 3;

	private SQLiteDatabase mDb = null;

	/* d-->电信
	 * l-->联通
	 * s-->联通数据卡
	 * y-->移动
	 * */
	public static final String[] TableArray = new String[]{
		"d133","d153","d180","d181","d189",
		"l130","l131","l132","l155","l156","l185","l186",
		"s145","s147",
		"y134","y135","y136","y137","y138","y139","y150","y151","y152","y157","y158","y159","y182","y183","y184","y187","y188"
	};
	
	
	// 数据库SQL语句 创建归属地表
	public static final String NAME_TABLE_CREATE = "create table if not exists " + TABLE_NAME +  " ("
											+ "_id INTEGER PRIMARY KEY AUTOINCREMENT," 
											+ "number TEXT NOT NULL," 
											+ "city TEXT NOT NULL,"
											+ "location TEXT NOT NULL);";
	public static final String NAME_TABLE_CREATE_1 = "create table if not exists " + TABLE_NAME_1 +  " ("
			+ "_id INTEGER PRIMARY KEY AUTOINCREMENT," 
			+ "number TEXT NOT NULL," 
			+ "city TEXT NOT NULL,"
			+ "location TEXT NOT NULL);";
	
	public static final String NAME_TABLE_CREATE_2 = "create table if not exists " + TABLE_NAME_2 +  " ("
			+ "_id INTEGER PRIMARY KEY AUTOINCREMENT," 
			+ "number TEXT NOT NULL," 
			+ "city TEXT NOT NULL,"
			+ "location TEXT NOT NULL);";
	

	
	public final static String[] LOCATIONS = {  "上海移动", "上海联通", "云南移动", "云南联通", "内蒙古移动",
		"内蒙古联通", "北京移动", "北京联通", "吉林移动", "吉林联通", "四川移动", "四川联通", "天津移动", "天津联通", "宁夏移动", 
		"宁夏联通", "安徽移动", "安徽联通", "山东移动", "山东联通", "山西移动", "山西联通", "广东移动", "广东联通", "广西移动", 
		"广西联通", "新疆移动", "新疆联通", "江苏移动", "江苏联通", "江西移动", "江西联通", "河北移动", "河北联通", "河南移动", 
		"河南联通", "浙江移动", "浙江联通", "海南移动", "海南联通", "湖北移动", "湖北联通", "湖南移动", "湖南联通", "甘肃移动", 
		"甘肃联通", "福建移动", "福建联通", "西藏移动", "西藏联通", "贵州移动", "贵州联通", "辽宁移动", "辽宁联通", "重庆移动", 
		"重庆联通", "陕西移动", "陕西联通", "青海移动", "青海联通", "黑龙江移动", "黑龙江联通"  };
	
	
	public final static String[] LOCATIONS_1 = {  "上海", "云南", "内蒙古",
		"北京", "吉林", "四川", "天津", "安徽","山东", "广东", "广西", 
		"新疆", "江苏", "江西", "河北", "河南", "浙江", "海南", "湖北", "湖南", 
		"福建", "西藏", "贵州", "辽宁", "重庆", "陕西", "青海", "黑龙江"  };
	
	public final static String[] LOCATONS_2 = {"山西","甘肃","宁夏"};

	public DBHelper(Context context) {
		super(context, DB_NAME, null, DB_VERSION);
		mDb = getReadableDatabase();
	}

	@Override
	public void onCreate(SQLiteDatabase db) {

		for(int i = 0;i<TableArray.length;i++){
			
			String NAME_TABLE_CREATE_3 = "create table if not exists " + TableArray[i] +  " ("
					+ "_id INTEGER PRIMARY KEY AUTOINCREMENT," 
					+ "number TEXT NOT NULL," 
					+ "city TEXT NOT NULL,"
					+ "location TEXT NOT NULL);";
			
			db.execSQL(NAME_TABLE_CREATE_3);
		}
	}

	@Override
	public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {

	}
	
	public void doSql(String sql){
		mDb.execSQL(sql);
	}

	public void insert(String tablename, String key[], String date[]) {
		ContentValues values = new ContentValues();
		
		for (int i = 0; i < key.length; i++) {
			values.put(key[i], date[i]);
		}
		
		mDb.insert(tablename, null, values);
	}

}
