package com.homer.testdata;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Handler;
import android.provider.ContactsContract;
import android.provider.ContactsContract.CommonDataKinds.Phone;
import android.provider.ContactsContract.Contacts.Photo;
import android.text.TextUtils;
import android.util.Log;

import com.homer.face.LOCATON;
import com.homer.mobilelocationdb.MobileLocationDB;
import com.homer.mobilelocationdb.R;
import com.homer.service.BackService;

public class ReadFile implements Runnable{
	
	public static final String[] TableArray = new String[]{
		
		"d133","d153","d180","d181","d189",
		"l130","l131","l132","l155","l156","l185","l186",
		"s145","s147",
		"y134","y135","y136","y137","y138","y139","y150","y151","y152","y157","y158","y159","y182","y183","y184","y187","y188"
	};
	
	public static final String[] NumHeadArray = new String[]{
		
		"133","153","180","181","189",
		"130","131","132","155","156","185","186",
		"145","147",
		"134","135","136","137","138","139","150","151","152","157","158","159","182","183","184","187","188"
	};
	
	public static final List<String> NumList = java.util.Arrays.asList(NumHeadArray);
	public static final List<String> TableList = java.util.Arrays.asList(TableArray);
	
	InputStream in = null;
	BufferedReader br = null;
	String path = null;
	private static Map<String, Map<String, ArrayList<String>>> PROVINCE = null;	//省
	private static Map<String, ArrayList<String>> CITY = null;	//市
	private static Map<String,String> ALLNUMBER= null;//ALLNUMBER:@key--电话号码，@value---名字
	private static Map<String, ArrayList<String>> NO_ADDRESS_INFO = null;//无地址信息
	private static ArrayList<String> SEADRCH_FROM_WEBSERVICE = null;//本地数据库没有的号码先放到该容器
	ArrayList<String> NO_ADDRESS_INFO_DETAIL = null; //无地址信息的号码
	Context mContext = null;	

	public static final int PHONES_NUMBER_INDEX = 0;
	public static final int PHONES_DISPLAY_NAME_INDEX = 1;
	public static final int PHONES_CONTACT_ID_INDEX = 2;
	public static final int PHONES_PHOTO_ID_INDEX = 3;
	
	public static Handler hand = null;

	public ReadFile(InputStream in,Context mContext) {// 读取测试文件的号码
		// TODO Auto-generated constructor stub
		this.in = in;
		PROVINCE = new HashMap<String, Map<String, ArrayList<String>>>();//省
		CITY = new HashMap<String,ArrayList<String>>();//市
		ALLNUMBER = new HashMap<String, String>();
		NO_ADDRESS_INFO = new HashMap<String, ArrayList<String>>();
		NO_ADDRESS_INFO_DETAIL = new ArrayList<String>();
		this.mContext = mContext;
	}
	
	public ReadFile(Context mContext){//读取通讯录的联系人信息
		this.mContext = mContext;
	}
	
	/** 得到手机SIM卡联系人人信息 **/
	public void getSIMContacts() {
		final String[] PHONES_PROJECTION = new String[] {     
				       Phone.DISPLAY_NAME, Phone.NUMBER, Photo.PHOTO_ID,Phone.CONTACT_ID };
		ContentResolver resolver = mContext.getContentResolver();
		// 获取Sims卡联系人    
		Uri uri = Uri.parse("content://icc/adn");
		Cursor phoneCursor = resolver.query(uri, PHONES_PROJECTION,null, null, null);

		if (phoneCursor != null) {
			while (phoneCursor.moveToNext()) {
				// 得到手机号码
				String phoneNumber = phoneCursor
						.getString(2);;
				// 当手机号码为空的或者为空字段 跳过当前循环    
				if (TextUtils.isEmpty(phoneNumber))
					continue;
				// 得到联系人名称								
				String contactName = phoneCursor
						.getString(1);
				
				String id = phoneCursor
						.getString(0);

				// Sim卡中没有联系人头像    
			    	Log.i("查询结果", contactName+"__"+phoneNumber+"__"+id);
			    	if(phoneNumber.length() >11 || phoneNumber.length() == 13){//从第三方数据库查询归属地
			    		
			    		searchFromDataBase(pareNumber(phoneNumber),null);
			    		ALLNUMBER.put(pareNumber(phoneNumber),contactName);		
			    	}else{
			    		ALLNUMBER.put(phoneNumber,contactName);
			    		searchFromDataBase(phoneNumber,null);
			    	}
			    }   
			  /*把没有信息的人添加到容器*/
			    NO_ADDRESS_INFO.put(LOCATON.NO_ADDRESS_INFO, NO_ADDRESS_INFO_DETAIL);
			    phoneCursor.close();
			}
		}
	
	public void getContactsData(){
		 /**得到手机通讯录联系人信息**/ 
		final String[] PHONES_PROJECTION = new String[] {     
			       Phone.DISPLAY_NAME, Phone.NUMBER, Photo.PHOTO_ID,Phone.CONTACT_ID };
		ContentResolver resolver = mContext.getContentResolver();      
		// 获取手机联系人     
		Cursor cursor = resolver.query(Phone.CONTENT_URI,PHONES_PROJECTION, null, null, null);     
		   
		int count = 0;
		          
		if (cursor != null) {     
		    while (cursor.moveToNext()) {     
		          
		    //得到手机号码     
		    String phoneNumber = cursor.getString(PHONES_DISPLAY_NAME_INDEX);     
		    //当手机号码为空的或者为空字段 跳过当前循环     
		    if (TextUtils.isEmpty(phoneNumber))     
		        continue;     
		              
		    //得到联系人名称     
		    String contactName = cursor.getString(PHONES_NUMBER_INDEX);     
		              
		    //得到联系人ID     
		    Long contactid = cursor.getLong(PHONES_CONTACT_ID_INDEX);     
		          
		    //得到联系人头像ID     
		    Long photoid = cursor.getLong(PHONES_PHOTO_ID_INDEX);     
		              
		    //得到联系人头像Bitamp     
		    Bitmap contactPhoto = null;     
		          
		    //photoid 大于0 表示联系人有头像 如果没有给此人设置头像则给他一个默认的     
		    if(photoid > 0 ) {     
		        Uri uri =ContentUris.withAppendedId(ContactsContract.Contacts.CONTENT_URI,contactid);     
		        InputStream input = ContactsContract.Contacts.openContactPhotoInputStream(resolver, uri);     
		        contactPhoto = BitmapFactory.decodeStream(input);     
		    }else {     
		        contactPhoto = BitmapFactory.decodeResource(mContext.getResources(), R.drawable.ic_launcher);     
		    }     	              
		    	Log.i("查询结果", contactName+"  "+phoneNumber);
		    	if(phoneNumber.length() >11 || phoneNumber.length() == 13){//从第三方数据库查询归属地
		    		if(NumList.contains(phoneNumber.substring(0,3))){
		    			searchFromDataBase(pareNumber(phoneNumber),phoneNumber.substring(0,3));
		    		}else
		    			NO_ADDRESS_INFO_DETAIL.add(phoneNumber);
		    
		    		ALLNUMBER.put(pareNumber(phoneNumber),contactName);
		    	}else{
		    		ALLNUMBER.put(phoneNumber,contactName);
		    		searchFromDataBase(phoneNumber,phoneNumber.substring(0,3));
		    	}
		    	count++;
		    	Log.i("联系人数为:", count+"");
		    }
		    
		    /*把没有信息的人添加到容器*/
		    NO_ADDRESS_INFO.put(LOCATON.NO_ADDRESS_INFO, NO_ADDRESS_INFO_DETAIL);
		 
		    cursor.close();     
		}     
	}
	
	/*
	 * 读取出来的手机号码是136 5966 9239的话
	 * 解析成13659669239格式
	 * */
	private String pareNumber(String num){
		
		String str1 = num.substring(0,3);
		
		String str2 = num.substring(4, 8);
		Log.i("TAg", num);
		String str3 = num.substring(9, num.length());
		Log.i("TAg", str1+str2+str3);
		return str1+str2+str3;
	}
	
	
	private String getTableName(String head){
		for(int i = 0; i < NumList.size();i++){
			
			if(head.equals(NumList.get(i)))
				return TableList.get(i);
		}
		
		return null;
	}
	
	/* *
	 * 从文件读取号码做侧使用
	 * */
	public void getFileData() {
		try {
			br = new BufferedReader(new InputStreamReader(in,"GBK"));// 以GBK编码格式，读取文件
			String line;
			while ((line = br.readLine()) != null) {
				searchFromDataBase(line,line.substring(0,3));
			}
		} catch (UnsupportedEncodingException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} 
		catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
				if (br != null) {
					br.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	public static void ChangeToJson(){
		return;
	}

	/**
	 * @11位的就去WebService查找
	 * @少于11位的过滤掉
	 * @保存到无地址信息容器
	 **/	
	public void searchFromDataBase(String editStr,String head){
		if(head != null){
		
		if (editStr.length() == 11) {
			Cursor cursor = BackService.db.query(getTableName(head),null,"number=?",new String[] { editStr.substring(0,7) },null,null,null);
			if (cursor != null
					&& cursor.moveToFirst()) {
				String province = cursor.getString(MobileLocationDB.CITY_INDEX);
				String text = cursor.getString(MobileLocationDB.LOCATION_INDEX);
				
				addToContent(province,text,editStr);
				Log.i("TAG", text);	
			} else {
				Log.i("TAG", "未能在数据库中查询到您的手机号");		
				NO_ADDRESS_INFO_DETAIL.add(editStr);		
			}
		} else {
			NO_ADDRESS_INFO_DETAIL.add(editStr);
			Log.i("TAG", "___________手机号码为11位，重新输入");
		}
		}
	}
	
	
	
	
	private static void addToContent(String province,String city,String num){
		Map<String, ArrayList<String>> cityMap = PROVINCE.get(province);
		if(cityMap != null){
			ArrayList<String> arr = cityMap.get(city);
			if(arr != null){
				arr.add(num);
			}else{
				arr = new ArrayList<String>();
				arr.add(num);
			}
			cityMap.put(city, arr);		
		}else{
			cityMap = new HashMap<String, ArrayList<String>>();
			ArrayList<String> arr = new ArrayList<String>();
			arr.add(num);
			cityMap.put(city, arr);
		}
		
		PROVINCE.put(province, cityMap);
	}
	
	public static void ChangeListToString(){

	}
	
	
	public static Map<String, Map<String, ArrayList<String>>> getPROVINCE() {
		return PROVINCE;
	}

	public static void setPROVINCE(Map<String, Map<String, ArrayList<String>>> pROVINCE) {
		PROVINCE = pROVINCE;
	}

	public static Map<String, ArrayList<String>> getCITY() {
		return CITY;
	}

	public static void setCITY(Map<String, ArrayList<String>> cITY) {
		CITY = cITY;
	}
	
	public static Map<String, String> getALLNUMBER() {
		return ALLNUMBER;
	}

	public static void setALLNUMBER(Map<String, String> aLLNUMBER) {
		ALLNUMBER = aLLNUMBER;
	}

	public static Map<String, ArrayList<String>> getNO_ADDRESS_INFO() {
		return NO_ADDRESS_INFO;
	}

	public static void setNO_ADDRESS_INFO(
			Map<String, ArrayList<String>> nO_ADDRESS_INFO) {
		NO_ADDRESS_INFO = nO_ADDRESS_INFO;
	}
	
	@Override
	public void run() {
		// TODO Auto-generated method stub
		
	}
}
