package com.homer.service;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.homer.face.LOCATON;
import com.homer.mobilelocationdb.R;
import com.homer.testdata.ReadFile;
import com.homer.webservice.MobileInfoService;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.database.sqlite.SQLiteDatabase;
import android.os.IBinder;
import android.os.Message;
import android.util.Log;


/**
 * @启动时去配置文件查找如果文件存在的话，读出数据，并显示原来划分好的归属地信息
 * @查询数据库，并且打包过滤保存到配置文件
 * @没有的纪录打包到一个容器中
 * @为Activity提供数据
 * @当数据库有新添加的联系人时，更新数据库，并更新配置文件
 * */

public class BackService extends Service{
	
	public final static int ID_INDEX = 0;
	public final static int NUMBER_INDEX = 1;
	public final static int LOCATION_INDEX = 2;
	public final static int CITY_INDEX = 3;
	
	public final static int SEARCH_FROM_WEBSERVICE = 4;
	public final static int SEARCH_FROM_DATABASE = 5;
	
	public final static String databasePath = "/data/data/com.homer.mobilelocationdb/files";
	public final static String configPath = "/data/data/com.homer.mobilelocationdb/files/config.config";//配置文件
	public final static String configPath2 = "/data/data/com.homer.mobilelocationdb/files/all.config";//配置文件
	public final static String CONFIG_NAME = "config.config";//配置文件名
	public final static String CONFIG_NAME2 = "all.config";//配置文件名
	public final static String DB_NAME = "mobilelocation.db";
	public final static String DB_NAME_2 = "mobilelocation_2.db";
	public final static String TABLE_NAME = "location_date";
	public final static String TABLE_NAME_2 = "location_date_2";
	private File file = null;
	ReadFile datafile = null;
	public static SQLiteDatabase db = null;

	@Override
	public IBinder onBind(Intent intent) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public void onCreate() {
		// TODO Auto-generated method stub
		super.onCreate();
		Log.i("TAG", "Service Create");
		
		init();
	}

	@Override
	public void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
		if(db != null)
			db.close();
	}

	@Override
	@Deprecated
	public void onStart(Intent intent, int startId) {
		// TODO Auto-generated method stub
		super.onStart(intent, startId);
		Log.i("TAG", "Service start");
		
		if (copyDB(file)) { // 首先将DB文件拷贝至程序内存当中
			/**
			 * @author huangxin
			 * @如果有内容直接使用数据局
			 * @没有内容启动线程去数据库找
			 * @如果已经查找数据，那么把结果保存
			 * */
			File config= new File(configPath);
			File config2= new File(configPath2);
			if(config.exists() && config2.exists())
				getDataFromConfig(config,config2);
			else
				openDataBase();		
		}
	}

	public void openDataBase(){
		Log.i("openDataBase", "配置文件不存在，从数据库家在稍等");
		db = SQLiteDatabase.openOrCreateDatabase(file, null);	
		new MyThread(null,SEARCH_FROM_DATABASE).start();
	}

	
	private void init(){
		file = new File(databasePath, DB_NAME_2);
	}
	
	public boolean copyDB(File file) {
		try {
			if (!file.exists()) {
				InputStream is = getResources().openRawResource(R.raw.mobilelocation_2);
				FileOutputStream fos = this.openFileOutput(DB_NAME_2,Context.MODE_WORLD_READABLE);
				byte[] buffer = new byte[80 * 1024];
				int readSum = 0, readCount = 0;
				Log.i("ReadDB", "read() start...");
				while ((readCount = is.read(buffer)) > 0) { // 循环拷贝数据库文件
					fos.write(buffer, 0, readCount);
					readSum += readCount;
					Log.i("ReadDB", "readCount = "+ readCount+ "; readSum = "+ readSum);
				}
				fos.close();
				is.close();
			}
			return true;
		} catch (Exception e) {
			e.printStackTrace();
			return false;
		}
	}
	

	/**@如果有配置文件.config
	 * @从配置文件获取信息
	 * @获取完发出消息通知更新ListView
	 **/
	@SuppressWarnings("unchecked")
	public boolean getDataFromConfig(File config,File config2){ 
		
		FileInputStream fos = null;
		FileInputStream fos2 = null;
			try {
				Log.i("TAG", "hello world__");
				fos =this.openFileInput(CONFIG_NAME);
				fos2 =this.openFileInput(CONFIG_NAME2);
				Map<String, Map<String, ArrayList<String>>> map = (Map<String, Map<String, ArrayList<String>>>) new ObjectInputStream(fos).readObject();
				Map<String, Object> map2 = (Map<String, Object>) new ObjectInputStream(fos2).readObject();
				if(map==null || map2.get(LOCATON.ALL_RECORDE) == null){
					openDataBase();
					return false;
				}					
				Log.i("MAP", map2.toString());
				ReadFile.setPROVINCE(map);
				ReadFile.setALLNUMBER((Map<String,String>)map2.get(LOCATON.ALL_RECORDE));
				ReadFile.setNO_ADDRESS_INFO((Map<String, ArrayList<String>>)map2.get(LOCATON.NO_ADDRESS_INFO));
				Message msg = new Message();
				msg.what = 1;
				ReadFile.hand.sendMessage(msg);
				fos.close();
				Log.i("TAG", "get Object From .config success!!");
				return true;
			} catch (FileNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (OptionalDataException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (StreamCorruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (ClassNotFoundException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}finally{
				try { 
					if(fos != null){
						fos.close();
						return false;
					}
				} catch (IOException e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
				}
			}
			return false;
	}
	
	class MyThread extends Thread {

		ArrayList<String> editStr;
		int FLAG = 0;

		public MyThread(ArrayList<String> editStr, int FLAG) {
			// TODO Auto-generated constructor stub
			this.FLAG = FLAG;
			this.editStr = editStr;
		}

		@Override
		public void run() {
			// TODO Auto-generated method stub
			super.run();

			switch (FLAG) {
			case SEARCH_FROM_WEBSERVICE:
				SearchFromWebService(editStr);
				break;
			case SEARCH_FROM_DATABASE:
				SearchFromDataBase();
				break;
			default:
				break;

			}
		}
	}
	
	private void SearchFromWebService(ArrayList<String> editStr){
		
		for (String s : editStr) {
			try {
				InputStream inStream = getResources()
						.getAssets()
						.open("mobilesoap.xml");
				MobileInfoService.getMobileAddress(inStream, s);
			} catch (IOException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} catch (Exception e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
		}
	}	
	
	/**
	 * @发完消息把对象保存到文件
	 * **/
	private void SearchFromDataBase(){
		//////////////////////////////////////////////////////////////////////
		datafile = new ReadFile(this.getResources().openRawResource(R.raw.testdata),this);
		//ArrayList<String> arr = datafile.getArrNum();
		/////////////////////////////////////////////////////////////////////
		datafile.getContactsData();
		//datafile.getSIMContacts();
		//datafile.getFileData();
		Message msg = new Message();
		msg.what = 1;
		ReadFile.hand.sendMessage(msg);	
		Log.i("TAg", "hello");
		FileOutputStream fos =null;
		ObjectOutputStream ofos =null;
		FileOutputStream fos2 =null;
		ObjectOutputStream ofos2 =null;
		try {	
			File config = new File(configPath);
			File config2 = new File(configPath2);
			fos2 = new FileOutputStream(config2);
			ofos2 = new ObjectOutputStream(fos2);
			/**
			 * 所有联系人的号码
			 * 所有无地址信息的人的号码
			 * packageData() 打包保存到同一个文件中
			 **/
			ofos2.writeObject(packageData());
			fos = new FileOutputStream(config);
			ofos = new ObjectOutputStream(fos);
			ofos.writeObject(ReadFile.getPROVINCE());
			
			ofos.flush();
			ofos.close();
			fos.close();
			ofos2.flush();
			ofos2.close();
			fos2.close();
			Log.i("Province", ""+ReadFile.getPROVINCE().size());
		} catch (FileNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}finally{
			try{
				if(fos != null)
					fos.close();
				if(ofos != null)
					ofos.close();
				if(fos2 != null)
					fos2.close();
				if(ofos2 != null)
					ofos2.close();
			}catch (IOException e) {
				e.printStackTrace();
			}
		}
	}
	
	private Object packageData(){
		
		Map<String,Object> TOTAL = new HashMap<String, Object>();
		TOTAL.put(LOCATON.NO_ADDRESS_INFO, ReadFile.getNO_ADDRESS_INFO());
		TOTAL.put(LOCATON.ALL_RECORDE, ReadFile.getALLNUMBER());
		return TOTAL;
	}
	
}
