package com.homer.mobilelocationdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListView;
import android.widget.SimpleAdapter;

import com.homer.testdata.ReadFile;

public class CityView extends Activity{
	private ListView list =null;
	String province =null;
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.city);
		
		list = (ListView) findViewById(R.id.listView2);
		Intent in = this.getIntent();
		province = in.getStringExtra("key");
		try{
			SimpleAdapter adapter = new SimpleAdapter(this, getData2(getData(province)), R.layout.city_view, new String[]{"city","count"}, new int[]{R.id.city,R.id.count});
			//ArrayAdapter<String> adapter= new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, getData(province));
			list.setAdapter(adapter);
		}catch(NullPointerException e){
			Log.i("TAG", "NullPointerException");
		}
		
		
		list.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1,
					int arg2, long arg3) {
				// TODO Auto-generated method stub
				Map<String,String> map = (Map<String,String>) arg0.getItemAtPosition(arg2);
				Log.i("TAG", map.toString());
				Intent in = new Intent(CityView.this,NumberView.class);
				in.putExtra("key",map.get("city"));
				startActivity(in);	
			}
		});
	}
	
	@Override
	protected void onPause() {
		// TODO Auto-generated method stub
		super.onPause();
		//finish();
	}


	@Override
	protected void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
	}
	
	//ArrayApdater
	private ArrayList<String> getData(String province){
		
		Map<String, ArrayList<String>> map = ReadFile.getPROVINCE().get(province);
		Set<String> s = map.keySet();
		ArrayList<String> arr = new ArrayList<String>();
		for(String city:s){
			arr.add(city);
		}
		return arr;
	}
	
	//SimpleApdater
	private ArrayList<Map<String, String>> getData2(ArrayList<String> city){
		
		ArrayList<Map<String,String>> list = new ArrayList<Map<String,String>>();
		Map<String, ArrayList<String>> cityMap = ReadFile.getPROVINCE().get(province);
		for(String s: city){
			Map<String,String> map = new HashMap<String, String>();
			map.put("city", s);
			map.put("count", cityMap.get(s).size()+"位");
			list.add(map);		
		}
		
		return list;
	}
}
