package com.homer.mobilelocationtxt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

import org.apache.http.util.EncodingUtils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.res.Resources.NotFoundException;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.TextView;
import android.widget.Toast;

public class MobileLocationTXT extends Activity {
	private DBHelper m_db = null;

	public Button button = null;
	public TextView textNumber = null;
	public TextView textCity = null;
	public TextView textLocation = null;
	public TextView t = null;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		
		setContentView(R.layout.main);

		m_db = new DBHelper(this);
		
		button = (Button) this.findViewById(R.id.button);
		button.setText("开始读取资源写入数据库");
		
		textNumber = (TextView) this.findViewById(R.id.number);
		textCity = (TextView) this.findViewById(R.id.city);
		textLocation = (TextView) this.findViewById(R.id.location);
		t = (TextView) findViewById(R.id.textView1);

		button.setOnClickListener(new OnClickListener() {
			@Override
			public void onClick(View v) {
				new Thread() {		// 启动线程开始读取资源并写入数据库当中
					@Override
					public void run() {
						int count = DBHelper.TableArray.length;

						for (int i = 0; i < count; i++) {
							loadLocationFile(i);
						}
					}
				}.start();
			}
		});
	}

	Handler handler = new Handler() {
		@Override
		public void handleMessage(Message msg) {
			Bundle bundle = msg.getData();
			
			String number = bundle.getString("number");
			String city = bundle.getString("city");
			String location = bundle.getString("location");
			String line = bundle.getString("line");
			textNumber.setText(number);
			textCity.setText(city);
			textLocation.setText(location);
			t.setText(line);

			super.handleMessage(msg);
		}
	};

	@SuppressLint("ShowToast")
	private void loadLocationFile(int resourceID) {
		InputStream in = null;
		BufferedReader br = null;
		int flag = 1;

		try {
			in = this.getResources().openRawResource(R.raw.d133 + resourceID);
			br = new BufferedReader(new InputStreamReader(in, "GBK"));		// 以GBK编码格式，读取文件
			String line;
			while ((line = br.readLine()) != null) {
				
				int i = line.indexOf('-');
				//Log.i("TAG", ""+i+"line"+line);
				String number = line.substring(0, i);			// 读取手机号前7位  （如：1340200、1521034等）
				String temp = line.substring(i+1, line.length());		// 读书手机号归属地（如：上海、北京等）
				int j = temp.indexOf('-');
				String city = temp.substring(0, j);		
				String province = temp.substring(j+1, temp.length());
				
				//Log.i("TAG", EncodingUtils.getString(line.getBytes(), "Unicode")+"-"+EncodingUtils.getString(line.getBytes(),"UTF-8")+"-"+line+"i"+i);
				// 将数据写入数据库当中
				m_db.insert(DBHelper.TableArray[resourceID],
						new String[] {
								DBHelper.NUMBER,
								DBHelper.CITY,
								DBHelper.LOCATION },
						new String[] {
								number,
								city,
								province });
				Bundle bundle = new Bundle();
				bundle.putString("number", "手机号码特征数据：" + number);
				bundle.putString("city", "手机号归属地城市：" + EncodingUtils.getString(city.getBytes(), "UTF-8"));		// 把读取的文件，用UTF-8编码输出
				bundle.putString("location", "手机号码省级运营商：" + province);
				bundle.putString("line", "检索文件:"+this.getResources().getString(R.raw.d133+resourceID)+"行:"+flag+" 表"+DBHelper.TableArray[resourceID]);
				Message msg = new Message();
				msg.setData(bundle);
				handler.sendMessage(msg);

				flag++;
				
				Log.v("huangxin", "手机号码特征数据：" + number + "  归属地城市：" + city + "所在省：" + province+"flag:"+flag+" 表"+DBHelper.TableArray[resourceID]);
			}
		} catch (NotFoundException e) {
			Toast.makeText(this, "文本文件不存在", 100).show();
			e.printStackTrace();
		} catch (UnsupportedEncodingException e) {
			Toast.makeText(this, "文本编码出现异常", 100).show();
			e.printStackTrace();
		} catch (IOException e) {
			Toast.makeText(this, "文件读取错误", 100).show();
			e.printStackTrace();
		} finally {
			try {
				if (in != null) {
					in.close();
				}
				if (br != null) {
					br.close();
				}
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
	}

}