package com.homer.mobilelocationdb;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import com.homer.face.LOCATON;
import com.homer.testdata.ReadFile;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;
import android.widget.SimpleAdapter;

public class NumberView extends Activity {

	private ListView list = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		// TODO Auto-generated method stub
		super.onCreate(savedInstanceState);
		setContentView(R.layout.number);
		
		list = (ListView) findViewById(R.id.nlist);
		Intent in = this.getIntent();
		String city = in.getStringExtra("key");
		Log.i("TAG", city);
		try {
			if(city.equals(LOCATON.NO_ADDRESS_INFO_VIEW_TEXT)){
				ArrayAdapter<String> adapter = new ArrayAdapter<String>(this,android.R.layout.simple_list_item_1,getName(ReadFile.getNO_ADDRESS_INFO().get(LOCATON.NO_ADDRESS_INFO)));
				list.setAdapter(adapter);
			}else{
				SimpleAdapter adapter = new SimpleAdapter(this, getData(getData(city)), R.layout.num_view, new String[]{"name"}, new int[]{R.id.name});
				list.setAdapter(adapter);
		 	} 
		}catch (NullPointerException e) {
			Log.i("TAG", "NullPointerException");
		}
		
		list.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1,
					int arg2, long arg3) {
				// TODO Auto-generated method stub
				Map<String,String> map = (Map<String,String>) arg0.getItemAtPosition(arg2);
				Log.i("TAG", map.toString());
				Intent in = new Intent(NumberView.this,DetailInfo.class);
				in.putExtra("key",map.get("city"));
				startActivity(in);	
			}
		});
		
	}
	
	
	private void init(){}

	@Override
	protected void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
	}

	private ArrayList<String> getData(String city) {

		Map<String, Map<String, ArrayList<String>>> map = ReadFile.getPROVINCE();
		Map<String, ArrayList<String>> cityMap = null;

		for (String province : map.keySet()) {
			Log.i("TAG_2", province);
			cityMap = map.get(province);
			for (String _city : cityMap.keySet()) {
				if (_city.equals(city)) {
					Log.i("__TAG__", _city.length()+" "+city.length()+cityMap.get(city).toString());
					return getName(cityMap.get(city));
				}
			}
		}
		return null;
	}
	
	private ArrayList<String> getName(ArrayList<String> arrNum){
		Log.i("TAG", "getName"+ +arrNum.size());
		ArrayList<String> arrName = new ArrayList<String>();

		for(String s:arrNum){
			Log.i("TAG", ReadFile.getALLNUMBER().get(s));
			arrName.add(ReadFile.getALLNUMBER().get(s));		
		}	
		
		return arrName;
	}	
	
	private ArrayList<Map<String , String>> getData(ArrayList<String> arrName){
		
		ArrayList<Map<String , String>> arr = new ArrayList<Map<String,String>>();
		for(String s: arrName){
			Map<String , String> map = new HashMap<String, String>();
			map.put("name", s);
			arr.add(map);
		}
		
		return arr;
	}
}
