package com.homer.mobilelocationdb;


import java.util.ArrayList;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import com.homer.face.LOCATON;
import com.homer.service.BackService;
import com.homer.testdata.ReadFile;


public class MobileLocationDB extends Activity{
	
	public final static int ID_INDEX = 0;
	public final static int NUMBER_INDEX = 1;
	public final static int LOCATION_INDEX = 2;
	public final static int CITY_INDEX = 3;
	
	public final static int SEARCH_FROM_WEBSERVICE = 4;
	public final static int SEARCH_FROM_DATABASE = 5;
	
	private ArrayAdapter<String> adapter =null;
	private ListView list = null;
	MyHand hand = null;
	private Intent in = null;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		setContentView(R.layout.province);			
		
		init();
		try{
			list.setAdapter(adapter);
		}catch(NullPointerException e){
			Log.i("TAG", "NullpointerException");
		}
		
		Log.i("TAG", "onCreate");
		list.setOnItemClickListener(new AdapterView.OnItemClickListener() {

			@Override
			public void onItemClick(AdapterView<?> arg0, View arg1,
					int arg2, long arg3) {
				// TODO Auto-generated method stub
				String item = (String) arg0.getItemAtPosition(arg2);
				Log.i("TAG", item);
				if(item.equals(LOCATON.NO_ADDRESS_INFO_VIEW_TEXT)){
					in = new Intent(MobileLocationDB.this,NumberView.class);
					in.putExtra("key",LOCATON.NO_ADDRESS_INFO_VIEW_TEXT);
				}else{
					in = new Intent(MobileLocationDB.this,CityView.class);
					in.putExtra("key",item);
				}	
				startActivity(in);	
			}
		});
	}
	
	private void init(){
		
		list = (ListView) findViewById(R.id.listView1);
		ReadFile.hand = new MyHand();
		
		try{
			adapter= new ArrayAdapter<String>(this, android.R.layout.simple_list_item_1, getData());
		}catch(NullPointerException e){
			Log.i("TAG", "NullpointerException");
		}
		//启动后台服务进行,数据库创建,数据更新操作
		Intent service = new Intent(MobileLocationDB.this,BackService.class);		
		startService(service);
	}
	
	public ArrayList<String> getData(){
		ArrayList<String> arr = new ArrayList<String>();
		for(String s:ReadFile.getPROVINCE().keySet()){
			arr.add(s);
			Log.i("TAG", s);
		}
		return arr;
	}
	
	@SuppressLint("HandlerLeak")
	class MyHand extends Handler {

		@Override
		public void handleMessage(Message msg) throws NullPointerException{
			// TODO Auto-generated method stub
			super.handleMessage(msg);
			switch (msg.what) {
			case 1://Apdapter数据源发生改变时通知
				onSourceDataChange();		
				break;
			default:
				break;
			}
		}
	}
	
	/**
	 * 无地址信息不为空时添加到list
	 * 为空时略过
	 **/
	private void onSourceDataChange(){
		ArrayList<String> arr = getData();
		Log.i("TAG_HAND", "1");
		if(ReadFile.getNO_ADDRESS_INFO().get(LOCATON.NO_ADDRESS_INFO).size() != 0){
			arr.add(LOCATON.NO_ADDRESS_INFO_VIEW_TEXT);
		}
		
		adapter= new ArrayAdapter<String>(MobileLocationDB.this, android.R.layout.simple_list_item_1, arr);
		list.setAdapter(adapter);
		adapter.setNotifyOnChange(true);
	}
	
		
	@Override
	protected void onPause() {
		// TODO Auto-generated method stub
		super.onPause();
		Log.i("TAG", "onPause");
	}

	@Override
	protected void onDestroy() {
		// TODO Auto-generated method stub
		super.onDestroy();
		Log.i("TAG", "onDestroy");
		stopService(new Intent(this,BackService.class));
		finish();
	}
}
