package org.weixvn.wae.util;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class ShakeMonitor {
	@SuppressWarnings("unused")
	private static final String TAG = "ShakeMonitor";
	private Context context;
	private ShakeHandler handler;
	private SensorEventListener sensorEventListener;
	private SensorManager sensorManager;

	public ShakeMonitor(Context paramContext, ShakeHandler paramShakeHandler) {
		this.context = paramContext;
		this.handler = paramShakeHandler;
		this.sensorEventListener = null;
		this.sensorManager = ((SensorManager) this.context
				.getSystemService("sensor"));
	}

	private void makeSensorEventListener() {

		this.sensorEventListener = new SensorEventListener() {
			@SuppressWarnings("unused")
			static final int SHAKE_THRESHOLD = 1250;
			long lastShakeTime = 0L;
			long lastUpdate;
			float last_x = 0.0F;
			float last_y = 0.0F;
			float x;
			float y;

			public void onAccuracyChanged(Sensor paramSensor, int paramInt) {
			}

			public void onSensorChanged(SensorEvent paramSensorEvent) {
				long l1 = System.currentTimeMillis();
				if (l1 - this.lastUpdate > 100L) {
					long l2 = l1 - this.lastUpdate;
					this.lastUpdate = l1;
					this.x = paramSensorEvent.values[0];
					this.y = paramSensorEvent.values[1];
					float f = 0.0F;
					if (this.last_x != 0.0F)
						f = 10000.0F * (Math.abs(this.x + this.y - this.last_x
								- this.last_y) / (float) l2);
					if ((f > 1250.0F) && (l1 - this.lastShakeTime > 2000L)) {
						this.lastShakeTime = l1;
						ShakeMonitor.this.onShake();
					}
					this.last_x = this.x;
					this.last_y = this.y;
				}
			}
		};
	}

	public void disable() {
		if (this.sensorEventListener != null) {
			this.sensorManager.unregisterListener(this.sensorEventListener);
			this.sensorEventListener = null;
		}
	}

	public void enable() {
		Sensor localSensor = this.sensorManager.getDefaultSensor(1);
		makeSensorEventListener();
		this.sensorManager.registerListener(this.sensorEventListener,
				localSensor, 1);
	}

	public void onShake() {
		this.handler.onShake();
	}

	public static abstract interface ShakeHandler {
		public abstract void onShake();
	}
}
