package org.weixvn.wae.support;

import org.weixvn.wae.manager.EngineManager;

import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.DialogInterface.OnClickListener;
import android.os.AsyncTask;
import android.widget.Toast;

/**
 * WAEUpdateTask enables proper and easy use of the UI thread. This class allows
 * to perform background operations and publish results on the UI thread without
 * having to manipulate threads and/or handlers.
 * 
 * <pre>
 * 
 * WAEUpdateTask是一个抽象类，该类使开发者无需过多线程管理问题，使开发更加容易方便。
 * 当你使用该类时，你会发现该类提供了进度更新显示功能(以进度条的形式)。
 * 开发者要继承该类，并实现doInBackground方法。
 * 在doInBackground方法中开发者可以执行一些后台任务，
 * 如：发送Http请求,调用EngineManager.getInstance().getWebPageManager().updateWebPage()方法。
 * 每执行一项后台任务，都要调用一次publishProgress方法，更新进度条，如publishProgress(4)表明已执行完第４个任务。
 * 
 * 注：
 * １、开发者要在主线程中调用WAESupport类中的update方法，触发后台任务执行，即WAEUpdateTask子类的doInBackground方法开始执行。
 * ２、在弹出的进度条上会有“取消”按钮，一但软件使用者点击它，后台任务即开发者写在doInBackground方法中的任务，就有可能被取消执行。
 * @author weixvn
 * 
 */
public abstract class WAEUpdateTask extends
		AsyncTask<Integer, Integer, Integer> {
	ProgressDialog progressDlg = null;

	@Override
	protected void onPostExecute(Integer result) {
		super.onPostExecute(result);
		progressDlg.dismiss();
	}

	@Override
	protected void onPreExecute() {
		super.onPreExecute();
		progressDlg.show();

	}

	@Override
	protected void onProgressUpdate(Integer... values) {
		super.onProgressUpdate(values);
		progressDlg.setProgress(values[0]);
	}

	/**
	 * 初始化WAEUpdateTask类的一些信息，如：进度条标题、进度条内容、后台任务的数量
	 * 
	 * @param context
	 *            应用程序上下文，建议传入Activity.this
	 * @param title
	 *            进度条的标题
	 * @param message
	 *            进度条的内容
	 * @param max
	 *            任务的数量，可以是发送请求的次数
	 */
	public WAEUpdateTask initProgressDialog(final Context context,
			String title, String message, int max) {
		// progressDlg = new WAEProgressDialog(context);
		progressDlg = new ProgressDialog(context);
		if (title != null && !title.equals("")) {
			progressDlg.setTitle(title);
		} else {
			progressDlg.setTitle("微讯");
		}

		if (message != null && !message.equals("")) {
			progressDlg.setMessage(message);
		} else {
			progressDlg.setMessage("正在更新，请稍等！");
		}

		progressDlg.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
		progressDlg.setMax(max);

		progressDlg.setButton(ProgressDialog.BUTTON_NEGATIVE, "取消",
				new OnClickListener() {

					@Override
					public void onClick(DialogInterface dialog, int which) {
						WAEUpdateTask.this.cancel(true);
						Toast.makeText(context, "已取消更新", Toast.LENGTH_LONG)
								.show();

						EngineManager.getInstance().getWaeSupport().isTaskCancelled = true;
					}
				});
		return this;
	}

}
