package org.weixvn.wae.support;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup.LayoutParams;
import android.view.WindowManager;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;

public class WAEProgressDialog extends ProgressDialog {

	private ImageView img = null;
	private TextView title = null;
	private TextView msg = null;
	private TextView progress = null;
	private Context context = null;
	private ProgressBar progressBar = null;
	private Button btncalcel = null;

	public WAEProgressDialog(final Context context) {
		super(context);
		this.context = context;
		progressBar = new ProgressBar(context, null,
				android.R.attr.progressBarStyleHorizontal);
		img = new ImageView(context);
		progress = new TextView(context);
		title = new TextView(context);
		msg = new TextView(context);
		btncalcel = new Button(context);

		img.setImageResource(android.R.drawable.divider_horizontal_dark);
		// img.setImageDrawable(Drawable.)

		title.setText("微讯团队－进度更新");
		title.setTextSize(20);
		title.setGravity(Gravity.CENTER_HORIZONTAL);
		msg.setText("正在更新，请稍等！");
		msg.setTextSize(15);
		msg.setGravity(Gravity.CENTER_HORIZONTAL);
		progress.setGravity(Gravity.CENTER_HORIZONTAL);
		btncalcel.setText("取  消");
		// btncalcel.setLayoutParams(new LayoutParams(LayoutParams.WRAP_CONTENT,
		// LayoutParams.WRAP_CONTENT));
		btncalcel.setGravity(Gravity.CENTER_HORIZONTAL);
		btncalcel.setOnClickListener(new View.OnClickListener() {

			@Override
			public void onClick(View v) {
				// 取消ProgressDialog
				WAEProgressDialog.this.dismiss();
				Toast.makeText(context, "已取消更新", Toast.LENGTH_LONG).show();
			}

		});

		setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
	}

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// 获取手机屏幕尺寸
		DisplayMetrics dm = new DisplayMetrics();
		((Activity) context).getWindowManager().getDefaultDisplay()
				.getMetrics(dm);
		// 获取ProgressDialog默认布局参数
		WindowManager.LayoutParams paramsDlg = this.getWindow().getAttributes();

		// 获取ProgressDialog布局的宽、高
		paramsDlg.width = (int) (dm.widthPixels * 4.0 / 5);
		paramsDlg.height = (int) (dm.heightPixels * 3.0 / 4);
		this.getWindow().setAttributes(paramsDlg);

		LinearLayout layout = new LinearLayout(context);
		layout.setGravity(Gravity.CENTER_VERTICAL);
		layout.setOrientation(LinearLayout.VERTICAL);
		layout.setLayoutParams(new LayoutParams(LayoutParams.MATCH_PARENT,
				LayoutParams.MATCH_PARENT));

		layout.addView(title);
		layout.addView(msg);
		layout.addView(img);
		layout.addView(progressBar);
		layout.addView(progress);
		layout.addView(btncalcel);
		setContentView(layout);
	}

	@Override
	public void setProgress(int value) {
		super.setProgress(value);
		this.progressBar.setProgress(value);
		int max = this.progressBar.getMax();
		this.progress.setText(value * 1.0 / max * 100 + "%100  " + value + "/"
				+ max);
	}

	@Override
	public void setTitle(CharSequence title) {
		System.out.println("suspend");
		this.title.setText(title);
	}

	@Override
	public void setMessage(CharSequence message) {
		System.out.println("suspend");
		this.msg.setText(message);
	}

	@Override
	public void setMax(int max) {
		super.setMax(max);
		this.progressBar.setMax(max);
	}

	public void setImageDrawable(Drawable drawable) {
		img.setImageDrawable(drawable);
	}
}
